/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.filter.Optimization;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.resources.Errors;

public class MemoryFeatureSet
extends AbstractFeatureSet {
    protected final DefaultFeatureType baseType;
    protected final Set<DefaultFeatureType> allTypes;
    protected final Collection<AbstractFeature> features;

    public MemoryFeatureSet(Collection<AbstractFeature> features) {
        this(null, null, features);
    }

    public MemoryFeatureSet(Resource parent, DefaultFeatureType baseType, Collection<AbstractFeature> features) {
        super(parent);
        this.features = Objects.requireNonNull(features);
        this.allTypes = new HashSet<DefaultFeatureType>();
        if (baseType != null) {
            this.verifyFeatureInstances(baseType, true);
        } else {
            features.forEach(instance -> this.allTypes.add(instance.getType()));
            if (this.allTypes.isEmpty()) {
                throw new IllegalArgumentException(Errors.format((short)44, (Object)"features"));
            }
        }
        this.baseType = Features.findCommonParent(this.allTypes);
        if (this.baseType == null) {
            throw new IllegalArgumentException(Resources.format((short)75));
        }
    }

    private void verifyFeatureInstances(DefaultFeatureType baseType, boolean creating) {
        for (AbstractFeature feature : this.features) {
            DefaultFeatureType type = feature.getType();
            if (!this.allTypes.add(type) || baseType.isAssignableFrom(type)) continue;
            this.allTypes.clear();
            String message = Resources.format((short)86, baseType.getName(), type.getName());
            throw creating ? new IllegalArgumentException(message) : new IllegalStateException(message);
        }
        if (this.allTypes.isEmpty()) {
            this.allTypes.add(baseType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            this.allTypes.clear();
            this.verifyFeatureInstances(this.baseType, false);
        }
    }

    @Override
    public DefaultFeatureType getType() {
        return this.baseType;
    }

    @Override
    public OptionalLong getFeatureCount() {
        return OptionalLong.of(this.features.size());
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) {
        return parallel ? this.features.parallelStream() : this.features.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareQueryOptimization(FeatureQuery query, Optimization optimizer) throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            optimizer.setFinalFeatureTypes(this.allTypes);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            MemoryFeatureSet other = (MemoryFeatureSet)obj;
            return this.baseType.equals((Object)other.baseType) && this.features.equals(other.features) && this.listeners.equals(other.listeners);
        }
        return false;
    }

    public int hashCode() {
        return this.baseType.hashCode() + 31 * this.features.hashCode() + 37 * this.listeners.hashCode();
    }
}

