/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;

abstract class MimeTypeDetector {
    private final Map<String, String> mimeForNameSpaces;
    private final Map<String, String> mimeForRootElements;
    private static final byte[] XMLNS = new byte[]{120, 109, 108, 110, 115};
    private static final int MAX_ASCII = 126;
    private byte[] buffer = new byte[32];
    private int length;
    boolean insufficientBytes;

    MimeTypeDetector(Map<String, String> mimeForNameSpaces, Map<String, String> mimeForRootElements) {
        this.mimeForNameSpaces = mimeForNameSpaces;
        this.mimeForRootElements = mimeForRootElements;
    }

    private String current() throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.length, "US-ASCII");
    }

    private void remember(int c) {
        if (this.length >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.length * 2);
        }
        this.buffer[this.length++] = (byte)c;
    }

    abstract int read() throws IOException;

    private int readAfter(int search) throws IOException {
        int c;
        boolean isQuote = false;
        while ((c = this.read()) >= 0) {
            if (c == 34) {
                isQuote = !isQuote;
                continue;
            }
            if (c != search || isQuote) continue;
            return this.read();
        }
        return -1;
    }

    private int afterSpaces(int c) throws IOException {
        while (c <= 32 && c >= 0) {
            c = this.read();
        }
        return c;
    }

    private int matches(byte[] word, int n, int c, char separator) throws IOException {
        if (c >= 0) {
            for (int i = 0; i < n; ++i) {
                if (c != word[i]) {
                    return c >= 0 ? 0 : -1;
                }
                c = this.read();
            }
            if ((c = this.afterSpaces(c)) >= 0) {
                return c == separator ? 1 : 0;
            }
        }
        return -1;
    }

    final String getMimeType() throws IOException {
        int c;
        block16: {
            String rootElement;
            if (this.readAfter(63) != 62) {
                return null;
            }
            while ((c = this.readAfter(60)) == 33) {
                do {
                    c = this.readAfter(45);
                    while (c == 45) {
                        c = this.read();
                    }
                    if (c >= 0) continue;
                    return null;
                } while (c != 62);
            }
            c = this.afterSpaces(c);
            while (c > 32 && c != 58) {
                if (c == 62 || c > 126) {
                    return null;
                }
                this.remember(c);
                c = this.read();
            }
            if ((c = this.afterSpaces(c)) != 58) {
                rootElement = this.current();
                this.length = 0;
            } else {
                rootElement = null;
                c = this.afterSpaces(this.read());
            }
            do {
                int m;
                if ((m = this.matches(XMLNS, XMLNS.length, c, this.length == 0 ? (char)'=' : ':')) == 0) continue;
                if (m < 0) {
                    return null;
                }
                if (this.length != 0) {
                    m = this.matches(this.buffer, this.length, this.afterSpaces(this.read()), '=');
                    if (m == 0) continue;
                    if (m < 0) {
                        return null;
                    }
                }
                break block16;
            } while ((c = this.afterSpaces(this.read())) >= 0 && c != 62);
            if (c >= 0 && rootElement != null) {
                return this.mimeForRootElements.get(rootElement);
            }
            return null;
        }
        this.length = 0;
        c = this.afterSpaces(this.read());
        if (c != 34) {
            return null;
        }
        c = this.afterSpaces(this.read());
        do {
            if (c < 0 || c > 126) {
                return null;
            }
            this.remember(c);
        } while ((c = this.read()) != 34);
        return this.mimeForNameSpaces.get(this.current());
    }

    final ProbeResult probeContent() throws DataStoreException {
        String mimeType;
        boolean isSupported = true;
        try {
            mimeType = this.getMimeType();
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        if (mimeType == null) {
            if (this.insufficientBytes) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            isSupported = false;
            mimeType = "application/xml";
        }
        return new ProbeResult(isSupported, mimeType, null);
    }
}

