/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder.impl;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.request.builder.SlingJakartaHttpServletResponseResult;
import org.apache.sling.api.request.builder.impl.HeaderSupport;
import org.jetbrains.annotations.NotNull;

public class SlingJakartaHttpServletResponseResultImpl
extends SlingAdaptable
implements SlingJakartaHttpServletResponseResult {
    private final HeaderSupport headerSupport = new HeaderSupport();
    private final Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
    private String contentType;
    private String characterEncoding;
    private Locale locale = Locale.US;
    private long contentLength;
    private int status;
    private boolean isCommitted;
    private String statusMessage;
    private int bufferSize = 8192;
    private ByteArrayOutputStream outputStream;
    private ServletOutputStream servletOutputStream;
    private PrintWriter printWriter;

    public SlingJakartaHttpServletResponseResultImpl() {
        this.reset();
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed.");
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public String getContentType() {
        if (this.contentType == null) {
            return null;
        }
        if (this.characterEncoding == null) {
            return this.contentType;
        }
        return this.contentType.concat(";charset=").concat(this.characterEncoding);
    }

    public void setContentType(String type) {
        if (this.printWriter == null) {
            int pos;
            int n = pos = type == null ? -1 : type.indexOf(";charset=");
            if (pos != -1) {
                this.contentType = type.substring(0, pos);
                this.characterEncoding = type.substring(pos + ";charset=".length());
            } else {
                this.contentType = type;
            }
        }
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentLengthLong(long len) {
        this.contentLength = len;
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public int getStatus() {
        return this.status;
    }

    public void sendError(int sc, String msg) {
        this.setStatus(sc);
        this.statusMessage = msg;
        this.isCommitted = true;
    }

    public void sendError(int sc) {
        this.setStatus(sc);
        this.statusMessage = null;
        this.isCommitted = true;
    }

    public void sendRedirect(String location) {
        this.sendRedirect(location, 302, true);
    }

    public void addHeader(String name, String value) {
        this.headerSupport.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headerSupport.addIntHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        this.headerSupport.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.headerSupport.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headerSupport.setIntHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.headerSupport.setDateHeader(name, date);
    }

    public boolean containsHeader(String name) {
        return this.headerSupport.containsHeader(name);
    }

    public String getHeader(String name) {
        return this.headerSupport.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.headerSupport.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this.headerSupport.getHeaderNames();
    }

    private Charset getCharset() {
        if (this.characterEncoding == null) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(this.characterEncoding);
    }

    public PrintWriter getWriter() {
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharset()));
        }
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() {
        if (this.servletOutputStream == null) {
            this.servletOutputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    SlingJakartaHttpServletResponseResultImpl.this.outputStream.write(b);
                }

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.servletOutputStream;
    }

    public void reset() {
        this.checkCommitted();
        this.cookies.clear();
        this.headerSupport.reset();
        this.status = 200;
        this.contentLength = -1L;
        this.statusMessage = null;
        this.resetBuffer();
    }

    public void resetBuffer() {
        this.checkCommitted();
        this.outputStream = new ByteArrayOutputStream();
        this.servletOutputStream = null;
        this.printWriter = null;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void flushBuffer() {
        this.isCommitted = true;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public Cookie getCookie(String name) {
        return this.cookies.get(name);
    }

    @Override
    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        return this.cookies.values().toArray(new Cookie[this.cookies.size()]);
    }

    @Override
    public byte[] getOutput() {
        this.isCommitted = true;
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        if (this.servletOutputStream != null) {
            try {
                this.servletOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.outputStream.toByteArray();
    }

    @Override
    @NotNull
    public String getOutputAsString() {
        this.isCommitted = true;
        return new String(this.getOutput(), this.getCharset());
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException();
    }

    public void sendRedirect(String location, int sc, boolean clearBuffer) {
        if (clearBuffer) {
            this.resetBuffer();
        }
        this.setStatus(sc);
        this.statusMessage = null;
        this.setHeader("Location", location);
        this.isCommitted = true;
    }
}

