/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

public class MergingValueMap
implements ValueMap {
    private static final String IMMUTABLE_ERROR_MESSAGE = "MergingValueMap is immutable";
    private final List<ValueMap> valueMaps;

    public MergingValueMap(@NotNull List<ValueMap> valueMaps) {
        this.valueMaps = Collections.unmodifiableList(new ArrayList<ValueMap>(valueMaps));
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyStream().anyMatch(k -> Objects.equals(k, key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueStream().anyMatch(v -> Objects.equals(v, value));
    }

    @Override
    public Object get(Object key) {
        return this.valueMaps.stream().filter(vm -> vm.containsKey(key)).findFirst().map(vm -> vm.get(key)).orElse(null);
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.keyStream().collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<Object> values() {
        return this.valueStream().collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.keyStream().map(key -> new AbstractMap.SimpleEntry<String, Object>((String)key, this.get(key))).collect(Collectors.toSet());
    }

    @NotNull
    private Stream<String> keyStream() {
        return this.valueMaps.stream().map(Map::keySet).flatMap(Collection::stream).distinct();
    }

    @NotNull
    private Stream<Object> valueStream() {
        return this.keyStream().map(this::get);
    }

    @Override
    public Object put(String aKey, Object value) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    @Override
    public void putAll(Map<? extends String, ?> properties) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }
}

