/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.api;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.auth.xing.api.XingUserManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXingUserManager
implements XingUserManager {
    protected boolean autoCreateUser;
    protected boolean autoUpdateUser;
    protected Session session;
    public static final boolean DEFAULT_AUTO_CREATE_USER = true;
    public static final boolean DEFAULT_AUTO_UPDATE_USER = false;
    private final Logger logger = LoggerFactory.getLogger(AbstractXingUserManager.class);

    protected abstract SlingRepository getSlingRepository();

    @Override
    public boolean autoCreate() {
        return this.autoCreateUser;
    }

    @Override
    public boolean autoUpdate() {
        return this.autoUpdateUser;
    }

    @Override
    public User getUser(Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            SimpleCredentials simpleCredentials = (SimpleCredentials)credentials;
            String userId = simpleCredentials.getUserID();
            return this.getUser(userId);
        }
        return null;
    }

    protected User getUser(String userId) {
        this.logger.info("getting user with id '{}'", (Object)userId);
        try {
            Session session = this.getSession();
            UserManager userManager = this.getUserManager(session);
            Authorizable authorizable = userManager.getAuthorizable(userId);
            if (authorizable != null) {
                if (authorizable instanceof User) {
                    User user = (User)authorizable;
                    this.logger.debug("user for id '{}' found", (Object)userId);
                    return user;
                }
                this.logger.debug("found authorizable with id '{}' is not an user", (Object)authorizable.getID());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected synchronized Session getSession() throws RepositoryException {
        if (this.session == null || !this.session.isLive()) {
            this.session = this.getSlingRepository().loginService(null, null);
        }
        return this.session;
    }

    protected UserManager getUserManager(Session session) throws RepositoryException {
        if (session instanceof JackrabbitSession) {
            JackrabbitSession jackrabbitSession = (JackrabbitSession)session;
            return jackrabbitSession.getUserManager();
        }
        this.logger.error("Cannot get UserManager from session: not a Jackrabbit session");
        return null;
    }
}

