/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.app;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.apache.sling.launchpad.app.Main;

class ControlListener
implements Runnable {
    static final String COMMAND_STOP = "stop";
    static final String COMMAND_STATUS = "status";
    static final String COMMAND_THREADS = "threads";
    private static final String RESPONSE_OK = "OK";
    private static final String RESPONSE_STOPPING = "STOPPING";
    private static final String DEFAULT_LISTEN_INTERFACE = "127.0.0.1";
    private static final int DEFAULT_LISTEN_PORT = 0;
    private final Main slingMain;
    private final String listenSpec;
    private String secretKey;
    private InetSocketAddress socketAddress;
    private volatile Thread shutdownThread = null;

    ControlListener(Main slingMain, String listenSpec) {
        this.slingMain = slingMain;
        this.listenSpec = listenSpec;
    }

    boolean listen() {
        File configFile = this.getConfigFile();
        if (configFile.canRead() && this.statusServer() == 0) {
            Main.error("Sling already active in " + this.slingMain.getSlingHome(), null);
            return false;
        }
        configFile.delete();
        Thread listener = new Thread(this);
        listener.setDaemon(true);
        listener.setName("Apache Sling Control Listener (inactive)");
        listener.start();
        return true;
    }

    int shutdownServer() {
        return this.sendCommand(COMMAND_STOP);
    }

    int statusServer() {
        return this.sendCommand(COMMAND_STATUS);
    }

    int dumpThreads() {
        return this.sendCommand(COMMAND_THREADS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block43: {
            ServerSocket server;
            this.configure(false);
            try {
                server = new ServerSocket();
                server.bind(this.socketAddress);
                ControlListener.writePortToConfigFile(this.getConfigFile(), new InetSocketAddress(server.getInetAddress(), server.getLocalPort()), this.secretKey);
                Thread.currentThread().setName("Apache Sling Control Listener@" + server.getInetAddress() + ":" + server.getLocalPort());
                Main.info("Apache Sling Control Listener started", null);
            }
            catch (IOException ioe) {
                Main.error("Failed to start Apache Sling Control Listener", ioe);
                return;
            }
            long delay = 0L;
            block33: while (true) {
                while (true) {
                    Socket s;
                    try {
                        s = server.accept();
                    }
                    catch (IOException ioe) {
                        break block43;
                    }
                    if (delay > 0L) {
                        Main.info(s.getRemoteSocketAddress() + ": Delay: " + delay / 1000L, null);
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    try {
                        String msg;
                        String commandLine = this.readLine(s);
                        if (commandLine == null) {
                            String msg2 = "ERR: missing command";
                            this.writeLine(s, "ERR: missing command");
                            continue;
                        }
                        int blank = commandLine.indexOf(32);
                        if (blank < 0) {
                            msg = "ERR: missing key";
                            this.writeLine(s, "ERR: missing key");
                            continue;
                        }
                        if (!this.secretKey.equals(commandLine.substring(0, blank))) {
                            msg = "ERR: wrong key";
                            this.writeLine(s, "ERR: wrong key");
                            delay = delay > 0L ? delay * 2L : 1000L;
                            continue;
                        }
                        String command = commandLine.substring(blank + 1);
                        Main.info(s.getRemoteSocketAddress() + ">" + command, null);
                        if (COMMAND_STOP.equals(command)) {
                            if (this.shutdownThread != null) {
                                this.writeLine(s, RESPONSE_STOPPING);
                                continue block33;
                            }
                            this.shutdownThread = new Thread("Apache Sling Control Listener: Shutdown"){

                                @Override
                                public void run() {
                                    ControlListener.this.slingMain.doStop();
                                    try {
                                        server.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            };
                            this.shutdownThread.start();
                            this.writeLine(s, RESPONSE_OK);
                            continue block33;
                        }
                        if (COMMAND_STATUS.equals(command)) {
                            this.writeLine(s, this.shutdownThread == null ? RESPONSE_OK : RESPONSE_STOPPING);
                            continue block33;
                        }
                        if (COMMAND_THREADS.equals(command)) {
                            this.dumpThreads(s);
                            continue block33;
                        }
                        String msg3 = "ERR:" + command;
                        this.writeLine(s, msg3);
                        continue block33;
                    }
                    finally {
                        try {
                            s.close();
                        }
                        catch (IOException ignore) {}
                        continue;
                    }
                    break;
                }
                break;
            }
            catch (IOException ioe) {
                Main.error("Failure reading from client", ioe);
                break block43;
            }
            finally {
                try {
                    server.close();
                }
                catch (IOException ignore) {}
            }
        }
        this.getConfigFile().delete();
        Main.info("Apache Sling terminated, exiting Java VM", null);
        this.slingMain.terminateVM(0);
    }

    private void dumpThreads(Socket socket) throws IOException {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo thread : threadInfos = threadBean.dumpAllThreads(true, true)) {
            this.printThread(socket, thread);
            LockInfo[] locks = thread.getLockedSynchronizers();
            this.writeLine(socket, "-");
            this.writeLine(socket, "-   Locked ownable synchronizers:");
            if (locks.length > 0) {
                for (LockInfo li : locks) {
                    this.writeLine(socket, String.format("-        - locked %s", this.formatLockInfo(li.getClassName(), li.getIdentityHashCode())));
                }
            } else {
                this.writeLine(socket, "-        - None");
            }
            this.writeLine(socket, "-");
        }
        long[] deadLocked = threadBean.isSynchronizerUsageSupported() ? threadBean.findDeadlockedThreads() : threadBean.findMonitorDeadlockedThreads();
        if (deadLocked != null) {
            ThreadInfo[] dl = threadBean.getThreadInfo(deadLocked, true, true);
            HashSet<ThreadInfo> dlSet = new HashSet<ThreadInfo>(Arrays.asList(dl));
            int deadlockCount = 0;
            for (ThreadInfo current : dl) {
                if (!dlSet.remove(current)) continue;
                ArrayList<ThreadInfo> loop = new ArrayList<ThreadInfo>();
                block3: do {
                    loop.add(current);
                    for (ThreadInfo cand : dl) {
                        if (cand.getThreadId() != current.getLockOwnerId()) continue;
                        current = dlSet.remove(cand) ? cand : null;
                        continue block3;
                    }
                } while (current != null);
                ++deadlockCount;
                this.writeLine(socket, "-Found one Java-level deadlock:");
                this.writeLine(socket, "-=============================");
                for (ThreadInfo thread : loop) {
                    this.writeLine(socket, String.format("-\"%s\" #%d", thread.getThreadName(), thread.getThreadId()));
                    this.writeLine(socket, String.format("-  waiting on %s", this.formatLockInfo(thread.getLockInfo().getClassName(), thread.getLockInfo().getIdentityHashCode())));
                    this.writeLine(socket, String.format("-  which is held by \"%s\" #%d", thread.getLockOwnerName(), thread.getLockOwnerId()));
                }
                this.writeLine(socket, "-");
                this.writeLine(socket, "-Java stack information for the threads listed above:");
                this.writeLine(socket, "-===================================================");
                for (ThreadInfo thread : loop) {
                    this.printThread(socket, thread);
                }
                this.writeLine(socket, "-");
            }
            this.writeLine(socket, String.format("-Found %d deadlocks.", deadlockCount));
        }
        this.writeLine(socket, RESPONSE_OK);
    }

    private String formatLockInfo(String className, int objectId) {
        return String.format("<%08x> (a %s)", objectId, className);
    }

    private void printThread(Socket socket, ThreadInfo thread) throws IOException {
        this.writeLine(socket, String.format("-\"%s\" #%d", thread.getThreadName(), thread.getThreadId()));
        this.writeLine(socket, String.format("-    java.lang.Thread.State: %s", new Object[]{thread.getThreadState()}));
        MonitorInfo[] monitors = thread.getLockedMonitors();
        StackTraceElement[] trace = thread.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement ste = trace[i];
            if (ste.isNativeMethod()) {
                this.writeLine(socket, String.format("-        at %s.%s(Native Method)", ste.getClassName(), ste.getMethodName()));
            } else {
                this.writeLine(socket, String.format("-        at %s.%s(%s:%d)", ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber()));
            }
            if (i == 0 && thread.getLockInfo() != null) {
                this.writeLine(socket, String.format("-        - waiting on %s%s", this.formatLockInfo(thread.getLockInfo().getClassName(), thread.getLockInfo().getIdentityHashCode()), thread.getLockOwnerId() >= 0L ? String.format(" owned by \"%s\" #%d", thread.getLockOwnerName(), thread.getLockOwnerId()) : ""));
            }
            for (MonitorInfo mi : monitors) {
                if (i != mi.getLockedStackDepth()) continue;
                this.writeLine(socket, String.format("-        - locked %s", this.formatLockInfo(mi.getClassName(), mi.getIdentityHashCode())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendCommand(String command) {
        if (this.configure(true)) {
            if (this.secretKey == null) {
                Main.info("Missing secret key to protect sending '" + command + "' to " + this.socketAddress, null);
                return 4;
            }
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(this.socketAddress);
                this.writeLine0(socket, this.secretKey + " " + command);
                String result = this.readLine(socket);
                Main.info("Sent '" + command + "' to " + this.socketAddress + ": " + result, null);
                int n = 0;
                return n;
            }
            catch (ConnectException ce) {
                Main.info("No Apache Sling running at " + this.socketAddress, null);
                int n = 3;
                return n;
            }
            catch (IOException ioe) {
                Main.error("Failed sending '" + command + "' to " + this.socketAddress, ioe);
                int n = 1;
                return n;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        Main.info("No socket address to send '" + command + "' to", null);
        return 4;
    }

    private String readLine(Socket socket) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        StringBuilder b = new StringBuilder();
        boolean more = true;
        while (more) {
            String s = br.readLine();
            if (s != null && s.startsWith("-")) {
                s = s.substring(1);
            } else {
                more = false;
            }
            if (b.length() > 0) {
                b.append("\r\n");
            }
            b.append(s);
        }
        return b.toString();
    }

    private void writeLine(Socket socket, String line) throws IOException {
        Main.info(socket.getRemoteSocketAddress() + "<" + line, null);
        this.writeLine0(socket, line);
    }

    private void writeLine0(Socket socket, String line) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        bw.write(line);
        bw.write("\r\n");
        bw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configure(boolean fromConfigFile) {
        boolean result = false;
        if (fromConfigFile) {
            File configFile = this.getConfigFile();
            if (configFile.canRead()) {
                FileReader fr = null;
                try {
                    fr = new FileReader(configFile);
                    LineNumberReader lnr = new LineNumberReader(fr);
                    this.socketAddress = ControlListener.getSocketAddress(lnr.readLine());
                    this.secretKey = lnr.readLine();
                    result = true;
                }
                catch (IOException ignore) {
                }
                finally {
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
        } else {
            this.socketAddress = ControlListener.getSocketAddress(this.listenSpec);
            this.secretKey = ControlListener.generateKey();
            result = true;
        }
        return result;
    }

    private static String generateKey() {
        String keys = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789";
        int len = keys.length();
        Random r = new Random(System.currentTimeMillis() + 33L * System.nanoTime());
        char[] c = new char[32];
        for (int i = 0; i < c.length; ++i) {
            c[i] = keys.charAt(r.nextInt(len));
        }
        return new String(c);
    }

    private File getConfigFile() {
        File configDir = new File(this.slingMain.getSlingHome(), "conf");
        return new File(configDir, "controlport");
    }

    private static InetSocketAddress getSocketAddress(String listenSpec) {
        try {
            int port;
            String address;
            if (listenSpec == null) {
                address = DEFAULT_LISTEN_INTERFACE;
                port = 0;
            } else {
                int colon = listenSpec.indexOf(58);
                if (colon < 0) {
                    address = DEFAULT_LISTEN_INTERFACE;
                    port = Integer.parseInt(listenSpec);
                } else {
                    address = listenSpec.substring(0, colon);
                    port = Integer.parseInt(listenSpec.substring(colon + 1));
                }
            }
            InetSocketAddress addr = new InetSocketAddress(address, port);
            if (!addr.isUnresolved()) {
                return addr;
            }
            Main.error("Unknown host in '" + listenSpec, null);
        }
        catch (NumberFormatException nfe) {
            Main.error("Cannot parse port number from '" + listenSpec + "'", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePortToConfigFile(File configFile, InetSocketAddress socketAddress, String secretKey) {
        configFile.getParentFile().mkdirs();
        FileWriter fw = null;
        try {
            fw = new FileWriter(configFile);
            fw.write(socketAddress.getAddress().getHostAddress());
            fw.write(58);
            fw.write(String.valueOf(socketAddress.getPort()));
            fw.write(10);
            fw.write(secretKey);
            fw.write(10);
        }
        catch (IOException ignore) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

