/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueueUtils;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.apache.sling.distribution.util.impl.DistributionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceQueue
implements DistributionQueue {
    private static final Set<String> CAPABILITIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("appendable", "removable", "clearable")));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ResourceResolverFactory resolverFactory;
    protected final String queueRootPath;
    protected String serviceName;
    protected String queueName;

    public ResourceQueue(ResourceResolverFactory resolverFactory, String serviceName, String queueName, String rootPath) {
        this.resolverFactory = resolverFactory;
        this.serviceName = serviceName;
        this.queueName = queueName;
        this.queueRootPath = rootPath + "/" + queueName;
        this.log.debug("starting a Resource Queue {}", (Object)queueName);
    }

    @Override
    @NotNull
    public String getName() {
        return this.queueName;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public DistributionQueueEntry add(@NotNull DistributionQueueItem item) {
        DistributionQueueEntry distributionQueueEntry;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource queueRoot = ResourceQueueUtils.getRootResource(resourceResolver, this.queueRootPath);
            Resource resource = ResourceQueueUtils.createResource(queueRoot, item);
            DistributionQueueEntry entry = ResourceQueueUtils.readEntry(queueRoot, resource);
            this.logEntry(entry, "add");
            distributionQueueEntry = entry;
        }
        catch (LoginException e) {
            try {
                throw new RuntimeException(e);
                catch (PersistenceException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
        }
        DistributionUtils.safelyLogout(resourceResolver);
        return distributionQueueEntry;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DistributionQueueEntry getHead() {
        DistributionQueueEntry distributionQueueEntry;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource queueRoot = ResourceQueueUtils.getRootResource(resourceResolver, this.queueRootPath);
            DistributionQueueEntry head = ResourceQueueUtils.getHead(queueRoot);
            this.logEntry(head, "getHead");
            distributionQueueEntry = head;
        }
        catch (LoginException e) {
            try {
                throw new RuntimeException(e);
                catch (PersistenceException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
        }
        DistributionUtils.safelyLogout(resourceResolver);
        return distributionQueueEntry;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Iterable<DistributionQueueEntry> getEntries(int skip, int limit) {
        List<DistributionQueueEntry> list;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource queueRoot = ResourceQueueUtils.getRootResource(resourceResolver, this.queueRootPath);
            List<DistributionQueueEntry> entries = ResourceQueueUtils.getEntries(queueRoot, skip, limit);
            this.log.debug("queue[{}] getEntries entries={}", (Object)this.queueName, (Object)entries.size());
            list = entries;
        }
        catch (LoginException e) {
            try {
                throw new RuntimeException(e);
                catch (PersistenceException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
        }
        DistributionUtils.safelyLogout(resourceResolver);
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public DistributionQueueEntry getEntry(@NotNull String itemId) {
        DistributionQueueEntry distributionQueueEntry;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource queueRoot = ResourceQueueUtils.getRootResource(resourceResolver, this.queueRootPath);
            Resource itemResource = ResourceQueueUtils.getResourceById(queueRoot, itemId);
            DistributionQueueEntry entry = ResourceQueueUtils.readEntry(queueRoot, itemResource);
            this.logEntry(entry, "getEntry");
            distributionQueueEntry = entry;
        }
        catch (LoginException e) {
            try {
                throw new RuntimeException(e);
                catch (PersistenceException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
        }
        DistributionUtils.safelyLogout(resourceResolver);
        return distributionQueueEntry;
    }

    @Override
    @NotNull
    public Iterable<DistributionQueueEntry> remove(@NotNull Set<String> entryIds) {
        ArrayList<DistributionQueueEntry> removed = new ArrayList<DistributionQueueEntry>();
        for (String entryId : entryIds) {
            DistributionQueueEntry entry = this.remove(entryId);
            if (entry == null) continue;
            removed.add(entry);
        }
        return removed;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public DistributionQueueEntry remove(@NotNull String itemId) {
        DistributionQueueEntry distributionQueueEntry;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource queueRoot = ResourceQueueUtils.getRootResource(resourceResolver, this.queueRootPath);
            Resource itemResource = ResourceQueueUtils.getResourceById(queueRoot, itemId);
            DistributionQueueEntry entry = ResourceQueueUtils.readEntry(queueRoot, itemResource);
            ResourceQueueUtils.deleteResource(itemResource);
            this.logEntry(entry, "remove");
            distributionQueueEntry = entry;
        }
        catch (LoginException e) {
            try {
                throw new RuntimeException(e);
                catch (PersistenceException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
        }
        DistributionUtils.safelyLogout(resourceResolver);
        return distributionQueueEntry;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public DistributionQueueStatus getStatus() {
        DistributionQueueStatus distributionQueueStatus;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource queueRoot = ResourceQueueUtils.getRootResource(resourceResolver, this.queueRootPath);
            int count = ResourceQueueUtils.getResourceCount(queueRoot);
            distributionQueueStatus = new DistributionQueueStatus(count, DistributionQueueState.PASSIVE);
        }
        catch (LoginException e) {
            try {
                throw new RuntimeException(e);
                catch (PersistenceException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
        }
        DistributionUtils.safelyLogout(resourceResolver);
        return distributionQueueStatus;
    }

    @Override
    @NotNull
    public DistributionQueueType getType() {
        return DistributionQueueType.ORDERED;
    }

    void logEntry(DistributionQueueEntry entry, String scope) {
        if (entry == null) {
            this.log.debug("queue[{}] {} null entry", new Object[]{this.queueName, scope});
            return;
        }
        if (entry.getItem() == null) {
            this.log.debug("queue[{}] {} null item (should not happen)", new Object[]{this.queueName, scope});
            return;
        }
        String entryId = entry.getId();
        DistributionQueueItem item = entry.getItem();
        this.log.debug("queue[{}] {} entryId={} packageId={}", new Object[]{this.queueName, scope, entryId, item.getPackageId()});
    }

    @Override
    @NotNull
    public Iterable<DistributionQueueEntry> clear(int limit) {
        ArrayList<DistributionQueueEntry> removedEntries = new ArrayList<DistributionQueueEntry>();
        for (DistributionQueueEntry entry : this.getEntries(0, limit)) {
            DistributionQueueEntry removed = this.remove(entry.getId());
            if (removed == null) continue;
            removedEntries.add(removed);
        }
        return removedEntries;
    }

    @Override
    public boolean hasCapability(@NotNull String capability) {
        return CAPABILITIES.contains(capability);
    }
}

