/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.webconsolesecurityprovider.internal;

import java.util.Iterator;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.extensions.webconsolesecurityprovider.internal.AbstractWebConsoleSecurityProvider;

public class SlingWebConsoleSecurityProvider
extends AbstractWebConsoleSecurityProvider {
    private Repository repository;

    public SlingWebConsoleSecurityProvider(Object repository) {
        this.repository = (Repository)repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object authenticate(String userName, String password) {
        SimpleCredentials creds = new SimpleCredentials(userName, password == null ? new char[]{} : password.toCharArray());
        Session session = null;
        try {
            session = this.repository.login((Credentials)creds);
            if (session instanceof JackrabbitSession) {
                String userId;
                UserManager umgr = ((JackrabbitSession)session).getUserManager();
                Authorizable a = umgr.getAuthorizable(userId = session.getUserID());
                if (a instanceof User) {
                    if (this.users.contains(userId)) {
                        Boolean bl = true;
                        return bl;
                    }
                    Iterator gi = a.memberOf();
                    while (gi.hasNext()) {
                        if (!this.groups.contains(((Group)gi.next()).getID())) continue;
                        String string = userName;
                        return string;
                    }
                    this.logger.debug("authenticate: User {} is denied Web Console access", (Object)userName);
                } else {
                    this.logger.error("authenticate: Expected user ID {} to refer to a user", (Object)userId);
                }
            } else {
                this.logger.info("authenticate: Jackrabbit Session required to grant access to the Web Console for {}; got {}", (Object)userName, session.getClass());
            }
        }
        catch (LoginException re) {
            this.logger.info("authenticate: User " + userName + " failed to authenticate with the repository for Web Console access", (Throwable)re);
        }
        catch (Exception re) {
            this.logger.info("authenticate: Generic problem trying grant User " + userName + " access to the Web Console", (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    public boolean authorize(Object user, String role) {
        this.logger.debug("authorize: Grant user {} access for role {}", user, (Object)role);
        return true;
    }
}

