/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.apiregions.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.sling.feature.apiregions.impl.RegionConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class RegionPrinter {
    static final String HEADLINE = "Sling Feature - API Regions";
    static final String PATH = "feature_apiregions";
    private RegionConfiguration config;
    private BundleContext context;

    public RegionPrinter(BundleContext context, RegionConfiguration config) {
        this.context = context;
        this.config = config;
    }

    private void renderPackageMappings(PrintWriter pw) {
        Map<String, Set<String>> regionPackageMap = this.config.getRegionPackageMap();
        regionPackageMap.keySet().stream().sorted().forEach(region -> {
            pw.println(String.format("\n%s:", region));
            ((Set)regionPackageMap.get(region)).stream().sorted().forEach(pkg -> pw.println(" - " + pkg));
        });
    }

    private void renderBundleMappings(PrintWriter pw) {
        Map<String, List<String>> featureRegions = this.config.getFeatureRegionMap();
        Map<String, Set<String>> bundlesToFeatures = this.config.getBundleFeatureMap();
        ConcurrentMap<String, Map.Entry<String, Version>> bundleLocations = this.config.getBundleLocationConfigMap();
        bundlesToFeatures.keySet().stream().sorted().forEach(bundle -> {
            HashSet regions = new HashSet();
            ((Set)bundlesToFeatures.get(bundle)).stream().forEach(feature -> Optional.ofNullable((List)featureRegions.get(feature)).ifPresent(regions::addAll));
            String location = Optional.ofNullable((Map.Entry)bundleLocations.get(bundle)).map(loc -> (String)loc.getKey() + "v" + ((Version)loc.getValue()).toString()).orElse("null");
            pw.println(String.format(" - %s\n\t - features: %s\n\t - regions: %s\n\t - location: %s", bundle, ((Set)bundlesToFeatures.get(bundle)).stream().collect(Collectors.joining(",")), regions.stream().collect(Collectors.joining(",")), location));
        });
    }

    private void renderHeader(PrintWriter pw, String header) {
        pw.println("\n\n" + header + "\n-------------------\n");
    }

    private void renderProperties(PrintWriter pw) {
        String[] properties = new String[]{"org.apache.sling.feature.apiregions.regions", "sling.feature.apiregions.joinglobal", "sling.feature.apiregions.default", "sling.feature.apiregions.location"};
        Arrays.stream(properties).forEach(p -> pw.println(String.format(" - %s=%s", p, this.context.getProperty(p))));
    }

    private void printAll(Collection<String> op, PrintWriter pw) {
        Optional.ofNullable(op).ifPresent(values -> values.forEach(v -> pw.println(" - " + v)));
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Sling Feature - API Regions\n===========================");
        if (this.config != null) {
            this.renderHeader(pw, "Default Regions");
            this.printAll(this.config.getDefaultRegions(), pw);
            this.renderHeader(pw, "Region Order");
            this.printAll(this.config.getGlobalRegionOrder(), pw);
            this.renderHeader(pw, "Properties");
            this.renderProperties(pw);
            this.renderHeader(pw, "Packages per Region");
            this.renderPackageMappings(pw);
            this.renderHeader(pw, "Bundle Mappings");
            this.renderBundleMappings(pw);
        } else {
            pw.println("\n\nConfiguration not available");
        }
    }
}

