/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.launcher;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.extension.apiregions.launcher.LauncherProperties;
import org.apache.sling.feature.launcher.impl.launchers.FrameworkLauncher;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.LauncherRunContext;

public class RegionLauncher
extends FrameworkLauncher {
    public static final String IDBSNVER_FILENAME = "idbsnver.properties";
    public static final String BUNDLE_FEATURE_FILENAME = "bundles.properties";

    public void prepare(LauncherPrepareContext context, ArtifactId frameworkId, Feature app) throws Exception {
        super.prepare(context, frameworkId, app);
        ArtifactProvider artifactProvider = id -> {
            try {
                return context.getArtifactFile(id);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        File base = File.createTempFile("apiregions", ".properties");
        base.delete();
        base.mkdirs();
        File idbsnverFile = new File(base, IDBSNVER_FILENAME);
        File bundlesFile = new File(base, BUNDLE_FEATURE_FILENAME);
        LauncherProperties.save(LauncherProperties.getBundleIDtoBSNandVersionMap(app, artifactProvider), idbsnverFile);
        LauncherProperties.save(LauncherProperties.getBundleIDtoFeaturesMap(app), bundlesFile);
        app.getFrameworkProperties().put("sling.feature.apiregions.resource.idbsnver.properties", idbsnverFile.toURI().toURL().toString());
        app.getFrameworkProperties().put("sling.feature.apiregions.resource.bundles.properties", bundlesFile.toURI().toURL().toString());
    }

    public int run(LauncherRunContext context, ClassLoader cl) throws Exception {
        return super.run(context, cl);
    }
}

