/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api;

import java.util.List;
import relocated_for_contentpackage.javax.jcr.Item;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.FilterSet;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ItemFilter;

public class ItemFilterSet
extends FilterSet<ItemFilter> {
    public static final ItemFilterSet INCLUDE_ALL = (ItemFilterSet)new ItemFilterSet().addInclude(ItemFilter.ALL).seal();
    public static final ItemFilterSet EXCLUDE_ALL = (ItemFilterSet)new ItemFilterSet().addExclude(ItemFilter.ALL).seal();

    public ItemFilterSet() {
    }

    public ItemFilterSet(String root) {
        super(root);
    }

    public boolean contains(Item item, int depth) throws RepositoryException {
        return this.contains(item, null, depth);
    }

    public boolean contains(Item item, String path, int depth) throws RepositoryException {
        if (path == null) {
            path = item.getPath();
        }
        if (!this.covers(path)) {
            return false;
        }
        List entries = this.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        boolean result = !entries.get((int)0).include;
        for (FilterSet.Entry entry : entries) {
            if (!((ItemFilter)entry.filter).matches(item, depth)) continue;
            result = entry.include;
        }
        return result;
    }
}

