/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sling.provisioning.model.Commentable;
import org.apache.sling.provisioning.model.KeyValueMap;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Section;

public class Feature
extends Commentable
implements Comparable<Feature> {
    private final List<RunMode> runModes = new ArrayList<RunMode>();
    private volatile String type = "plain";
    private volatile String version;
    private final KeyValueMap<String> variables = new KeyValueMap();
    private final String name;
    private final List<Section> additionalSections = new ArrayList<Section>();

    public Feature(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSpecial() {
        return this.name.startsWith(":");
    }

    public KeyValueMap<String> getVariables() {
        return this.variables;
    }

    public List<RunMode> getRunModes() {
        return this.runModes;
    }

    public RunMode getRunMode(String ... runModes) {
        Object[] sortedRunModes = RunMode.getSortedRunModesArray(runModes);
        RunMode result = null;
        for (RunMode current : this.runModes) {
            if (!Arrays.equals(sortedRunModes, current.getNames())) continue;
            result = current;
            break;
        }
        return result;
    }

    public RunMode getOrCreateRunMode(String[] names) {
        RunMode result = this.getRunMode(names);
        if (result == null) {
            result = new RunMode(names);
            this.runModes.add(result);
            Collections.sort(this.runModes);
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public void setType(String t) {
        this.type = t == null ? "plain" : t;
    }

    public List<Section> getAdditionalSections() {
        return this.additionalSections;
    }

    public List<Section> getAdditionalSections(String name) {
        ArrayList<Section> result = new ArrayList<Section>();
        for (Section s : this.additionalSections) {
            if (!name.equals(s.getName())) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    public int compareTo(Feature o) {
        if (this.name == null) {
            if (o.name == null) {
                return 0;
            }
            return -1;
        }
        if (o.name == null) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    @Override
    public String toString() {
        return "Feature [runModes=" + this.runModes + ", variables=" + this.variables + ", name=" + this.name + ("plain".equals(this.type) ? "" : ", type=" + this.type) + (this.additionalSections.isEmpty() ? "" : ", additionalSections=" + this.additionalSections) + (this.getLocation() != null ? ", location=" + this.getLocation() : "") + "]";
    }
}

