/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public abstract class JcrUtil {
    private static final String FOLDER_NODE_TYPE = "sling:Folder";

    public static Node createPath(Session session, String absolutePath, String nodeType) throws RepositoryException {
        String relativePath;
        Node parentNode = session.getRootNode();
        if (!parentNode.hasNode(relativePath = absolutePath.substring(1))) {
            Node node = parentNode;
            int pos = relativePath.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(relativePath.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        try {
                            node.addNode(token, FOLDER_NODE_TYPE);
                        }
                        catch (RepositoryException re) {
                            session.refresh(false);
                        }
                    }
                    node = node.getNode(token);
                }
                relativePath = relativePath.substring(pos + 1);
            }
            if (!node.hasNode(relativePath)) {
                node.addNode(relativePath, nodeType);
            }
            return node.getNode(relativePath);
        }
        return parentNode.getNode(relativePath);
    }
}

