/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.resource.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.nosql.generic.resource.impl.NoSqlResource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractNoSqlResourceProviderTransactionalTest {
    @Rule
    public SlingContext context = new SlingContext(ResourceResolverType.JCR_MOCK);

    protected abstract void registerResourceProviderFactory();

    protected abstract Resource testRoot();

    @Before
    public void setUp() throws Exception {
        this.registerResourceProviderFactory();
    }

    @After
    public void tearDown() {
        this.context.resourceResolver().revert();
        try {
            this.context.resourceResolver().delete(this.testRoot());
            this.context.resourceResolver().commit();
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    @Test
    public void testRootNode() {
        Assert.assertTrue((boolean)(this.testRoot() instanceof NoSqlResource));
    }

    @Test
    public void testAddDeleteNodesPartialCommit() throws PersistenceException {
        this.context.resourceResolver().create(this.testRoot(), "node0", (Map)ImmutableMap.of());
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
        this.context.resourceResolver().commit();
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
        this.context.resourceResolver().create(this.testRoot(), "node2", (Map)ImmutableMap.of());
        this.context.resourceResolver().create(this.testRoot(), "node3", (Map)ImmutableMap.of());
        Assert.assertTrue((boolean)this.context.resourceResolver().hasChanges());
        Assert.assertNotNull((Object)this.testRoot().getChild("node0"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node1"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node2"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node3"));
        this.context.resourceResolver().delete(this.testRoot().getChild("node0"));
        this.context.resourceResolver().delete(this.testRoot().getChild("node2"));
        Assert.assertNull((Object)this.testRoot().getChild("node0"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node1"));
        Assert.assertNull((Object)this.testRoot().getChild("node2"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node3"));
        Iterator children = this.testRoot().listChildren();
        Assert.assertEquals((Object)"node1", (Object)((Resource)children.next()).getName());
        Assert.assertEquals((Object)"node3", (Object)((Resource)children.next()).getName());
        Assert.assertFalse((boolean)children.hasNext());
        Assert.assertTrue((boolean)this.context.resourceResolver().hasChanges());
        this.context.resourceResolver().revert();
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
        Assert.assertNotNull((Object)this.testRoot().getChild("node1"));
        Assert.assertNull((Object)this.testRoot().getChild("node2"));
        Assert.assertNull((Object)this.testRoot().getChild("node3"));
        children = this.testRoot().listChildren();
        Assert.assertEquals((Object)"node0", (Object)((Resource)children.next()).getName());
        Assert.assertEquals((Object)"node1", (Object)((Resource)children.next()).getName());
        Assert.assertFalse((boolean)children.hasNext());
    }

    @Test
    public void testRecursiveDeleteWithoutCommit() throws PersistenceException {
        Resource node1 = this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
        Resource node11 = this.context.resourceResolver().create(node1, "node11", (Map)ImmutableMap.of());
        this.context.resourceResolver().create(node11, "node111", (Map)ImmutableMap.of());
        Assert.assertNotNull((Object)this.testRoot().getChild("node1"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node1/node11"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node1/node11/node111"));
        this.context.resourceResolver().delete(node1);
        Assert.assertNull((Object)this.testRoot().getChild("node1"));
        Assert.assertNull((Object)this.testRoot().getChild("node1/node11"));
        Assert.assertNull((Object)this.testRoot().getChild("node1/node11/node111"));
    }

    @Test
    public void testRecursiveDeleteWithCommit() throws PersistenceException {
        Resource node1 = this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
        Resource node11 = this.context.resourceResolver().create(node1, "node11", (Map)ImmutableMap.of());
        this.context.resourceResolver().create(node11, "node111", (Map)ImmutableMap.of());
        Assert.assertTrue((boolean)this.context.resourceResolver().hasChanges());
        this.context.resourceResolver().commit();
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
        Assert.assertNotNull((Object)this.testRoot().getChild("node1"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node1/node11"));
        Assert.assertNotNull((Object)this.testRoot().getChild("node1/node11/node111"));
        this.context.resourceResolver().delete(node1);
        Assert.assertNull((Object)this.testRoot().getChild("node1"));
        Assert.assertNull((Object)this.testRoot().getChild("node1/node11"));
        Assert.assertNull((Object)this.testRoot().getChild("node1/node11/node111"));
        Assert.assertTrue((boolean)this.context.resourceResolver().hasChanges());
        this.context.resourceResolver().commit();
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
        Assert.assertNull((Object)this.testRoot().getChild("node1"));
        Assert.assertNull((Object)this.testRoot().getChild("node1/node11"));
        Assert.assertNull((Object)this.testRoot().getChild("node1/node11/node111"));
    }

    @Test(expected=PersistenceException.class)
    public void testCreateAlreadyExistWithoutCommit() throws PersistenceException {
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
    }

    @Test(expected=PersistenceException.class)
    public void testCreateAlreadyExistWithCommit() throws PersistenceException {
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
        this.context.resourceResolver().commit();
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
    }

    @Test
    public void testCreateAlreadyExistDeletedWithoutCommit() throws PersistenceException {
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
        this.context.resourceResolver().delete(this.testRoot().getChild("node1"));
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
    }

    @Test
    public void testCreateAlreadyExistDeletedWithCommit() throws PersistenceException {
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
        this.context.resourceResolver().commit();
        this.context.resourceResolver().delete(this.testRoot().getChild("node1"));
        this.context.resourceResolver().commit();
        this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of());
    }

    @Test
    public void testUpdateWithoutCommit() throws PersistenceException {
        Resource node1 = this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of((Object)"prop1", (Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)node1.getValueMap().get("prop1", String.class));
        ModifiableValueMap props = (ModifiableValueMap)node1.adaptTo(ModifiableValueMap.class);
        props.put((Object)"prop1", (Object)"value2");
        node1 = this.testRoot().getChild("node1");
        Assert.assertEquals((Object)"value2", (Object)node1.getValueMap().get("prop1", String.class));
    }

    @Test
    public void testUpdateWithCommit() throws PersistenceException {
        Resource node1 = this.context.resourceResolver().create(this.testRoot(), "node1", (Map)ImmutableMap.of((Object)"prop1", (Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)node1.getValueMap().get("prop1", String.class));
        this.context.resourceResolver().commit();
        ModifiableValueMap props = (ModifiableValueMap)node1.adaptTo(ModifiableValueMap.class);
        props.put((Object)"prop1", (Object)"value2");
        this.context.resourceResolver().commit();
        node1 = this.testRoot().getChild("node1");
        Assert.assertEquals((Object)"value2", (Object)node1.getValueMap().get("prop1", String.class));
    }
}

