/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RegisterPrivilege
extends Operation {
    private final String privilegeName;
    private final boolean isAbstract;
    private final List<String> declaredAggregateNames;

    public String getPrivilegeName() {
        return this.privilegeName;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<String> getDeclaredAggregateNames() {
        return this.declaredAggregateNames;
    }

    public RegisterPrivilege(String privilegeName, boolean isAbstract, List<String> declaredAggregateNames) {
        this.privilegeName = privilegeName;
        this.isAbstract = isAbstract;
        this.declaredAggregateNames = Collections.unmodifiableList(new ArrayList<String>(declaredAggregateNames));
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitRegisterPrivilege(this);
    }

    @Override
    protected String getParametersDescription() {
        return this.privilegeName + "," + this.isAbstract + "," + this.declaredAggregateNames;
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        return String.format("%s%n", this.toString());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("register ");
        if (this.isAbstract) {
            builder.append("abstract ");
        }
        builder.append("privilege ");
        builder.append(this.privilegeName);
        if (!this.declaredAggregateNames.isEmpty()) {
            builder.append(" with ");
            Iterator<String> iter = this.declaredAggregateNames.iterator();
            builder.append(iter.next());
            while (iter.hasNext()) {
                builder.append(',').append(iter.next());
            }
        }
        return builder.toString();
    }
}

