/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import org.apache.sling.rewriter.Generator;
import org.apache.sling.rewriter.GeneratorFactory;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Processor;
import org.apache.sling.rewriter.ProcessorConfiguration;
import org.apache.sling.rewriter.ProcessorFactory;
import org.apache.sling.rewriter.Serializer;
import org.apache.sling.rewriter.SerializerFactory;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.apache.sling.rewriter.impl.HashingServiceTrackerCustomizer;
import org.apache.sling.rewriter.impl.ProcessorConfigurationImpl;
import org.apache.sling.rewriter.impl.TransformerFactoryServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryCache {
    static final String PROPERTY_TYPE = "pipeline.type";
    static final String PROPERTY_MODE = "pipeline.mode";
    static final String MODE_GLOBAL = "global";
    private static final String PROPERTY_PATHS = "pipeline.paths";
    private static final String PROPERTY_EXTENSIONS = "pipeline.extensions";
    private static final String PROPERTY_CONTENT_TYPES = "pipeline.contentTypes";
    private static final String PROPERTY_SELECTORS = "pipeline.selectors";
    private static final String PROPERTY_RESOURCE_TYPES = "pipeline.resourceTypes";
    private static final String PROPERTY_PROCESS_ERROR = "pipeline.processError";
    static final Logger LOGGER = LoggerFactory.getLogger(FactoryCache.class);
    private final HashingServiceTrackerCustomizer<GeneratorFactory> generatorTracker;
    private final HashingServiceTrackerCustomizer<SerializerFactory> serializerTracker;
    private final TransformerFactoryServiceTracker transformerTracker;
    private final HashingServiceTrackerCustomizer<ProcessorFactory> processorTracker;
    private static final Transformer[] EMPTY_ARRAY = new Transformer[0];
    private static final Transformer[][] EMPTY_DOUBLE_ARRAY = new Transformer[][]{EMPTY_ARRAY, EMPTY_ARRAY};

    public FactoryCache(BundleContext context) throws InvalidSyntaxException {
        this.generatorTracker = new HashingServiceTrackerCustomizer(context, GeneratorFactory.class.getName());
        this.serializerTracker = new HashingServiceTrackerCustomizer(context, SerializerFactory.class.getName());
        this.transformerTracker = new TransformerFactoryServiceTracker(context, TransformerFactory.class.getName());
        this.processorTracker = new HashingServiceTrackerCustomizer(context, ProcessorFactory.class.getName());
    }

    public void start() {
        this.generatorTracker.open();
        this.serializerTracker.open();
        this.transformerTracker.open();
        this.processorTracker.open();
    }

    public void stop() {
        this.generatorTracker.close();
        this.serializerTracker.close();
        this.transformerTracker.close();
        this.processorTracker.close();
    }

    public Generator getGenerator(String type) {
        GeneratorFactory factory = this.generatorTracker.getFactory(type);
        if (factory == null) {
            LOGGER.debug("Requested generator factory for type '{}' not found.", (Object)type);
            return null;
        }
        return factory.createGenerator();
    }

    public Serializer getSerializer(String type) {
        SerializerFactory factory = this.serializerTracker.getFactory(type);
        if (factory == null) {
            LOGGER.debug("Requested serializer factory for type '{}' not found.", (Object)type);
            return null;
        }
        return factory.createSerializer();
    }

    public Transformer getTransformer(String type) {
        TransformerFactory factory = (TransformerFactory)this.transformerTracker.getFactory(type);
        if (factory == null) {
            LOGGER.debug("Requested transformer factory for type '{}' not found.", (Object)type);
            return null;
        }
        return factory.createTransformer();
    }

    public Processor getProcessor(String type) {
        ProcessorFactory factory = this.processorTracker.getFactory(type);
        if (factory == null) {
            LOGGER.debug("Requested processor factory for type '{}' not found.", (Object)type);
            return null;
        }
        return factory.createProcessor();
    }

    public TransformerFactoryEntry[][] getGlobalTransformerFactoryEntries() {
        return this.transformerTracker.getGlobalTransformerFactoryEntries();
    }

    public Transformer[][] getGlobalTransformers(ProcessingContext context) {
        TransformerFactory[][] factories = this.transformerTracker.getGlobalTransformerFactories(context);
        return this.createTransformers(factories);
    }

    Transformer[][] createTransformers(TransformerFactory[][] factories) {
        if (factories == TransformerFactoryServiceTracker.EMPTY_DOUBLE_FACTORY_ARRAY) {
            return EMPTY_DOUBLE_ARRAY;
        }
        Transformer[][] transformers = new Transformer[2][];
        for (int arrayIndex = 0; arrayIndex < 2; ++arrayIndex) {
            int count = factories[arrayIndex].length;
            for (TransformerFactory factory : factories[arrayIndex]) {
                if (factory != null) continue;
                --count;
            }
            if (count == 0) {
                transformers[arrayIndex] = EMPTY_ARRAY;
                continue;
            }
            transformers[arrayIndex] = new Transformer[count];
            int tIndex = 0;
            for (int i = 0; i < factories[arrayIndex].length; ++i) {
                TransformerFactory factory = factories[arrayIndex][i];
                if (factory == null) continue;
                transformers[arrayIndex][tIndex] = factory.createTransformer();
                ++tIndex;
            }
        }
        return transformers;
    }

    static final class TransformerFactoryEntry
    implements Comparable<TransformerFactoryEntry> {
        public final TransformerFactory factory;
        public final ProcessorConfiguration configuration;
        public final int order;

        public TransformerFactoryEntry(TransformerFactory factory, ServiceReference<TransformerFactory> ref) {
            this.factory = factory;
            Converter c = Converters.standardConverter();
            String[] paths = (String[])c.convert(ref.getProperty(FactoryCache.PROPERTY_PATHS)).to(String[].class);
            String[] extensions = (String[])c.convert(ref.getProperty(FactoryCache.PROPERTY_EXTENSIONS)).to(String[].class);
            String[] contentTypes = (String[])c.convert(ref.getProperty(FactoryCache.PROPERTY_CONTENT_TYPES)).to(String[].class);
            String[] resourceTypes = (String[])c.convert(ref.getProperty(FactoryCache.PROPERTY_RESOURCE_TYPES)).to(String[].class);
            String[] selectors = (String[])c.convert(ref.getProperty(FactoryCache.PROPERTY_SELECTORS)).to(String[].class);
            boolean processError = (Boolean)((Converting)c.convert(ref.getProperty(FactoryCache.PROPERTY_PROCESS_ERROR)).defaultValue((Object)false)).to(Boolean.class);
            boolean noCheckRequired = !(paths != null && paths.length != 0 || extensions != null && extensions.length != 0 || contentTypes != null && contentTypes.length != 0 || resourceTypes != null && resourceTypes.length != 0 || selectors != null && selectors.length != 0 || processError);
            int order = 0;
            Object obj = ref.getProperty("service.ranking");
            if (obj instanceof Integer) {
                order = (Integer)obj;
            }
            this.order = order;
            this.configuration = !noCheckRequired ? new ProcessorConfigurationImpl(contentTypes, paths, extensions, resourceTypes, selectors, order, processError) : null;
        }

        public boolean match(ProcessingContext context) {
            if (this.configuration == null) {
                return true;
            }
            return this.configuration.match(context);
        }

        @Override
        public int compareTo(TransformerFactoryEntry o) {
            return this.order - o.order;
        }
    }
}

