/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.ImportVisitor;
import com.google.gxp.compiler.base.Node;

public class PackageImport
extends Import {
    private final String packageName;

    public PackageImport(SourcePosition sourcePosition, String displayName, String packageName) {
        super(sourcePosition, displayName);
        this.packageName = Preconditions.checkNotNull(packageName);
    }

    public PackageImport(Node fromNode, String packageName) {
        super(fromNode);
        this.packageName = Preconditions.checkNotNull(packageName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public <T> T acceptVisitor(ImportVisitor<T> visitor) {
        return visitor.visitPackageImport(this);
    }

    @Override
    public String getTarget() {
        return this.getPackageName();
    }

    public boolean equals(Object that) {
        return that instanceof PackageImport && this.equals((PackageImport)that);
    }

    public boolean equals(PackageImport that) {
        return this.getPackageName().equals(that.getPackageName());
    }
}

