/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.bsf.ScriptMediator;

public class ScriptMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof ScriptMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        ScriptMediator scriptMediator = (ScriptMediator)m;
        OMElement script = fac.createOMElement("script", synNS);
        String language = scriptMediator.getLanguage();
        Value key = scriptMediator.getKey();
        String function = scriptMediator.getFunction();
        ValueSerializer keySerializer = new ValueSerializer();
        if (key != null) {
            script.addAttribute(fac.createOMAttribute("language", nullNS, language));
            keySerializer.serializeValue(key, "key", script);
            if (!function.equals("mediate")) {
                script.addAttribute(fac.createOMAttribute("function", nullNS, function));
            }
        } else {
            script.addAttribute(fac.createOMAttribute("language", nullNS, language));
            OMText textData = fac.createOMText(scriptMediator.getScriptSrc().trim(), 12);
            script.addChild((OMNode)textData);
        }
        Map<Value, Object> includeMap = scriptMediator.getIncludeMap();
        for (Value includeKey : includeMap.keySet()) {
            if (includeKey == null) continue;
            OMElement includeKeyElement = fac.createOMElement("include", synNS);
            keySerializer.serializeValue(includeKey, "key", includeKeyElement);
            script.addChild((OMNode)includeKeyElement);
        }
        ScriptMediatorSerializer.saveTracingState((OMElement)script, (Mediator)scriptMediator);
        return script;
    }

    public String getMediatorClassName() {
        return ScriptMediator.class.getName();
    }
}

