/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.utils.http;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.script.SimpleScriptContext;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.bsf.utils.http.HttpScriptContext;
import org.apache.bsf.utils.http.HttpScriptRequest;
import org.apache.bsf.utils.http.HttpScriptResponse;

public class GenericHttpScriptContext
extends SimpleScriptContext
implements HttpScriptContext {
    public static final String[] defaultMethods = new String[]{"GET", "POST"};
    protected boolean disableScript = false;
    protected boolean displayResults = false;
    protected String scriptDir;
    protected String[] languages;
    protected String[] methods;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Servlet servlet;
    protected boolean useSession = true;

    public boolean disableScript() {
        return this.disableScript;
    }

    public boolean displayResults() {
        return this.displayResults;
    }

    public String[] getAllowedLanguages() {
        return this.languages;
    }

    public Object getAttribute(String key, Object value, int scope) {
        switch (scope) {
            case 100: {
                return this.request.getAttribute(key);
            }
            case 300: {
                if (this.useSession()) {
                    return this.request.getSession().getAttribute(key);
                }
                return null;
            }
            case 400: {
                return this.servlet.getServletConfig().getServletContext().getAttribute(key);
            }
        }
        return null;
    }

    public void setAttribute(String key, Object value, int scope) throws IllegalArgumentException {
        switch (scope) {
            case 0: {
                this.request.setAttribute(key, value);
                break;
            }
            case 300: {
                if (this.useSession()) {
                    this.request.getSession().setAttribute(key, value);
                    break;
                }
                throw new IllegalArgumentException("Session is disabled");
            }
            case 400: {
                this.servlet.getServletConfig().getServletContext().setAttribute(key, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
    }

    public void forward(String relativePath) throws ServletException, IOException {
        ServletContext context = this.servlet.getServletConfig().getServletContext();
        String requestURI = this.request.getRequestURI();
        String baseURI = relativePath.startsWith("/") ? requestURI.substring(0, this.request.getContextPath().length()) : requestURI.substring(0, requestURI.lastIndexOf("/"));
        context.getRequestDispatcher(baseURI + relativePath).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public String[] getMethods() {
        return this.methods;
    }

    public HttpServletRequest getRequest() {
        return new HttpScriptRequest(this, this.request);
    }

    public HttpServletResponse getResponse() {
        return new HttpScriptResponse(this, this.response);
    }

    public Reader getScriptSource() {
        String requestURI = this.request.getRequestURI();
        String resourcePath = requestURI.substring(this.request.getContextPath().length());
        if (this.scriptDir != null) {
            String fullPath = this.scriptDir.endsWith("/") || resourcePath.startsWith("/") ? this.scriptDir + resourcePath : this.scriptDir + "/" + resourcePath;
            try {
                return new FileReader(fullPath);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return null;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void include(String relativePath) throws ServletException, IOException {
        ServletContext context = this.servlet.getServletConfig().getServletContext();
        String requestURI = this.request.getRequestURI();
        String baseURI = relativePath.startsWith("/") ? requestURI.substring(0, this.request.getContextPath().length()) : requestURI.substring(0, requestURI.lastIndexOf("/"));
        context.getRequestDispatcher(baseURI + relativePath).include((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void initialize(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String methodNames;
        String display;
        this.request = request;
        this.response = response;
        this.servlet = servlet;
        ServletContext context = servlet.getServletConfig().getServletContext();
        this.scriptDir = context.getInitParameter("script-directory");
        if (this.scriptDir == null || !new File(this.scriptDir).isDirectory()) {
            throw new ServletException("Specifed script directory either does not exist or not a directory");
        }
        String disable = context.getInitParameter("script-disable");
        if (disable != null && disable.equals("true")) {
            this.disableScript = true;
            return;
        }
        String session = context.getInitParameter("script-use-session");
        if (session != null && session.equals("false")) {
            this.useSession = false;
        }
        if ((display = context.getInitParameter("script-display-results")) != null && display.equals("true")) {
            this.displayResults = true;
        }
        this.methods = (methodNames = context.getInitParameter("script-methods")) != null ? methodNames.split(",") : defaultMethods;
        String languageNames = context.getInitParameter("allowed-languages");
        if (languageNames != null) {
            this.languages = languageNames.split(",");
        }
    }

    public void release() {
        this.disableScript = false;
        this.displayResults = false;
        this.useSession = true;
        this.servlet = null;
        this.request = null;
        this.response = null;
    }

    public boolean useSession() {
        return this.useSession;
    }

    public Writer getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

