/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics;

import java.util.List;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsLog;
import org.apache.synapse.aspects.statistics.StatisticsRecord;
import org.apache.synapse.aspects.statistics.view.InOutStatisticsView;
import org.apache.synapse.aspects.statistics.view.Statistics;

public class StatisticsUpdateStrategy {
    private final StatisticsRecord statisticsRecord;

    public StatisticsUpdateStrategy(StatisticsRecord statisticsRecord) {
        this.statisticsRecord = statisticsRecord;
    }

    public void updateStatistics(String id, ComponentType componentType, InOutStatisticsView statisticsView) {
        StatisticsLog startLog = null;
        StatisticsLog endLog = null;
        List<StatisticsLog> statisticsLogs = this.statisticsRecord.getAllStatisticsLogs();
        block8: for (StatisticsLog log : statisticsLogs) {
            if (log == null) continue;
            switch (componentType) {
                case SEQUENCE: {
                    if (startLog != null && (log.isEndAnyLog() || log.getComponentType() == ComponentType.ANY)) {
                        endLog = log;
                    }
                    if (componentType != log.getComponentType()) break;
                    if (!id.equals(log.getId())) continue block8;
                    if (startLog == null) {
                        startLog = log;
                        break;
                    }
                    endLog = log;
                    break;
                }
                default: {
                    if (componentType == log.getComponentType()) {
                        if (!id.equals(log.getId())) continue block8;
                        startLog = log;
                        break;
                    }
                    if (log.getComponentType() != ComponentType.ANY || startLog == null) break;
                    endLog = log;
                }
            }
            if (endLog == null || startLog == null) continue;
            switch (componentType) {
                case SEQUENCE: {
                    Statistics statistics = startLog.isResponse() ? statisticsView.getOutStatistics() : statisticsView.getInStatistics();
                    statistics.update(endLog.getTime() - startLog.getTime(), endLog.isFault());
                    if (!endLog.isFault()) break;
                    statistics.addErrorLog(endLog.getErrorLog());
                    break;
                }
                case ENDPOINT: {
                    Statistics statistics = statisticsView.getInStatistics();
                    statistics.update(endLog.getTime() - startLog.getTime(), endLog.isFault());
                    if (!endLog.isFault()) break;
                    statistics.addErrorLog(endLog.getErrorLog());
                    break;
                }
                case PROXYSERVICE: {
                    StatisticsLog lastLog;
                    Statistics inStatistics = statisticsView.getInStatistics();
                    Statistics outStatistics = statisticsView.getOutStatistics();
                    inStatistics.update(endLog.getTime() - startLog.getTime(), endLog.isFault());
                    if (endLog.isFault()) {
                        inStatistics.addErrorLog(endLog.getErrorLog());
                    }
                    if (!endLog.isEndAnyLog() && (lastLog = statisticsLogs.get(statisticsLogs.size() - 1)) != endLog) {
                        outStatistics.update(lastLog.getTime() - endLog.getTime(), lastLog.isFault());
                        if (lastLog.isFault()) {
                            outStatistics.addErrorLog(lastLog.getErrorLog());
                        }
                    }
                    return;
                }
            }
            startLog = null;
            endLog = null;
        }
        if (startLog != null && componentType == ComponentType.PROXYSERVICE) {
            Statistics inStatistics = statisticsView.getInStatistics();
            StatisticsLog lastLog = statisticsLogs.get(statisticsLogs.size() - 1);
            if (lastLog != startLog) {
                inStatistics.update(lastLog.getTime() - startLog.getTime(), lastLog.isFault());
            }
        }
    }
}

