/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.clustering.Member;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.RecipientListEndpoint;

public class RecipientListEndpointSerializer
extends EndpointSerializer {
    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof RecipientListEndpoint)) {
            this.handleException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        RecipientListEndpoint recipientListEndpoint = (RecipientListEndpoint)endpoint;
        this.serializeProperties(recipientListEndpoint, endpointElement);
        this.serializeCommonAttributes(endpoint, endpointElement);
        OMElement recipientListElement = this.fac.createOMElement("recipientlist", SynapseConstants.SYNAPSE_OMNAMESPACE);
        endpointElement.addChild((OMNode)recipientListElement);
        if (recipientListEndpoint.getChildren() != null) {
            for (Endpoint childEndpoint : recipientListEndpoint.getChildren()) {
                recipientListElement.addChild((OMNode)EndpointSerializer.getElementFromEndpoint(childEndpoint));
            }
        } else if (recipientListEndpoint.getMembers() != null) {
            for (Member member : recipientListEndpoint.getMembers()) {
                OMElement memberEle = this.fac.createOMElement("member", SynapseConstants.SYNAPSE_OMNAMESPACE, (OMContainer)recipientListElement);
                memberEle.addAttribute(this.fac.createOMAttribute("hostName", null, member.getHostName()));
                memberEle.addAttribute(this.fac.createOMAttribute("httpPort", null, String.valueOf(member.getHttpPort())));
                memberEle.addAttribute(this.fac.createOMAttribute("httpsPort", null, String.valueOf(member.getHttpsPort())));
                recipientListElement.addChild((OMNode)memberEle);
            }
        } else {
            OMElement dynamicEpEle = this.fac.createOMElement("endpoints", SynapseConstants.SYNAPSE_OMNAMESPACE, (OMContainer)recipientListElement);
            new ValueSerializer().serializeValue(recipientListEndpoint.getDynamicEndpointSet(), "value", dynamicEpEle);
            dynamicEpEle.addAttribute(this.fac.createOMAttribute("max-cache", null, String.valueOf(recipientListEndpoint.getCurrentPoolSize())));
            recipientListElement.addChild((OMNode)dynamicEpEle);
        }
        return endpointElement;
    }
}

