/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOffset;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.LinearAlgebraUtils;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.KahanFunction;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.instructions.cp.KahanObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupOLE
extends ColGroupOffset {
    private static final long serialVersionUID = -9157676271360528008L;
    protected int[] _skipList;

    protected ColGroupOLE() {
    }

    protected ColGroupOLE(int[] colIndices, int numRows, ABitmap ubm, CompressionSettings cs) {
        super(colIndices, numRows, ubm, cs);
        int numVals = ubm.getNumValues();
        char[][] lbitmaps = new char[numVals][];
        int totalLen = 0;
        for (int i = 0; i < numVals; ++i) {
            lbitmaps[i] = ColGroupOLE.genOffsetBitmap(ubm.getOffsetsList(i).extractValues(), ubm.getNumOffsets(i));
            totalLen += lbitmaps[i].length;
        }
        this.createCompressedBitmaps(numVals, totalLen, lbitmaps);
        this._skipList = null;
        if (cs.skipList && numRows > 131072) {
            this._skipList = new int[numVals];
            int blksz = 65536;
            int rl = this._numRows / 2 / blksz * blksz;
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int bix = 0;
                for (int i = 0; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += blksz) {
                }
                this._skipList[k] = bix;
            }
        }
    }

    protected ColGroupOLE(int[] colIndices, int numRows, boolean zeros, ADictionary dict, char[] bitmaps, int[] bitmapOffs) {
        super(colIndices, numRows, zeros, dict);
        this._data = bitmaps;
        this._ptr = bitmapOffs;
    }

    @Override
    public ColGroup.CompressionType getCompType() {
        return ColGroup.CompressionType.OLE;
    }

    @Override
    protected ColGroup.ColGroupType getColGroupType() {
        return ColGroup.ColGroupType.OLE;
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        if (this.getNumValues() > 1) {
            int blksz = 65536;
            int numCols = this.getNumCols();
            int numVals = this.getNumValues();
            double[] values = this.getValues();
            int[] apos = this.skipScan(numVals, rl);
            for (int bi = rl; bi < ru; bi += 65536) {
                int k = 0;
                int off = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int bix = apos[k];
                    int blen = this.len(k);
                    if (bix < blen) {
                        int pos;
                        char len = this._data[boff + bix];
                        for (int i = pos = boff + bix + 1; i < pos + len; ++i) {
                            int rix = bi + this._data[i];
                            for (int j = 0; j < numCols; ++j) {
                                if (values[off + j] == 0.0) continue;
                                target.appendValue(rix, this._colIndexes[j], values[off + j]);
                            }
                        }
                        int n = k;
                        apos[n] = apos[n] + (len + '\u0001');
                    }
                    ++k;
                    off += numCols;
                }
            }
        } else {
            super.decompressToBlock(target, rl, ru);
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int[] colixTargets) {
        if (this.getNumValues() > 1) {
            int blksz = 65536;
            int numCols = this.getNumCols();
            int numVals = this.getNumValues();
            double[] values = this.getValues();
            int[] apos = new int[numVals];
            int[] cix = new int[numCols];
            for (int j = 0; j < numCols; ++j) {
                cix[j] = colixTargets[this._colIndexes[j]];
            }
            for (int bi = 0; bi < this._numRows; bi += 65536) {
                int k = 0;
                int off = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int bix = apos[k];
                    int blen = this.len(k);
                    if (bix < blen) {
                        int pos;
                        char len = this._data[boff + bix];
                        for (int i = pos = boff + bix + 1; i < pos + len; ++i) {
                            int rix = bi + this._data[i];
                            for (int j = 0; j < numCols; ++j) {
                                if (values[off + j] == 0.0) continue;
                                target.appendValue(rix, cix[j], values[off + j]);
                            }
                        }
                        int n = k;
                        apos[n] = apos[n] + (len + '\u0001');
                    }
                    ++k;
                    off += numCols;
                }
            }
        } else {
            super.decompressToBlock(target, colixTargets);
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int blksz = 65536;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] c = target.getDenseBlockValues();
        double[] values = this.getValues();
        int[] apos = ColGroupOLE.allocIVector(numVals, true);
        int nnz = 0;
        for (int bi = 0; bi < this._numRows; bi += 65536) {
            Arrays.fill(c, bi, Math.min(bi + 65536, this._numRows), 0.0);
            int k = 0;
            int off = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int bix = apos[k];
                int blen = this.len(k);
                if (bix < blen) {
                    int pos;
                    char len = this._data[boff + bix];
                    for (int i = pos = boff + bix + 1; i < pos + len; ++i) {
                        c[bi + this._data[i]] = values[off + colpos];
                        ++nnz;
                    }
                    int n = k;
                    apos[n] = apos[n] + (len + '\u0001');
                }
                ++k;
                off += numCols;
            }
        }
        target.setNonZeros(nnz);
    }

    @Override
    public int[] getCounts(int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int count = 0;
            for (int bix = 0; bix < blen; bix += this._data[boff + bix] + '\u0001') {
                count += this._data[boff + bix];
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = this._numRows * this._colIndexes.length - sum;
        }
        return counts;
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        int blksz = 65536;
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = this.skipScanVal(k, rl);
            int count = 0;
            for (int off = rl; bix < blen && off < ru; bix += this._data[boff + bix] + '\u0001', off += 65536) {
                count += this._data[boff + bix];
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = (ru - rl) * this._colIndexes.length - sum;
        }
        return counts;
    }

    @Override
    public long estimateInMemorySize() {
        return ColGroupSizes.estimateInMemorySizeOLE(this.getNumCols(), this.getValues().length, this._data.length, 0, this.isLossy());
    }

    @Override
    public ColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return new ColGroupOLE(this._colIndexes, this._numRows, this._zeros, this.applyScalarOp(op), this._data, this._ptr);
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupOLE(this._colIndexes, this._numRows, false, this.applyScalarOp(op), this._data, this._ptr);
        }
        ADictionary rvalues = this.applyScalarOp(op, val0, this.getNumCols());
        char[] lbitmap = ColGroupOLE.genOffsetBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        return new ColGroupOLE(this._colIndexes, this._numRows, false, rvalues, rbitmaps, rbitmapOffs);
    }

    @Override
    public void rightMultByVector(double[] b, double[] c, int rl, int ru, double[] dictVals) {
        int blksz = 65536;
        int numVals = this.getNumValues();
        if (numVals > 1 && this._numRows > 65536) {
            int blksz2 = 131072;
            int[] apos = this.skipScan(numVals, rl);
            double[] aval = this.preaggValues(numVals, b, dictVals);
            for (int bi = rl; bi < ru; bi += 131072) {
                int bimax = Math.min(bi + 131072, ru);
                for (int k = 0; k < numVals; ++k) {
                    char len;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int bix = apos[k];
                    for (int ii = bi; ii < bimax && bix < blen; bix += len + '\u0001', ii += 65536) {
                        len = this._data[boff + bix];
                        int pos = boff + bix + 1;
                        LinearAlgebraUtils.vectAdd(val, c, this._data, pos, ii, Math.min(len, ru));
                    }
                    apos[k] = bix;
                }
            }
        } else {
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this.sumValues(k, b, dictVals);
                if (val == 0.0) continue;
                int bix = 0;
                int off = 0;
                int slen = -1;
                if (rl > 0) {
                    while (bix < blen & off < rl) {
                        slen = this._data[boff + bix];
                        bix += slen + 1;
                        off += 65536;
                    }
                }
                while (bix < blen & off < ru) {
                    slen = this._data[boff + bix];
                    for (int blckIx = 1; blckIx <= slen; ++blckIx) {
                        int n = off + this._data[boff + bix + blckIx];
                        c[n] = c[n] + val;
                    }
                    bix += slen + 1;
                    off += 65536;
                }
            }
        }
    }

    @Override
    public void rightMultByMatrix(double[] matrix, double[] result, int numVals, double[] values, int rl, int ru, int vOff) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public void leftMultByRowVector(double[] a, double[] c, int numVals) {
        numVals = numVals == -1 ? this.getNumValues() : numVals;
        double[] values = this.getValues();
        this.leftMultByRowVector(a, c, numVals, values);
    }

    @Override
    public void leftMultByRowVector(double[] a, double[] c, int numVals, double[] values) {
        int blksz = 65536;
        int numCols = this.getNumCols();
        if (numVals >= 1 && this._numRows > 65536) {
            int blksz2 = 131072;
            int[] apos = ColGroupOLE.allocIVector(numVals, true);
            double[] cvals = ColGroupOLE.allocDVector(numVals, true);
            for (int ai = 0; ai < this._numRows; ai += 131072) {
                int aimax = Math.min(ai + 131072, this._numRows);
                int k = 0;
                while (k < numVals) {
                    char len;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    int bix = apos[k];
                    double vsum = 0.0;
                    for (int ii = ai; ii < aimax && bix < blen; bix += len + '\u0001', ii += 65536) {
                        len = this._data[boff + bix];
                        int pos = boff + bix + 1;
                        vsum += LinearAlgebraUtils.vectSum(a, this._data, ii, pos, len);
                    }
                    apos[k] = bix;
                    int n = k++;
                    cvals[n] = cvals[n] + vsum;
                }
            }
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                for (int j = 0; j < numCols; ++j) {
                    int n = this._colIndexes[j];
                    c[n] = c[n] + cvals[k] * values[valOff + j];
                }
                ++k;
                valOff += numCols;
            }
        } else {
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double vsum = 0.0;
                int bix = 0;
                int off = 0;
                while (bix < blen) {
                    vsum += LinearAlgebraUtils.vectSum(a, this._data, off, boff + bix + 1, this._data[boff + bix]);
                    bix += this._data[boff + bix] + '\u0001';
                    off += 65536;
                }
                for (int j = 0; j < numCols; ++j) {
                    int n = this._colIndexes[j];
                    c[n] = c[n] + vsum * values[valOff + j];
                }
                ++k;
                valOff += numCols;
            }
        }
    }

    @Override
    public void leftMultByMatrix(double[] a, double[] c, int numVals, double[] values, int numRows, int numCols, int rl, int ru, int voff) {
        int blksz = 65536;
        int thisNumCols = this.getNumCols();
        if (numVals >= 1 && this._numRows > 65536) {
            int blksz2 = 131072;
            int[] apos = ColGroupOLE.allocIVector(numVals, true);
            double[] cvals = ColGroupOLE.allocDVector(numVals, true);
            int i = rl;
            int off = voff * this._numRows;
            while (i < ru) {
                for (int ai = 0; ai < this._numRows; ai += 131072) {
                    int aimax = Math.min(ai + 131072, this._numRows);
                    int k = 0;
                    while (k < numVals) {
                        char len;
                        int boff = this._ptr[k];
                        int blen = this.len(k);
                        int bix = apos[k] + off;
                        double vsum = 0.0;
                        for (int ii = ai; ii < aimax && bix < blen; bix += len + '\u0001', ii += 65536) {
                            len = this._data[boff + bix];
                            int pos = boff + bix + 1;
                            vsum += LinearAlgebraUtils.vectSum(a, this._data, ii + off, pos, len);
                        }
                        apos[k] = bix;
                        int n = k++;
                        cvals[n] = cvals[n] + vsum;
                    }
                }
                int k = 0;
                int valOff = 0;
                while (k < numVals) {
                    for (int j = 0; j < thisNumCols; ++j) {
                        int colIx;
                        int n = colIx = this._colIndexes[j] + i * numCols;
                        c[n] = c[n] + cvals[k] * values[valOff + j];
                    }
                    ++k;
                    valOff += thisNumCols;
                }
                ++i;
                off += this._numRows;
            }
        } else {
            int i = rl;
            int offR = voff * this._numRows;
            while (i < ru) {
                int k = 0;
                int valOff = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double vsum = 0.0;
                    int bix = 0;
                    int off = 0;
                    while (bix < blen) {
                        vsum += LinearAlgebraUtils.vectSum(a, this._data, off + offR, boff + bix + 1, this._data[boff + bix]);
                        bix += this._data[boff + bix] + '\u0001';
                        off += 65536;
                    }
                    for (int j = 0; j < thisNumCols; ++j) {
                        int colIx;
                        int n = colIx = this._colIndexes[j] + i * numCols;
                        c[n] = c[n] + vsum * values[valOff + j];
                    }
                    ++k;
                    valOff += thisNumCols;
                }
                ++i;
                offR += this._numRows;
            }
        }
    }

    @Override
    protected final void computeSum(double[] c, KahanFunction kplus) {
        c[0] = c[0] + this._dict.sum(this.getCounts(), this._colIndexes.length, kplus);
    }

    @Override
    protected final void computeRowSums(double[] c, KahanFunction kplus, int rl, int ru, boolean mean) {
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        KahanPlus kplus2 = KahanPlus.getKahanPlusFnObject();
        int blksz = 65536;
        int numVals = this.getNumValues();
        if (numVals > 1 && this._numRows > 65536) {
            int blksz2 = 65536;
            int[] apos = this.skipScan(numVals, rl);
            double[] aval = this._dict.sumAllRowsToDouble(kplus, kbuff, this._colIndexes.length);
            for (int bi = rl; bi < ru; bi += 65536) {
                int bimax = Math.min(bi + 65536, ru);
                for (int k = 0; k < numVals; ++k) {
                    int len;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int bix = apos[k];
                    for (int ii = bi; ii < bimax && bix < blen; bix += len + '\u0001', ii += 65536) {
                        len = this._data[boff + bix];
                        int pos = boff + bix + 1;
                        for (int i = 0; i < len; ++i) {
                            int rix = ii + this._data[pos + i];
                            this.setandExecute(c, kbuff, kplus2, val, rix * (2 + (mean ? 1 : 0)));
                        }
                    }
                    apos[k] = bix;
                }
            }
        } else {
            for (int k = 0; k < numVals; ++k) {
                int slen;
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this._dict.sumRow(k, kplus, kbuff, this._colIndexes.length);
                if (val == 0.0) continue;
                int bix = this.skipScanVal(k, rl);
                for (int off = (rl + 1) / 65536 * 65536; bix < blen && off < ru; bix += slen + '\u0001', off += 65536) {
                    slen = this._data[boff + bix];
                    for (int i = 1; i <= slen; ++i) {
                        int rix = off + this._data[boff + bix + i];
                        this.setandExecute(c, kbuff, kplus2, val, rix * (2 + (mean ? 1 : 0)));
                    }
                }
            }
        }
    }

    @Override
    protected final void computeColSums(double[] c, KahanFunction kplus) {
        this._dict.colSum(c, this.getCounts(), this._colIndexes, kplus);
    }

    @Override
    protected final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int blksz = 65536;
        int numVals = this.getNumValues();
        double[] values = this.getValues();
        for (int k = 0; k < numVals; ++k) {
            int slen;
            int boff = this._ptr[k];
            int blen = this.len(k);
            double val = this.mxxValues(k, builtin, values);
            int bix = this.skipScanVal(k, rl);
            for (int off = bix * 65536; bix < blen && off < ru; bix += slen + '\u0001', off += 65536) {
                slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int rix = off + this._data[boff + bix + i];
                    c[rix] = builtin.execute(c[rix], val);
                }
            }
        }
    }

    @Override
    protected boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int blksz = 65536;
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int off = 0;
            int bix = 0;
            while (bix < blen) {
                int slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int n = off + this._data[boff + bix + i];
                    ret[n] = ret[n] & false;
                }
                bix += slen + '\u0001';
                off += 65536;
            }
        }
        return ret;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int blksz = 65536;
        int blksz2 = 131072;
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int[] apos = this.skipScan(numVals, rl);
        for (int bi = rl; bi < ru; bi += 131072) {
            int bimax = Math.min(bi + 131072, ru);
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int bix = apos[k];
                int slen = 0;
                for (int off = bi; bix < blen && off < bimax; bix += slen + '\u0001', off += 65536) {
                    slen = this._data[boff + bix];
                    for (int blckIx = 1; blckIx <= slen; ++blckIx) {
                        int n = off + this._data[boff + bix + blckIx] - rl;
                        rnnz[n] = rnnz[n] + numCols;
                    }
                }
                apos[k] = bix;
            }
        }
    }

    private int[] skipScan(int numVals, int rl) {
        int[] ret = ColGroupOLE.allocIVector(numVals, rl == 0);
        int blksz = 65536;
        if (rl > 0) {
            int rskip = this._numRows / 2 / 65536 * 65536;
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = rl >= rskip ? rskip : 0;
                int bix = rl >= rskip ? this._skipList[k] : 0;
                for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65536) {
                }
                ret[k] = bix;
            }
        }
        return ret;
    }

    private int skipScanVal(int k, int rl) {
        int blksz = 65536;
        if (rl > 0) {
            int rskip = this._numRows / 2 / 65536 * 65536;
            int boff = this._ptr[k];
            int blen = this.len(k);
            int start = rl >= rskip ? rskip : 0;
            int bix = rl >= rskip ? this._skipList[k] : 0;
            for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65536) {
            }
            return bix;
        }
        return 0;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        boolean skiplistNull = in.readBoolean();
        if (!skiplistNull) {
            this._skipList = new int[in.readInt()];
            for (int i = 0; i < this._skipList.length; ++i) {
                this._skipList[i] = in.readInt();
            }
        } else {
            this._skipList = null;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (this._skipList != null) {
            out.writeBoolean(false);
            out.writeInt(this._skipList.length);
            for (int i = 0; i < this._skipList.length; ++i) {
                out.writeInt(this._skipList[i]);
            }
        } else {
            out.writeBoolean(true);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ++ret;
        if (this._skipList != null) {
            ret += 4L;
            ret += (long)(4 * this._skipList.length);
        }
        return ret;
    }

    @Override
    public Iterator<Integer> getIterator(int k) {
        return new OLEValueIterator(k, 0, this._numRows);
    }

    @Override
    public Iterator<Integer> getIterator(int k, int rl, int ru) {
        return new OLEValueIterator(k, rl, ru);
    }

    @Override
    public ColGroup.ColGroupRowIterator getRowIterator(int rl, int ru) {
        return new OLERowIterator(rl, ru);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this._skipList != null) {
            sb.append(String.format("\n%15s%5d ", "SkipList:", this._skipList.length));
            sb.append(Arrays.toString(this._skipList));
        } else {
            sb.append("skiplist empty");
        }
        return sb.toString();
    }

    public static char[] genOffsetBitmap(int[] offsets, int len) {
        int lastOffset = offsets[len - 1];
        int numBlocks = lastOffset / 65536 + 1;
        int[] blockLengths = new int[numBlocks];
        for (int ix = 0; ix < len; ++ix) {
            int blockForVal;
            int val = offsets[ix];
            int n = blockForVal = val / 65536;
            blockLengths[n] = blockLengths[n] + 1;
        }
        int totalSize = numBlocks;
        for (int block = 0; block < numBlocks; ++block) {
            totalSize += blockLengths[block];
        }
        char[] encodedBlocks = new char[totalSize];
        int inputIx = 0;
        int blockStartIx = 0;
        for (int block = 0; block < numBlocks; ++block) {
            int blockSz = blockLengths[block];
            encodedBlocks[blockStartIx] = (char)blockSz;
            for (int i = 0; i < blockSz; ++i) {
                encodedBlocks[blockStartIx + i + 1] = (char)(offsets[inputIx + i] % 65536);
            }
            inputIx += blockSz;
            blockStartIx += blockSz + 1;
        }
        return encodedBlocks;
    }

    private class OLERowIterator
    extends ColGroup.ColGroupRowIterator {
        private final int[] _apos;
        private final int[] _vcodes;

        public OLERowIterator(int rl, int ru) {
            super(ColGroupOLE.this);
            this._apos = ColGroupOLE.this.skipScan(ColGroupOLE.this.getNumValues(), rl);
            this._vcodes = new int[Math.min(65536, ru - rl)];
            Arrays.fill(this._vcodes, -1);
            this.getNextSegment();
        }

        @Override
        public void next(double[] buff, int rowIx, int segIx, boolean last) {
            int clen = ColGroupOLE.this._colIndexes.length;
            int vcode = this._vcodes[segIx];
            if (vcode >= 0) {
                double[] values = ColGroupOLE.this.getValues();
                int off = vcode * clen;
                for (int j = 0; j < clen; ++j) {
                    buff[ColGroupOLE.this._colIndexes[j]] = values[off + j];
                }
                this._vcodes[segIx] = -1;
            }
            if (segIx + 1 == 65536 && !last) {
                this.getNextSegment();
            }
        }

        private void getNextSegment() {
            int numVals = ColGroupOLE.this.getNumValues();
            for (int k = 0; k < numVals; ++k) {
                int boff = ColGroupOLE.this._ptr[k];
                int bix = this._apos[k];
                int blen = ColGroupOLE.this.len(k);
                if (bix >= blen) continue;
                int slen = ColGroupOLE.this._data[boff + bix];
                int off = boff + bix + 1;
                for (int i = 0; i < slen; ++i) {
                    this._vcodes[ColGroupOLE.this._data[off + i]] = k;
                }
                int n = k;
                this._apos[n] = this._apos[n] + (slen + '\u0001');
            }
        }
    }

    private class OLEValueIterator
    implements Iterator<Integer> {
        private final int _ru;
        private final int _boff;
        private final int _blen;
        private int _bix;
        private int _start;
        private int _slen;
        private int _spos;
        private int _rpos;

        public OLEValueIterator(int k, int rl, int ru) {
            this._ru = ru;
            this._boff = ColGroupOLE.this._ptr[k];
            this._blen = ColGroupOLE.this.len(k);
            int lrl = rl - rl % 65536;
            this._bix = ColGroupOLE.this.skipScanVal(k, lrl);
            this._start = lrl;
            if (this._bix < this._blen) {
                this._slen = ColGroupOLE.this._data[this._boff + this._bix];
                this._spos = 0;
                this._rpos = ColGroupOLE.this._data[this._boff + this._bix + 1];
                while (this._rpos < rl) {
                    this.nextRowOffset();
                }
            } else {
                this._rpos = this._ru;
            }
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new RuntimeException("No more OLE entries.");
            }
            int ret = this._rpos;
            this.nextRowOffset();
            return ret;
        }

        private void nextRowOffset() {
            if (this._spos + 1 < this._slen) {
                ++this._spos;
                this._rpos = this._start + ColGroupOLE.this._data[this._boff + this._bix + this._spos + 1];
            } else {
                this._start += 65536;
                this._bix += this._slen + 1;
                if (this._bix < this._blen) {
                    this._slen = ColGroupOLE.this._data[this._boff + this._bix];
                    this._spos = 0;
                    this._rpos = this._start + ColGroupOLE.this._data[this._boff + this._bix + 1];
                } else {
                    this._rpos = this._ru;
                }
            }
        }
    }
}

