/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.data.WeightedCell;

public class WeightedPair
extends WeightedCell {
    private static final long serialVersionUID = 8772815876289553196L;
    private double other = 0.0;

    @Override
    public String toString() {
        return this.value + ", " + this.other + ": " + this.weight;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readDouble();
        this.other = in.readDouble();
        this.weight = in.readDouble();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
        out.writeDouble(this.other);
        out.writeDouble(this.weight);
    }

    private static WeightedPair checkType(MatrixValue cell) {
        if (cell != null && !(cell instanceof WeightedPair)) {
            throw new DMLRuntimeException("the Matrix Value is not WeightedPair!");
        }
        return (WeightedPair)cell;
    }

    @Override
    public void copy(MatrixValue that) {
        WeightedPair c2;
        try {
            c2 = WeightedPair.checkType(that);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
        this.value = c2.getValue();
        this.other = c2.getOtherValue();
        this.weight = c2.getWeight();
    }

    public double getOtherValue() {
        return this.other;
    }

    public void setOtherValue(double ov) {
        this.other = ov;
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof WeightedPair)) {
            return -1;
        }
        WeightedPair that = (WeightedPair)o;
        if (this.value != that.value) {
            return Double.compare(this.value, that.value);
        }
        if (this.other != that.other) {
            return Double.compare(this.other, that.other);
        }
        if (this.weight != that.weight) {
            return Double.compare(this.weight, that.weight);
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WeightedPair)) {
            return false;
        }
        WeightedPair that = (WeightedPair)o;
        return this.value == that.value && this.other == that.other && this.weight == that.weight;
    }

    @Override
    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }
}

