/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.utils.ABitmap;

public class CompressedSizeInfoColGroup {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeInfoColGroup.class.getName());
    private final EstimationFactors _facts;
    private final double _cardinalityRatio;
    private final long _minSize;
    private final AColGroup.CompressionType _bestCompressionType;
    private final Map<AColGroup.CompressionType, Long> _sizes;
    private final AMapToData _map;

    public CompressedSizeInfoColGroup(int[] columns, int numVals, int numRows) {
        this._facts = new EstimationFactors(columns, numVals, numRows);
        this._cardinalityRatio = (double)numVals / (double)numRows;
        this._sizes = null;
        this._bestCompressionType = null;
        this._minSize = ColGroupSizes.estimateInMemorySizeDDC(columns.length, numVals, numRows, 1.0, false);
        this._map = null;
    }

    public CompressedSizeInfoColGroup(EstimationFactors facts, Set<AColGroup.CompressionType> validCompressionTypes, ABitmap map) {
        this._facts = facts;
        this._cardinalityRatio = (double)facts.numVals / (double)facts.numRows;
        this._sizes = CompressedSizeInfoColGroup.calculateCompressionSizes(facts, validCompressionTypes);
        Map.Entry<AColGroup.CompressionType, Long> bestEntry = null;
        for (Map.Entry<AColGroup.CompressionType, Long> ent : this._sizes.entrySet()) {
            if (bestEntry != null && ent.getValue() >= bestEntry.getValue()) continue;
            bestEntry = ent;
        }
        this._bestCompressionType = (AColGroup.CompressionType)((Object)bestEntry.getKey());
        this._minSize = bestEntry.getValue();
        this._map = MapToFactory.create(map);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)this);
        }
    }

    protected CompressedSizeInfoColGroup(EstimationFactors facts, Set<AColGroup.CompressionType> validCompressionTypes, AMapToData map) {
        this._facts = facts;
        this._cardinalityRatio = (double)facts.numVals / (double)facts.numRows;
        this._sizes = CompressedSizeInfoColGroup.calculateCompressionSizes(facts, validCompressionTypes);
        Map.Entry<AColGroup.CompressionType, Long> bestEntry = null;
        for (Map.Entry<AColGroup.CompressionType, Long> ent : this._sizes.entrySet()) {
            if (bestEntry != null && ent.getValue() >= bestEntry.getValue()) continue;
            bestEntry = ent;
        }
        this._bestCompressionType = (AColGroup.CompressionType)((Object)bestEntry.getKey());
        this._minSize = bestEntry.getValue();
        this._map = map;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)this);
        }
    }

    public static CompressedSizeInfoColGroup addConstGroup(int[] columns, CompressedSizeInfoColGroup oneSide, Set<AColGroup.CompressionType> validCompressionTypes) {
        EstimationFactors fact = new EstimationFactors(columns, oneSide._facts);
        CompressedSizeInfoColGroup ret = new CompressedSizeInfoColGroup(fact, validCompressionTypes, oneSide._map);
        return ret;
    }

    public long getCompressionSize(AColGroup.CompressionType ct) {
        return this._sizes.get((Object)ct);
    }

    public AColGroup.CompressionType getBestCompressionType(CompressionSettings cs) {
        return this._bestCompressionType;
    }

    public AColGroup.CompressionType getBestCompressionType() {
        return this._bestCompressionType;
    }

    public Map<AColGroup.CompressionType, Long> getAllCompressionSizes() {
        return this._sizes;
    }

    public long getMinSize() {
        return this._minSize;
    }

    public int getNumVals() {
        return this._facts.numVals;
    }

    public int getNumOffs() {
        return this._facts.numOffs;
    }

    public int[] getColumns() {
        return this._facts.cols;
    }

    public double getCardinalityRatio() {
        return this._cardinalityRatio;
    }

    public double getMostCommonFraction() {
        return (double)this._facts.largestOff / (double)this._facts.numRows;
    }

    public double getTupleSparsity() {
        return this._facts.tupleSparsity;
    }

    public AMapToData getMap() {
        return this._map;
    }

    public boolean containsZeros() {
        return this._facts.numOffs < this._facts.numRows;
    }

    private static Map<AColGroup.CompressionType, Long> calculateCompressionSizes(EstimationFactors fact, Set<AColGroup.CompressionType> validCompressionTypes) {
        HashMap<AColGroup.CompressionType, Long> res = new HashMap<AColGroup.CompressionType, Long>();
        for (AColGroup.CompressionType ct : validCompressionTypes) {
            long compSize = CompressedSizeInfoColGroup.getCompressionSize(ct, fact);
            if (compSize <= 0L) continue;
            res.put(ct, compSize);
        }
        return res;
    }

    private static long getCompressionSize(AColGroup.CompressionType ct, EstimationFactors fact) {
        int numCols = fact.cols.length;
        switch (ct) {
            case DDC: {
                return ColGroupSizes.estimateInMemorySizeDDC(numCols, fact.numVals + (fact.numOffs < fact.numRows ? 1 : 0), fact.numRows, fact.tupleSparsity, fact.lossy);
            }
            case RLE: {
                return ColGroupSizes.estimateInMemorySizeRLE(numCols, fact.numVals, fact.numRuns, fact.numRows, fact.tupleSparsity, fact.lossy);
            }
            case OLE: {
                return ColGroupSizes.estimateInMemorySizeOLE(numCols, fact.numVals, fact.numOffs + fact.numVals, fact.numRows, fact.tupleSparsity, fact.lossy);
            }
            case UNCOMPRESSED: {
                return ColGroupSizes.estimateInMemorySizeUncompressed(fact.numRows, numCols, fact.overAllSparsity);
            }
            case SDC: {
                if (fact.numOffs <= 1) {
                    return ColGroupSizes.estimateInMemorySizeSDCSingle(numCols, fact.numVals, fact.numRows, fact.largestOff, fact.zeroIsMostFrequent, fact.containNoZeroValues, fact.tupleSparsity, fact.lossy);
                }
                return ColGroupSizes.estimateInMemorySizeSDC(numCols, fact.numVals, fact.numRows, fact.largestOff, fact.zeroIsMostFrequent, fact.containNoZeroValues, fact.tupleSparsity, fact.lossy);
            }
            case CONST: {
                if (fact.numOffs == 0) {
                    return ColGroupSizes.estimateInMemorySizeEMPTY(numCols);
                }
                if (fact.numOffs == fact.numRows && fact.numVals == 1) {
                    return ColGroupSizes.estimateInMemorySizeCONST(numCols, fact.numVals, fact.tupleSparsity, fact.lossy);
                }
                return -1L;
            }
        }
        throw new NotImplementedException("The col compression Type is not yet supported");
    }

    public int hashCode() {
        return Arrays.hashCode(this._facts.cols);
    }

    public boolean equals(Object that) {
        throw new NotImplementedException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Best Type: " + (Object)((Object)this._bestCompressionType));
        sb.append(" Cardinality: ");
        sb.append(this._cardinalityRatio);
        sb.append(" mostCommonFraction: ");
        sb.append(this.getMostCommonFraction());
        sb.append(" Sizes: ");
        sb.append(this._sizes);
        sb.append(" facts: " + this._facts);
        return sb.toString();
    }
}

