/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysds.runtime.controlprogram.caching.UnifiedMemoryManager;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.fed.InitFEDInstruction;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.ReaderWriterFederated;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageRecomputeUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaData;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.utils.Explain;

public class MatrixObject
extends CacheableData<MatrixBlock> {
    private static final long serialVersionUID = 6374712373206495637L;
    private UpdateType _updateType = UpdateType.COPY;
    private boolean _diag = false;
    private boolean _markForLinCache = false;
    private boolean _partitioned = false;
    private ParForProgramBlock.PDataPartitionFormat _partitionFormat = null;
    private int _partitionSize = -1;
    private String _partitionCacheName = null;
    private MatrixBlock _partitionInMemory = null;

    public MatrixObject(Types.ValueType vt, String file) {
        this(vt, file, null);
    }

    public MatrixObject(Types.ValueType vt, String file, MetaData mtd) {
        super(Types.DataType.MATRIX, vt);
        this._metaData = mtd;
        this._hdfsFileName = file;
        this._cache = null;
        this._data = null;
    }

    public MatrixObject(Types.ValueType vt, String file, MetaData mtd, MatrixBlock data) {
        super(Types.DataType.MATRIX, vt);
        this._metaData = mtd;
        this._hdfsFileName = file;
        this._cache = null;
        this._data = data;
    }

    public MatrixObject(MatrixObject mo) {
        super(mo);
        MetaDataFormat metaOld = (MetaDataFormat)mo.getMetaData();
        this._metaData = new MetaDataFormat(new MatrixCharacteristics(metaOld.getDataCharacteristics()), metaOld.getFileFormat());
        this._updateType = mo._updateType;
        this._diag = mo._diag;
        this._partitioned = mo._partitioned;
        this._partitionFormat = mo._partitionFormat;
        this._partitionSize = mo._partitionSize;
        this._partitionCacheName = mo._partitionCacheName;
        this._markForLinCache = mo._markForLinCache;
    }

    public void setUpdateType(UpdateType flag) {
        this._updateType = flag;
    }

    public UpdateType getUpdateType() {
        return this._updateType;
    }

    public boolean isDiag() {
        return this._diag;
    }

    public void setDiag(boolean diag) {
        this._diag = diag;
    }

    public void setMarkForLinCache(boolean mark) {
        this._markForLinCache = mark;
    }

    public boolean isMarked() {
        return this._markForLinCache;
    }

    @Override
    public void updateDataCharacteristics(DataCharacteristics dc) {
        this._metaData.getDataCharacteristics().set(dc);
    }

    @Override
    public void refreshMetaData() {
        if (this._data == null || this._metaData == null) {
            throw new DMLRuntimeException("Cannot refresh meta data because there is no data or meta data. ");
        }
        DataCharacteristics mc = this._metaData.getDataCharacteristics();
        mc.setDimension(((MatrixBlock)this._data).getNumRows(), ((MatrixBlock)this._data).getNumColumns());
        mc.setNonZeros(((MatrixBlock)this._data).getNonZeros());
    }

    @Override
    public long getBlocksize() {
        return this.getDataCharacteristics().getBlocksize();
    }

    public long getNnz() {
        return this.getDataCharacteristics().getNonZeros();
    }

    public double getSparsity() {
        return OptimizerUtils.getSparsity(this.getDataCharacteristics());
    }

    public void setPartitioned(ParForProgramBlock.PDataPartitionFormat format, int n) {
        this._partitioned = true;
        this._partitionFormat = format;
        this._partitionSize = n;
    }

    public void unsetPartitioned() {
        this._partitioned = false;
        this._partitionFormat = null;
        this._partitionSize = -1;
    }

    public boolean isPartitioned() {
        return this._partitioned;
    }

    public ParForProgramBlock.PDataPartitionFormat getPartitionFormat() {
        return this._partitionFormat;
    }

    public int getPartitionSize() {
        return this._partitionSize;
    }

    public synchronized void setInMemoryPartition(MatrixBlock block) {
        this._partitionInMemory = block;
    }

    public synchronized MatrixBlock readMatrixPartition(IndexRange pred) {
        long t0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Acquire partition " + this.hashCode() + " " + pred));
        }
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (!this._partitioned) {
            throw new DMLRuntimeException("MatrixObject not available to indexed read.");
        }
        if (this._partitionInMemory != null) {
            return this._partitionInMemory;
        }
        MatrixBlock mb = null;
        try {
            boolean blockwise = this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE || this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE;
            MetaDataFormat iimd = (MetaDataFormat)this._metaData;
            DataCharacteristics mc = iimd.getDataCharacteristics();
            int blen = mc.getBlocksize();
            String fname = this.getPartitionFileName(pred, blen);
            if (blockwise && this._partitionCacheName != null && this._partitionCacheName.equals(fname)) {
                mb = (MatrixBlock)this._cache.get();
            }
            if (mb == null) {
                long rows = -1L;
                long cols = -1L;
                switch (this._partitionFormat) {
                    case ROW_WISE: {
                        rows = 1L;
                        cols = mc.getCols();
                        break;
                    }
                    case ROW_BLOCK_WISE: {
                        rows = blen;
                        cols = mc.getCols();
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        rows = this._partitionSize;
                        cols = mc.getCols();
                        break;
                    }
                    case COLUMN_WISE: {
                        rows = mc.getRows();
                        cols = 1L;
                        break;
                    }
                    case COLUMN_BLOCK_WISE: {
                        rows = mc.getRows();
                        cols = blen;
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        rows = mc.getRows();
                        cols = this._partitionSize;
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unsupported partition format: " + this._partitionFormat);
                    }
                }
                if (HDFSTool.existsFileOnHDFS(fname)) {
                    mb = this.readBlobFromHDFS(fname, new long[]{rows, cols});
                } else {
                    mb = new MatrixBlock((int)rows, (int)cols, true);
                    LOG.warn((Object)("Reading empty matrix partition " + fname));
                }
            }
            if (blockwise) {
                this._partitionCacheName = fname;
                this._cache = new SoftReference<Object>(mb);
                if (this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) {
                    int rix = (int)((pred.rowStart - 1L) % (long)blen);
                    mb = mb.slice(rix, rix, (int)(pred.colStart - 1L), (int)(pred.colEnd - 1L), new MatrixBlock());
                }
                if (this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE) {
                    int cix = (int)((pred.colStart - 1L) % (long)blen);
                    mb = mb.slice((int)(pred.rowStart - 1L), (int)(pred.rowEnd - 1L), cix, cix, new MatrixBlock());
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireRTime(t1 - t0);
        }
        return mb;
    }

    public String getPartitionFileName(IndexRange pred, int blen) {
        if (!this._partitioned) {
            throw new DMLRuntimeException("MatrixObject not available to indexed read.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._hdfsFileName);
        switch (this._partitionFormat) {
            case ROW_WISE: {
                sb.append("/");
                sb.append(pred.rowStart);
                break;
            }
            case ROW_BLOCK_WISE: {
                sb.append("/");
                sb.append((pred.rowStart - 1L) / (long)blen + 1L);
                break;
            }
            case ROW_BLOCK_WISE_N: {
                sb.append("/");
                sb.append((pred.rowStart - 1L) / (long)this._partitionSize + 1L);
                break;
            }
            case COLUMN_WISE: {
                sb.append("/");
                sb.append(pred.colStart);
                break;
            }
            case COLUMN_BLOCK_WISE: {
                sb.append("/");
                sb.append((pred.colStart - 1L) / (long)blen + 1L);
                break;
            }
            case COLUMN_BLOCK_WISE_N: {
                sb.append("/");
                sb.append((pred.colStart - 1L) / (long)this._partitionSize + 1L);
                break;
            }
            default: {
                throw new DMLRuntimeException("MatrixObject not available to indexed read.");
            }
        }
        return sb.toString();
    }

    @Override
    protected boolean isBelowCachingThreshold() {
        return LazyWriteBuffer.getCacheBlockSize(this._data) <= CACHING_THRESHOLD || this.getUpdateType() == UpdateType.INPLACE_PINNED;
    }

    @Override
    protected MatrixBlock readBlobFromCache(String fname) throws IOException {
        MatrixBlock mb = null;
        mb = OptimizerUtils.isUMMEnabled() ? (MatrixBlock)UnifiedMemoryManager.readBlock(fname, true) : (MatrixBlock)LazyWriteBuffer.readBlock(fname, true);
        return mb;
    }

    @Override
    protected MatrixBlock readBlobFromHDFS(String fname, long[] dims) throws IOException {
        MatrixBlock newData;
        long rlen = dims[0];
        long clen = dims[1];
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics mc = iimd.getDataCharacteristics();
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading matrix from HDFS...  " + this.hashCode() + "  Path: " + fname + ", dimensions: [" + mc.getRows() + ", " + mc.getCols() + ", " + mc.getNonZeros() + "]"));
            begin = System.currentTimeMillis();
        }
        if (iimd.getFileFormat() == Types.FileFormat.FEDERATED) {
            InitFEDInstruction.federateMatrix(this, ReaderWriterFederated.read(fname, mc));
        }
        int blen = mc.getBlocksize() <= 0 ? ConfigurationManager.getBlocksize() : mc.getBlocksize();
        MatrixBlock matrixBlock = newData = this.isFederated() ? (MatrixBlock)this.acquireReadAndRelease() : DataConverter.readMatrixFromHDFS(fname, iimd.getFileFormat(), rlen, clen, blen, mc.getNonZeros(), this.getFileFormatProperties());
        if (iimd.getFileFormat() == Types.FileFormat.CSV) {
            this._metaData = this._metaData instanceof MetaDataFormat ? new MetaDataFormat(newData.getDataCharacteristics(), iimd.getFileFormat()) : new MetaData(newData.getDataCharacteristics());
        }
        this.setHDFSFileExists(true);
        if (newData == null) {
            throw new IOException("Unable to load matrix from file: " + fname);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading Completed: " + (System.currentTimeMillis() - begin) + " msec."));
        }
        return newData;
    }

    @Override
    protected MatrixBlock readBlobFromRDD(RDDObject rdd, MutableBoolean writeStatus) throws IOException {
        RDDObject lrdd = rdd;
        writeStatus.setValue(false);
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics mc = iimd.getDataCharacteristics();
        Types.FileFormat fmt = iimd.getFileFormat();
        MatrixBlock mb = null;
        try {
            if (rdd.allowsShortCircuitCollect()) {
                lrdd = (RDDObject)rdd.getLineageChilds().get(0);
            }
            int rlen = (int)mc.getRows();
            int clen = (int)mc.getCols();
            int blen = mc.getBlocksize() > 0 ? mc.getBlocksize() : ConfigurationManager.getBlocksize();
            long nnz = mc.getNonZerosBound();
            if (fmt == Types.FileFormat.BINARY && !OptimizerUtils.checkSparkCollectMemoryBudget(mc, MatrixObject.getPinnedSize() + MatrixObject.getBroadcastSize(), true)) {
                if (!HDFSTool.existsFileOnHDFS(this._hdfsFileName)) {
                    long newnnz = SparkExecutionContext.writeMatrixRDDtoHDFS(lrdd, this._hdfsFileName, iimd.getFileFormat());
                    this._metaData.getDataCharacteristics().setNonZeros(newnnz);
                    rdd.setPending(false);
                    rdd.setHDFSFile(true);
                    writeStatus.setValue(true);
                }
                mb = (MatrixBlock)this.readBlobFromHDFS(this._hdfsFileName);
            } else {
                mb = SparkExecutionContext.toMatrixBlock(lrdd, rlen, clen, blen, nnz);
            }
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        if (mb == null) {
            throw new IOException("Unable to load matrix from rdd.");
        }
        return mb;
    }

    @Override
    protected MatrixBlock readBlobFromFederated(FederationMap fedMap, long[] dims) throws IOException {
        List<Pair<FederatedRange, Future<FederatedResponse>>> readResponses = fedMap.requestFederatedData();
        try {
            if (fedMap.getType() == FTypes.FType.PART) {
                return FederationUtils.aggregateResponses(readResponses);
            }
            return FederationUtils.bindResponses(readResponses, dims);
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Federated matrix read failed.", e);
        }
    }

    @Override
    protected void writeBlobToHDFS(String fname, String ofmt, int rep, FileFormatProperties fprop) throws IOException, DMLRuntimeException {
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(" Writing matrix to HDFS...  " + this.hashCode() + "  Path: " + fname + ", Format: " + (ofmt != null ? ofmt : "inferred from metadata")));
            begin = System.currentTimeMillis();
        }
        if (this.isFederated() && Types.FileFormat.safeValueOf(ofmt) == Types.FileFormat.FEDERATED) {
            ReaderWriterFederated.write(fname, this._fedMapping);
        } else if (this._data != null) {
            Types.FileFormat fmt;
            MetaDataFormat iimd = (MetaDataFormat)this._metaData;
            DataCharacteristics mc = iimd.getDataCharacteristics();
            Types.FileFormat fileFormat = fmt = ofmt != null ? Types.FileFormat.safeValueOf(ofmt) : iimd.getFileFormat();
            if (fmt == Types.FileFormat.BINARY && fprop != null) {
                mc = new MatrixCharacteristics(mc).setBlocksize(fprop.getBlocksize());
            }
            DataConverter.writeMatrixToHDFS((MatrixBlock)this._data, fname, fmt, mc, rep, fprop, this._diag);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Writing matrix to HDFS (" + fname + ") - COMPLETED... " + (System.currentTimeMillis() - begin) + " msec."));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Writing matrix to HDFS (" + fname + ") - NOTHING TO WRITE (_data == null)."));
        }
        if (DMLScript.STATISTICS) {
            CacheStatistics.incrementHDFSWrites();
        }
    }

    @Override
    protected void writeBlobFromRDDtoHDFS(RDDObject rdd, String fname, String outputFormat) throws IOException, DMLRuntimeException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        Types.FileFormat fmt = outputFormat != null ? Types.FileFormat.safeValueOf(outputFormat) : iimd.getFileFormat();
        long newnnz = SparkExecutionContext.writeMatrixRDDtoHDFS(rdd, fname, fmt);
        this._metaData.getDataCharacteristics().setNonZeros(newnnz);
    }

    @Override
    protected MatrixBlock reconstructByLineage(LineageItem li) throws IOException {
        return (MatrixBlock)((MatrixObject)LineageRecomputeUtils.parseNComputeLineageTrace(Explain.explain(li), null)).acquireReadAndRelease();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this._partitioned) {
            sb.append("\n");
            sb.append("partitioned:" + this._partitionFormat);
            sb.append(", partitionSize: " + this._partitionSize);
            sb.append(", partitionCacheName:" + this._partitionCacheName);
            sb.append(this._partitionInMemory);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static enum UpdateType {
        COPY,
        INPLACE,
        INPLACE_PINNED;


        public boolean isInPlace() {
            return this != COPY;
        }
    }
}

