/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LibMatrixEquals {
    private static final Log LOG = LogFactory.getLog((String)LibMatrixEquals.class.getName());
    private final MatrixBlock a;
    private final MatrixBlock b;
    private final double eps;

    private LibMatrixEquals(MatrixBlock a, MatrixBlock b) {
        this.a = a;
        this.b = b;
        this.eps = 5.06E-321;
    }

    private LibMatrixEquals(MatrixBlock a, MatrixBlock b, double eps) {
        this.a = a;
        this.b = b;
        this.eps = eps;
    }

    public static boolean equals(MatrixBlock a, MatrixBlock b) {
        if (a == b) {
            return true;
        }
        return new LibMatrixEquals(a, b).exec();
    }

    public static boolean equals(MatrixBlock a, MatrixBlock b, double eps) {
        if (a == b) {
            return true;
        }
        return new LibMatrixEquals(a, b, eps).exec();
    }

    private boolean exec() {
        if (this.isMetadataDifferent()) {
            return false;
        }
        if (this.a.isEmpty() && this.b.nonZeros != -1L) {
            return this.b.isEmpty();
        }
        if (this.b.isEmpty() && this.a.nonZeros != -1L) {
            return false;
        }
        if (this.a.denseBlock != null && this.b.denseBlock != null) {
            return this.a.denseBlock.equals(this.b.denseBlock, this.eps);
        }
        if (this.a.sparseBlock != null && this.b.sparseBlock != null) {
            return this.a.sparseBlock.equals(this.b.sparseBlock, this.eps);
        }
        if (this.a.sparseBlock != null && this.b.denseBlock != null && this.b.denseBlock.isContiguous()) {
            return this.a.sparseBlock.equals(this.b.denseBlock.values(0), this.b.getNumColumns(), this.eps);
        }
        if (this.b.sparseBlock != null && this.a.denseBlock != null && this.a.denseBlock.isContiguous()) {
            return this.b.sparseBlock.equals(this.a.denseBlock.values(0), this.a.getNumColumns(), this.eps);
        }
        return this.genericEquals();
    }

    private boolean isMetadataDifferent() {
        boolean diff = false;
        diff |= this.a.getNumRows() != this.b.getNumRows();
        diff |= this.a.getNumColumns() != this.b.getNumColumns();
        long nnzA = this.a.getNonZeros();
        long nnzB = this.b.getNonZeros();
        return diff |= nnzA != -1L && nnzB != -1L && nnzA != nnzB;
    }

    private boolean genericEquals() {
        LOG.warn((Object)"Using generic equals, potential optimizations are possible");
        int rows = this.a.getNumRows();
        int cols = this.a.getNumColumns();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!(Math.abs(this.a.quickGetValue(i, j) - this.b.quickGetValue(i, j)) > this.eps)) continue;
                return false;
            }
        }
        return true;
    }
}

