/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.internal.transform.ReadOnlyComponentFieldConduit;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class InjectContainerWorker
implements ComponentClassTransformWorker2 {
    private final ComponentClassCache cache;

    public InjectContainerWorker(ComponentClassCache cache) {
        this.cache = cache;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(InjectContainer.class)) {
            this.transformField(field);
        }
    }

    private void transformField(PlasticField field) {
        InjectContainer annotation = (InjectContainer)field.getAnnotation(InjectContainer.class);
        field.claim((Object)annotation);
        ComputedValue<FieldConduit<Object>> provider = this.createFieldValueConduitProvider(field);
        field.setComputedConduit(provider);
    }

    private ComputedValue<FieldConduit<Object>> createFieldValueConduitProvider(PlasticField field) {
        final String fieldName = field.getName();
        final String fieldTypeName = field.getTypeName();
        return new ComputedValue<FieldConduit<Object>>(){

            public FieldConduit<Object> get(InstanceContext context) {
                final Class fieldType = InjectContainerWorker.this.cache.forName(fieldTypeName);
                final ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                return new ReadOnlyComponentFieldConduit(resources, fieldName){

                    public Object get(Object instance, InstanceContext context) {
                        Component container = resources.getContainer();
                        if (!fieldType.isInstance(container)) {
                            String message = String.format("Component %s (type %s) is not assignable to field %s.%s (of type %s).", container.getComponentResources().getCompleteId(), container.getClass().getName(), resources.getComponentModel().getComponentClassName(), fieldName, fieldTypeName);
                            throw new RuntimeException(message);
                        }
                        return container;
                    }
                };
            }
        };
    }
}

