/**
 * Represents an error obtained from the server.
 */
export default class ResponseError extends Error {
    statusCode: number;
    statusMessage: string;
    statusAttributes: Map<string, string>;
    constructor(message: string, responseStatus: {
        code: ResponseError['statusCode'];
        message: ResponseError['statusMessage'];
        attributes: ResponseError['statusAttributes'];
    });
}
