import { GraphTraversalSource } from './graph-traversal.cjs';
/**
 * A controller for a remote transaction that is constructed from <code>g.tx()</code>. Calling <code>begin()</code>
 * on this object will produce a new <code>GraphTraversalSource</code> that is bound to a remote transaction over which
 * multiple traversals may be executed in that context. Calling <code>commit()</code> or <code>rollback()</code> will
 * then close the transaction and thus, the session. This feature only works with transaction enabled graphs.
 */
export declare class Transaction {
    private readonly g;
    private _sessionBasedConnection?;
    constructor(g: GraphTraversalSource);
    /**
     * Spawns a <code>GraphTraversalSource</code> that is bound to a remote session which enables a transaction.
     * @returns {GraphTraversalSource}
     */
    begin(): GraphTraversalSource;
    /**
     * @returns {Promise}
     */
    commit(): Promise<void>;
    /**
     * @returns {Promise}
     */
    rollback(): Promise<void>;
    /**
     * Returns true if transaction is open.
     * @returns {Boolean}
     */
    get isOpen(): boolean;
    /**
     * @returns {Promise}
     */
    close(): Promise<void>;
}
