/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONModule;
import org.apache.tinkerpop.gremlin.structure.io.graphson.JavaTimeSerializersV4;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;

public final class GraphSONXModuleV4
extends GraphSONModule {
    private static final Map<Class, String> TYPE_DEFINITIONS = Collections.unmodifiableMap(new LinkedHashMap<Class, String>(){
        {
            this.put(ByteBuffer.class, "Binary");
            this.put(Short.class, "Int16");
            this.put(BigInteger.class, "BigInteger");
            this.put(BigDecimal.class, "BigDecimal");
            this.put(Byte.class, "Byte");
            this.put(Character.class, "Char");
            this.put(Duration.class, "Duration");
            this.put(OffsetDateTime.class, "DateTime");
        }
    });

    protected GraphSONXModuleV4(boolean normalize) {
        super("graphsonx-4.0");
        this.addSerializer(Duration.class, (JsonSerializer)new JavaTimeSerializersV4.DurationJacksonSerializer());
        this.addSerializer(OffsetDateTime.class, (JsonSerializer)new JavaTimeSerializersV4.OffsetDateTimeJacksonSerializer());
        this.addDeserializer(Duration.class, (JsonDeserializer)new JavaTimeSerializersV4.DurationJacksonDeserializer());
        this.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new JavaTimeSerializersV4.OffsetDateTimeJacksonDeserializer());
    }

    public static GraphSONModule.GraphSONModuleBuilder build() {
        return new Builder();
    }

    @Override
    public Map<Class, String> getTypeDefinitions() {
        return TYPE_DEFINITIONS;
    }

    @Override
    public String getTypeNamespace() {
        return "g";
    }

    public static final class Builder
    implements GraphSONModule.GraphSONModuleBuilder {
        private Builder() {
        }

        @Override
        public GraphSONModule create(boolean normalize, TypeInfo typeInfo) {
            return new GraphSONXModuleV4(normalize);
        }
    }
}

