/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.openjpa.lib.util.Closeable;

public class DelegatingDataSource
implements DataSource,
Closeable {
    private final DataSource _ds;
    private final DelegatingDataSource _del;

    public DelegatingDataSource(DataSource ds) {
        this._ds = ds;
        this._del = this._ds instanceof DelegatingDataSource ? (DelegatingDataSource)this._ds : null;
    }

    public DataSource getDelegate() {
        return this._ds;
    }

    public DataSource getInnermostDelegate() {
        return this._del == null ? this._ds : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingDataSource) {
            other = ((DelegatingDataSource)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("datasource ").append(this.hashCode());
        this.appendInfo(buf);
        return buf.toString();
    }

    protected void appendInfo(StringBuffer buf) {
        if (this._del != null) {
            this._del.appendInfo(buf);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._ds.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this._ds.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._ds.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this._ds.setLoginTimeout(timeout);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._ds.getConnection();
    }

    @Override
    public Connection getConnection(String user, String pass) throws SQLException {
        if (user == null && pass == null) {
            return this._ds.getConnection();
        }
        try {
            return this._ds.getConnection(user, pass);
        }
        catch (UnsupportedOperationException ex) {
            if (this.setBeanProperty(this._ds, "setUsername", user) && this.setBeanProperty(this._ds, "setPassword", pass)) {
                return this._ds.getConnection();
            }
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        if (this._ds instanceof Closeable) {
            ((Closeable)((Object)this._ds)).close();
        }
    }

    public boolean isWrapperFor(Class iface) {
        return iface.isAssignableFrom(this.getDelegate().getClass());
    }

    public Object unwrap(Class iface) {
        if (this.isWrapperFor(iface)) {
            return this.getDelegate();
        }
        return null;
    }

    private boolean setBeanProperty(Object target, String method, Object val) {
        try {
            Method setter = target.getClass().getMethod(method, String.class);
            setter.invoke(target, val);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this._ds.getParentLogger();
    }
}

