/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServerServiceFilter;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Managed
public class ServiceLogger
extends ServerServiceFilter {
    private volatile int errors = 0;
    private Logger logger;
    private boolean debug = false;
    private static Method MDBput = null;

    public ServiceLogger(ServerService next) {
        super(next);
    }

    @Override
    public void init(Properties props) throws Exception {
        this.logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("service." + this.getName()), (String)"org.apache.openejb.server.util.resources");
        this.debug = this.logger.isDebugEnabled();
        super.init(props);
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("service(in,out)");
    }

    public static void MDCput(String key, String value) {
        if (MDBput != null) {
            try {
                MDBput.invoke(null, key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void service(Socket socket) throws ServiceException, IOException {
        block4: {
            InetAddress client = socket.getInetAddress();
            String address = client.getHostAddress();
            String name = this.getName();
            ServiceLogger.MDCput("HOST", address);
            ServiceLogger.MDCput("SERVER", name);
            try {
                long start = System.nanoTime();
                super.service(socket);
                if (this.debug) {
                    this.logger.debug("[request] for '" + name + "' by '" + address + "' took " + (System.nanoTime() - start) + "ns");
                }
            }
            catch (Exception e) {
                if (this.debug) {
                    this.logger.debug("[Request failed] for '" + name + "' by '" + address + "' : " + e.getMessage(), (Throwable)e);
                }
                if (!this.logger.isWarningEnabled() || this.errors >= Integer.getInteger("openejb.max.log.socket.errors", 10)) break block4;
                ++this.errors;
                this.logger.warning("[Request failed] for '" + name + "' by '" + address + "' : " + e.getMessage());
            }
        }
    }

    static {
        try {
            Class<?> MDC = ServiceLogger.class.getClassLoader().loadClass("org.apache.log4j.MDC");
            MDBput = MDC.getMethod("put", String.class, String.class);
        }
        catch (Exception e) {
            Logger.getInstance((LogCategory)LogCategory.OPENEJB, (String)ServiceLogger.class.getName()).debug("can't find log4j MDC class");
        }
    }
}

