/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;
import org.apache.openejb.jee.TimerSchedule;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="method-scheduleType", propOrder={"descriptions", "ejbName", "schedule", "method"})
public class MethodSchedule {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="schedule", required=true)
    protected List<TimerSchedule> schedule;
    @XmlElement(required=true)
    protected NamedMethod method;
    @XmlElement(name="ejb-name", required=true)
    protected String ejbName;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public MethodSchedule() {
    }

    public MethodSchedule(String className, String ejbName, String methodName, TimerSchedule ... schedules) {
        this(ejbName, new NamedMethod(className, methodName), schedules);
    }

    public MethodSchedule(String ejbName, Method method, TimerSchedule ... schedules) {
        this(ejbName, new NamedMethod(method), schedules);
    }

    public MethodSchedule(String ejbName, NamedMethod method, TimerSchedule ... schedules) {
        this.method = method;
        this.ejbName = ejbName;
        for (TimerSchedule schedule : schedules) {
            this.getSchedule().add(schedule);
        }
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public List<TimerSchedule> getSchedule() {
        if (this.schedule == null) {
            this.schedule = new ArrayList<TimerSchedule>();
        }
        return this.schedule;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public NamedMethod getMethod() {
        return this.method;
    }

    public void setMethod(NamedMethod method) {
        this.method = method;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public List<TimerSchedule> getAttribute() {
        return this.getSchedule();
    }
}

