/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.singlevm;

import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ojb.broker.Identity;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.VirtualProxy;
import ojb.broker.accesslayer.ConnectionManager;
import ojb.broker.accesslayer.IndirectionHandler;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.accesslayer.PkEnumeration;
import ojb.broker.accesslayer.ProxyRsIterator;
import ojb.broker.accesslayer.RsIterator;
import ojb.broker.accesslayer.SqlGenerator;
import ojb.broker.accesslayer.StatementManager;
import ojb.broker.cache.ObjectCache;
import ojb.broker.cache.ObjectCacheFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.CollectionDescriptor;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import ojb.broker.metadata.PersistentField;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByExample;
import ojb.broker.query.QueryFactory;
import ojb.broker.util.ArrayIterator;
import ojb.broker.util.ObjectModification;
import ojb.broker.util.ObjectModificationDefaultImpl;
import ojb.broker.util.SequenceManager;
import ojb.broker.util.SequenceManagerFactory;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class PersistenceBrokerImpl
implements PersistenceBroker {
    private static boolean _debug = false;
    private JdbcAccess m_DbAccess;
    private SqlGenerator m_SqlGen = SqlGenerator.getInstance();
    private ObjectCache m_ObjectCache = ObjectCacheFactory.getObjectCache();
    private DescriptorRepository m_DescriptorRepository = null;
    private ConnectionManager m_ConnectionManager = null;
    private SequenceManager m_SequenceManager = null;
    private StatementManager statementManager = null;
    private boolean inTransaction = false;

    public PersistenceBrokerImpl(DescriptorRepository repository) {
        this.m_DescriptorRepository = repository;
        this.m_ConnectionManager = new ConnectionManager(this);
        this.m_DbAccess = new JdbcAccess(this);
        this.m_SequenceManager = SequenceManagerFactory.getSequenceManager(this);
        this.statementManager = new StatementManager(this);
    }

    public static void setDebug(boolean b) {
        _debug = b;
    }

    public StatementManager getStatementManager() {
        return this.statementManager;
    }

    public ConnectionManager getConnectionManager() {
        return this.m_ConnectionManager;
    }

    public void delete(Object obj) throws PersistenceBrokerException {
        if (_debug) {
            System.out.println("delete " + obj);
        }
        if (obj instanceof VirtualProxy) {
            VirtualProxy proxy = (VirtualProxy)obj;
            obj = proxy.getRealSubject();
        } else if (Proxy.isProxyClass(obj.getClass())) {
            IndirectionHandler handler = (IndirectionHandler)Proxy.getInvocationHandler(obj);
            obj = handler.getRealSubject();
        }
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(obj.getClass());
        this.deleteReferences(obj, mif.getObjectReferenceDescriptors());
        this.deleteCollections(obj, mif.getCollectionDescriptors());
        Identity oid = new Identity(obj);
        this.m_DbAccess.executeDelete(mif, oid);
        this.m_ObjectCache.remove(oid);
    }

    private void deleteReferences(Object obj, Vector vecRds) {
        Iterator i = ((AbstractList)vecRds).iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            if (!rds.getCascadeDelete()) continue;
            try {
                Object r = rds.getPersistentField().get(obj);
                this.delete(r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteCollections(Object obj, Vector vecCds) {
        Iterator i = ((AbstractList)vecCds).iterator();
        while (i.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            if (!cds.getCascadeDelete()) continue;
            try {
                ArrayIterator colIterator;
                Object col = cds.getPersistentField().get(obj);
                if (col == null) continue;
                if (col instanceof ManageableCollection) {
                    colIterator = ((ManageableCollection)col).ojbIterator();
                } else if (col instanceof Collection) {
                    colIterator = ((Collection)col).iterator();
                } else {
                    if (!col.getClass().isArray()) {
                        throw new RuntimeException(col.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
                    }
                    colIterator = new ArrayIterator(col);
                }
                while (colIterator.hasNext()) {
                    this.delete(colIterator.next());
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store(Object obj) throws PersistenceBrokerException {
        if (_debug) {
            System.out.println("store " + obj);
        }
        if (obj == null) return;
        if (obj instanceof VirtualProxy) {
            VirtualProxy proxy = (VirtualProxy)obj;
            if (!proxy.alreadyMaterialized()) return;
            obj = proxy.getRealSubject();
        } else if (Proxy.isProxyClass(obj.getClass())) {
            IndirectionHandler handler = (IndirectionHandler)Proxy.getInvocationHandler(obj);
            if (!handler.alreadyMaterialized()) return;
            obj = handler.getRealSubject();
        }
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(obj.getClass());
        Identity oid = new Identity(obj);
        ObjectModificationDefaultImpl mod = new ObjectModificationDefaultImpl();
        boolean doInsert = false;
        if (this.m_DbAccess.materializeObject(mif, oid) == null) {
            doInsert = true;
        }
        this.store(obj, doInsert);
    }

    private void storeReferences(Object obj, Vector vecRds) {
        Iterator i = ((AbstractList)vecRds).iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            if (!rds.getCascadeStore()) continue;
            try {
                Object r = rds.getPersistentField().get(obj);
                this.store(r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeCollections(Object obj, Vector vecCds) {
        Iterator i = ((AbstractList)vecCds).iterator();
        while (i.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            if (!cds.getCascadeStore()) continue;
            try {
                ArrayIterator colIterator;
                Object col = cds.getPersistentField().get(obj);
                if (col == null) continue;
                if (col instanceof ManageableCollection) {
                    colIterator = ((ManageableCollection)col).ojbIterator();
                } else if (col instanceof Collection) {
                    colIterator = ((Collection)col).iterator();
                } else {
                    if (!col.getClass().isArray()) {
                        throw new RuntimeException(col.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
                    }
                    colIterator = new ArrayIterator(col);
                }
                while (colIterator.hasNext()) {
                    this.store(colIterator.next());
                }
            }
            catch (Throwable ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public void retrieveReferences(Object newObj, ClassDescriptor mif) {
        PersistentField ReferencedField = null;
        Object refObj = null;
        Vector rdv = mif.getObjectReferenceDescriptors();
        Iterator i = ((AbstractList)rdv).iterator();
        try {
            while (i.hasNext()) {
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                if (!rds.getCascadeRetrieve()) continue;
                refObj = this.getReferencedObject(newObj, rds, mif);
                ReferencedField = rds.getPersistentField();
                ReferencedField.set(newObj, refObj);
            }
        }
        catch (Exception ex) {
            System.out.println("expected type: " + ReferencedField.getType());
            System.out.println("actual type:   " + refObj.getClass());
            ex.printStackTrace();
        }
    }

    public void retrieveCollections(Object newObj, ClassDescriptor mif) {
        Vector cdv = mif.getCollectionDescriptors();
        Iterator i = ((AbstractList)cdv).iterator();
        try {
            while (i.hasNext()) {
                Object result;
                CollectionDescriptor cds = (CollectionDescriptor)i.next();
                if (!cds.getCascadeRetrieve()) continue;
                Class collectionClass = cds.getCollectionClass();
                PersistentField collectionField = cds.getPersistentField();
                Class itemsClass = cds.getItemClass();
                ClassDescriptor itemsMif = this.m_DescriptorRepository.getDescriptorFor(itemsClass);
                FieldDescriptor[] fields = cds.getForeignKeyFieldDescriptors(itemsMif);
                Object[] values = mif.getKeyValues(newObj);
                Query fkQuery = this.getForeignKeyQuery(itemsMif, fields, values);
                if (collectionClass == null) {
                    result = this.getCollectionByQuery(fkQuery);
                    if (collectionField.getType().isArray()) {
                        int length = result.size();
                        Class<?> itemtype = collectionField.getType().getComponentType();
                        Object resultArray = Array.newInstance(itemtype, length);
                        int j = 0;
                        while (j < length) {
                            Array.set(resultArray, j, ((Vector)result).get(j));
                            ++j;
                        }
                        collectionField.set(newObj, resultArray);
                        continue;
                    }
                    collectionField.set(newObj, result);
                    continue;
                }
                result = this.getCollectionByQuery(collectionClass, fkQuery);
                collectionField.set(newObj, result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Object getReferencedObject(Object obj, ObjectReferenceDescriptor rds, ClassDescriptor mif) throws PersistenceBrokerException {
        Class referencedClass = rds.getItemClass();
        Object[] pkVals = rds.getForeignKeyValues(obj, mif);
        Identity id = new Identity(referencedClass, pkVals);
        Class referencedProxy = rds.getItemProxyClass();
        if (referencedProxy != null) {
            try {
                return VirtualProxy.createProxy(referencedProxy, id);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return this.getObjectByIdentity(id);
    }

    public synchronized void abortTransaction() throws TransactionNotInProgressException {
        if (!this.inTransaction) {
            throw new TransactionNotInProgressException();
        }
        this.inTransaction = false;
        Enumeration allConnections = this.m_ConnectionManager.enumeration();
        while (allConnections.hasMoreElements()) {
            try {
                Connection conn = (Connection)allConnections.nextElement();
                conn.rollback();
                conn.setAutoCommit(true);
            }
            catch (Throwable t) {
                System.out.println("Error in Transaction abort: " + t.getMessage());
            }
        }
    }

    public synchronized void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        if (this.inTransaction) {
            throw new TransactionInProgressException();
        }
        this.inTransaction = true;
        Enumeration allConnections = this.m_ConnectionManager.enumeration();
        while (allConnections.hasMoreElements()) {
            try {
                Connection conn = (Connection)allConnections.nextElement();
                conn.setAutoCommit(false);
            }
            catch (Throwable t) {
                this.abortTransaction();
                throw new TransactionAbortedException("Transaction aborted: " + t.getMessage());
            }
        }
    }

    public synchronized void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        if (!this.inTransaction) {
            throw new TransactionNotInProgressException();
        }
        this.inTransaction = false;
        Enumeration allConnections = this.m_ConnectionManager.enumeration();
        while (allConnections.hasMoreElements()) {
            try {
                Connection conn = (Connection)allConnections.nextElement();
                conn.commit();
                conn.setAutoCommit(true);
            }
            catch (Throwable t) {
                this.abortTransaction();
                throw new TransactionAbortedException("Transaction aborted: " + t.getMessage());
            }
        }
    }

    public synchronized void checkPoint() throws TransactionNotInProgressException, TransactionAbortedException {
        Enumeration allConnections = this.m_ConnectionManager.enumeration();
        while (allConnections.hasMoreElements()) {
            try {
                Connection conn = (Connection)allConnections.nextElement();
                conn.commit();
            }
            catch (Throwable t) {
                System.out.println("checkpoint failed!");
            }
        }
    }

    private ManageableCollection getCollectionByQuery(Class collectionClass, Class itemClass, Class itemProxy, Query query) throws ClassNotPersistenceCapableException {
        if (_debug) {
            System.out.println("getCollectionByQuery (" + collectionClass + ", " + itemClass + ", " + query + ")");
        }
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        ManageableCollection result = null;
        try {
            result = (ManageableCollection)collectionClass.newInstance();
            Iterator i = this.getIteratorFromQuery(query, mif, itemProxy);
            while (i.hasNext()) {
                result.ojbAdd(i.next());
            }
        }
        catch (InstantiationException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return result;
    }

    private Collection getCollectionByQuery(Class itemClass, Class itemProxy, Query query) throws ClassNotPersistenceCapableException {
        if (_debug) {
            System.out.println("getCollectionByQuery " + itemClass + ", " + query);
        }
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        Vector res = new Vector(100);
        Iterator i = this.getIteratorFromQuery(query, mif, itemProxy);
        while (i.hasNext()) {
            res.add(i.next());
        }
        return res;
    }

    public ManageableCollection getCollectionByQuery(Class collectionClass, Query query) throws PersistenceBrokerException {
        Class itemClass = query.getSearchClass();
        ClassDescriptor cld = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        ManageableCollection result = null;
        Class proxyClass = cld.getProxyClass();
        if (!cld.isInterface()) {
            result = this.getCollectionByQuery(collectionClass, itemClass, proxyClass, query);
        }
        if (cld.isExtent()) {
            Vector extentClasses = cld.getExtentClasses();
            int i = 0;
            while (i < extentClasses.size()) {
                Class ec = (Class)extentClasses.get(i);
                cld = this.m_DescriptorRepository.getDescriptorFor(ec);
                itemClass = cld.getClassOfObject();
                proxyClass = cld.getProxyClass();
                ManageableCollection tmp = this.getCollectionByQuery(collectionClass, itemClass, proxyClass, query);
                if (result == null) {
                    result = tmp;
                } else {
                    result.ojbAddAll(tmp);
                }
                ++i;
            }
        }
        return result;
    }

    public Collection getCollectionByQuery(Query query) throws PersistenceBrokerException {
        Class itemClass = query.getSearchClass();
        ClassDescriptor cld = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        Collection result = null;
        Class proxyClass = cld.getProxyClass();
        if (!cld.isInterface()) {
            result = this.getCollectionByQuery(itemClass, proxyClass, query);
        }
        if (cld.isExtent()) {
            Vector extentClasses = cld.getExtentClasses();
            int i = 0;
            while (i < extentClasses.size()) {
                Class ec = (Class)extentClasses.get(i);
                cld = this.m_DescriptorRepository.getDescriptorFor(ec);
                itemClass = cld.getClassOfObject();
                proxyClass = cld.getProxyClass();
                Collection tmp = this.getCollectionByQuery(itemClass, proxyClass, query);
                if (result == null) {
                    result = tmp;
                } else {
                    result.addAll(tmp);
                }
                ++i;
            }
        }
        return result;
    }

    private Object getDBObject(Identity oid) throws ClassNotPersistenceCapableException {
        Class c = oid.getObjectsClass();
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(c);
        Object newObj = null;
        if (!mif.isInterface()) {
            newObj = this.m_DbAccess.materializeObject(mif, oid);
        }
        if (newObj == null && mif.isExtent()) {
            Vector extentClasses = mif.getExtentClasses();
            int i = 0;
            while (i < extentClasses.size()) {
                Class ec = (Class)extentClasses.get(i);
                mif = this.m_DescriptorRepository.getDescriptorFor(ec);
                newObj = this.m_DbAccess.materializeObject(mif, oid);
                if (newObj != null) break;
                ++i;
            }
        }
        if (newObj != null) {
            this.m_ObjectCache.cache(oid, newObj);
            this.retrieveReferences(newObj, mif);
            this.retrieveCollections(newObj, mif);
        }
        return newObj;
    }

    public Iterator getIteratorByQuery(Query query) throws PersistenceBrokerException {
        Class itemClass = query.getSearchClass();
        ClassDescriptor cld = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        Class proxyClass = cld.getProxyClass();
        return this.getIteratorFromQuery(query, cld, proxyClass);
    }

    private Iterator getIteratorFromQuery(Query query, ClassDescriptor mif, Class itemProxyClass) {
        try {
            RsIterator iter = null;
            iter = itemProxyClass == null ? new RsIterator(query, mif, this) : new ProxyRsIterator(query, mif, itemProxyClass, this);
            return iter;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    private Object getObjectByExample(Object exampleObj) throws PersistenceBrokerException {
        Identity oid = new Identity(exampleObj);
        return this.getObjectByIdentity(oid);
    }

    public Object getObjectByIdentity(Identity id) throws PersistenceBrokerException {
        Object obj;
        if (_debug) {
            System.out.println("getObjectByIdentity " + id);
        }
        if ((obj = this.m_ObjectCache.lookup(id)) == null) {
            obj = this.getDBObject(id);
        }
        return obj;
    }

    public Object getObjectByQuery(Query query) throws PersistenceBrokerException {
        if (query instanceof QueryByExample) {
            Object obj = query.getExampleObject();
            if (obj instanceof Identity) {
                return this.getObjectByIdentity((Identity)obj);
            }
            return this.getObjectByExample(obj);
        }
        Vector coll = (Vector)this.getCollectionByQuery(query);
        try {
            return coll.get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Enumeration getPKEnumerationByQuery(Class primaryKeyClass, Query query) throws PersistenceBrokerException {
        if (_debug) {
            System.out.println("getPKEnumerationByQuery " + query);
        }
        ClassDescriptor cld = this.m_DescriptorRepository.getDescriptorFor(query.getSearchClass());
        return new PkEnumeration(query, cld, primaryKeyClass, this);
    }

    public void store(Object obj, ObjectModification mod) throws PersistenceBrokerException {
        this.store(obj);
    }

    private void store(Object obj, boolean insert) throws PersistenceBrokerException {
        ClassDescriptor mif;
        if (_debug) {
            System.out.println("store " + obj + ", " + insert);
        }
        if (obj != null) {
            if (obj instanceof VirtualProxy) {
                VirtualProxy proxy = (VirtualProxy)obj;
                if (proxy.alreadyMaterialized()) {
                    obj = proxy.getRealSubject();
                } else {
                    return;
                }
            }
            mif = this.m_DescriptorRepository.getDescriptorFor(obj.getClass());
            if (insert) {
                this.m_DbAccess.executeInsert(mif, obj);
            } else {
                this.m_DbAccess.executeUpdate(mif, obj);
            }
        } else {
            return;
        }
        this.m_ObjectCache.cache(obj);
        this.storeReferences(obj, mif.getObjectReferenceDescriptors());
        this.storeCollections(obj, mif.getCollectionDescriptors());
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    private Query getForeignKeyQuery(ClassDescriptor cld, FieldDescriptor[] fields, Object[] values) {
        Criteria criteria = new Criteria();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fld = fields[i];
            criteria.addEqualTo(fld.getPersistentField().getName(), values[i]);
            ++i;
        }
        criteria.orderBy(cld.getOrderby());
        Query result = QueryFactory.newQuery(cld.getClassOfObject(), criteria);
        return result;
    }

    public int getUniqueId(Class extent, String attribute) {
        return this.m_SequenceManager.getUniqueId(extent, attribute);
    }

    public void removeFromCache(Object obj) throws PersistenceBrokerException {
        this.m_ObjectCache.remove(obj);
    }

    public String getUniqueString(Class extent, String attribute) throws PersistenceBrokerException {
        return this.m_SequenceManager.getUniqueString(extent, attribute);
    }
}

