/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.localization.LocaleTokenizer;
import org.apache.turbine.services.localization.LocalizationService;
import org.apache.turbine.util.RunData;

public class TurbineLocalizationService
extends TurbineBaseService
implements LocalizationService {
    private static Log log = LogFactory.getLog((Class)TurbineLocalizationService.class);
    private static final Object[] NO_ARGS = new Object[0];
    private Map bundles = new HashMap();
    private String[] bundleNames = null;
    private Locale defaultLocale = null;
    private String defaultLanguage = null;
    private String defaultCountry = null;

    public void init() throws InitializationException {
        Configuration conf = Turbine.getConfiguration();
        this.initBundleNames(null);
        Locale jvmDefault = Locale.getDefault();
        this.defaultLanguage = conf.getString("locale.default.language", jvmDefault.getLanguage()).trim();
        this.defaultCountry = conf.getString("locale.default.country", jvmDefault.getCountry()).trim();
        this.defaultLocale = new Locale(this.defaultLanguage, this.defaultCountry);
        this.setInit(true);
    }

    protected void initBundleNames(String[] ignored) {
        Configuration conf = Turbine.getConfiguration();
        this.bundleNames = conf.getStringArray("locale.default.bundles");
        String name = conf.getString("locale.default.bundle");
        if (name != null && name.length() > 0) {
            if (this.bundleNames == null || this.bundleNames.length <= 0) {
                this.bundleNames = new String[]{name};
            } else {
                String[] array = new String[this.bundleNames.length + 1];
                array[0] = name;
                System.arraycopy(this.bundleNames, 0, array, 1, this.bundleNames.length);
                this.bundleNames = array;
            }
        }
        if (this.bundleNames == null) {
            this.bundleNames = new String[0];
        }
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public String getDefaultBundleName() {
        return this.bundleNames.length > 0 ? this.bundleNames[0] : "";
    }

    public String[] getBundleNames() {
        return (String[])this.bundleNames.clone();
    }

    public ResourceBundle getBundle() {
        return this.getBundle(this.getDefaultBundleName(), (Locale)null);
    }

    public ResourceBundle getBundle(String bundleName) {
        return this.getBundle(bundleName, (Locale)null);
    }

    public ResourceBundle getBundle(String bundleName, String languageHeader) {
        return this.getBundle(bundleName, this.getLocale(languageHeader));
    }

    public ResourceBundle getBundle(HttpServletRequest req) {
        return this.getBundle(this.getDefaultBundleName(), this.getLocale(req));
    }

    public ResourceBundle getBundle(String bundleName, HttpServletRequest req) {
        return this.getBundle(bundleName, this.getLocale(req));
    }

    public ResourceBundle getBundle(RunData data) {
        return this.getBundle(this.getDefaultBundleName(), this.getLocale(data.getRequest()));
    }

    public ResourceBundle getBundle(String bundleName, RunData data) {
        return this.getBundle(bundleName, this.getLocale(data.getRequest()));
    }

    public ResourceBundle getBundle(String bundleName, Locale locale) {
        String string = bundleName = StringUtils.isEmpty((String)bundleName) ? this.getDefaultBundleName() : bundleName.trim();
        if (locale == null) {
            locale = this.getLocale((String)null);
        }
        ResourceBundle rb = null;
        Map bundlesByLocale = (Map)this.bundles.get(bundleName);
        if (bundlesByLocale != null) {
            rb = (ResourceBundle)bundlesByLocale.get(locale);
            if (rb == null) {
                rb = this.cacheBundle(bundleName, locale);
            }
        } else {
            rb = this.cacheBundle(bundleName, locale);
        }
        return rb;
    }

    private synchronized ResourceBundle cacheBundle(String bundleName, Locale locale) throws MissingResourceException {
        ResourceBundle rb;
        HashMap<Locale, ResourceBundle> bundlesByLocale = (HashMap<Locale, ResourceBundle>)this.bundles.get(bundleName);
        ResourceBundle resourceBundle = rb = bundlesByLocale == null ? null : (ResourceBundle)bundlesByLocale.get(locale);
        if (rb == null) {
            block4: {
                bundlesByLocale = bundlesByLocale == null ? new HashMap<Locale, ResourceBundle>(3) : new HashMap(bundlesByLocale);
                try {
                    rb = ResourceBundle.getBundle(bundleName, locale);
                }
                catch (MissingResourceException e) {
                    rb = this.findBundleByLocale(bundleName, locale, bundlesByLocale);
                    if (rb != null) break block4;
                    throw (MissingResourceException)e.fillInStackTrace();
                }
            }
            if (rb != null) {
                bundlesByLocale.put(rb.getLocale(), rb);
                HashMap<String, HashMap<Locale, ResourceBundle>> bundlesByName = new HashMap<String, HashMap<Locale, ResourceBundle>>(this.bundles);
                bundlesByName.put(bundleName, bundlesByLocale);
                this.bundles = bundlesByName;
            }
        }
        return rb;
    }

    private ResourceBundle findBundleByLocale(String bundleName, Locale locale, Map bundlesByLocale) {
        Locale withDefaultLanguage;
        ResourceBundle rb = null;
        if (!StringUtils.isNotEmpty((String)locale.getCountry()) && this.defaultLanguage.equals(locale.getLanguage())) {
            Locale withDefaultCountry = new Locale(locale.getLanguage(), this.defaultCountry);
            rb = (ResourceBundle)bundlesByLocale.get(withDefaultCountry);
            if (rb == null) {
                rb = this.getBundleIgnoreException(bundleName, withDefaultCountry);
            }
        } else if (!StringUtils.isNotEmpty((String)locale.getLanguage()) && this.defaultCountry.equals(locale.getCountry()) && (rb = (ResourceBundle)bundlesByLocale.get(withDefaultLanguage = new Locale(this.defaultLanguage, locale.getCountry()))) == null) {
            rb = this.getBundleIgnoreException(bundleName, withDefaultLanguage);
        }
        if (rb == null && !this.defaultLocale.equals(locale)) {
            rb = this.getBundleIgnoreException(bundleName, this.defaultLocale);
        }
        return rb;
    }

    private ResourceBundle getBundleIgnoreException(String bundleName, Locale locale) {
        try {
            return ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundle(String defaultBundle) {
        if (this.bundleNames.length > 0) {
            this.bundleNames[0] = defaultBundle;
        } else {
            TurbineLocalizationService turbineLocalizationService = this;
            synchronized (turbineLocalizationService) {
                if (this.bundleNames.length <= 0) {
                    this.bundleNames = new String[]{defaultBundle};
                }
            }
        }
    }

    public final Locale getLocale(HttpServletRequest req) {
        return this.getLocale(req.getHeader("Accept-Language"));
    }

    public Locale getLocale(String header) {
        LocaleTokenizer tok;
        if (!StringUtils.isEmpty((String)header) && (tok = new LocaleTokenizer(header)).hasNext()) {
            return (Locale)tok.next();
        }
        return this.defaultLocale;
    }

    public String getString(String bundleName, Locale locale, String key) {
        ResourceBundle rb;
        String value = null;
        if (locale == null) {
            locale = this.getLocale((String)null);
        }
        if ((value = this.getStringOrNull(rb = this.getBundle(bundleName, locale), key)) == null && this.bundleNames.length > 0) {
            for (int i = 0; i < this.bundleNames.length; ++i) {
                String name = this.bundleNames[i];
                if (name.equals(bundleName) || (value = this.getStringOrNull(rb = this.getBundle(name, locale), key)) == null) continue;
                locale = rb.getLocale();
                break;
            }
        }
        if (value == null) {
            String loc = locale.toString();
            String mesg = "LocalizationService noticed missing resource: bundleName=" + bundleName + ", locale=" + loc + ", key=" + key;
            log.debug((Object)mesg);
            throw new MissingResourceException(mesg, bundleName, key);
        }
        return value;
    }

    protected final String getStringOrNull(ResourceBundle rb, String key) {
        if (rb != null) {
            try {
                return rb.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public String format(String bundleName, Locale locale, String key, Object arg1) {
        return this.format(bundleName, locale, key, new Object[]{arg1});
    }

    public String format(String bundleName, Locale locale, String key, Object arg1, Object arg2) {
        return this.format(bundleName, locale, key, new Object[]{arg1, arg2});
    }

    public String format(String bundleName, Locale locale, String key, Object[] args) {
        if (locale == null) {
            locale = this.getLocale((String)null);
        }
        String value = this.getString(bundleName, locale, key);
        if (args == null) {
            args = NO_ARGS;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(value);
        return messageFormat.format(args);
    }
}

