/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xmlrpc;

import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.xmlrpc.XmlRpcService;
import org.apache.turbine.util.TurbineException;

public abstract class TurbineXmlRpc {
    public static XmlRpcService getService() {
        return (XmlRpcService)TurbineServices.getInstance().getService("XmlRpcService");
    }

    public static Object executeRpc(URL url, String methodName, Vector params) throws TurbineException {
        return TurbineXmlRpc.getService().executeRpc(url, methodName, params);
    }

    public static Object executeAuthenticatedRpc(URL url, String username, String password, String methodName, Vector params) throws TurbineException {
        return TurbineXmlRpc.getService().executeAuthenticatedRpc(url, username, password, methodName, params);
    }

    public static void registerHandler(String handlerName, Object handler) {
        TurbineXmlRpc.getService().registerHandler(handlerName, handler);
    }

    public static void registerHandler(Object handler) {
        TurbineXmlRpc.getService().registerHandler(handler);
    }

    public static void unregisterHandler(String handlerName) {
        TurbineXmlRpc.getService().unregisterHandler(handlerName);
    }

    public static byte[] handleRequest(InputStream is) {
        return TurbineXmlRpc.getService().handleRequest(is);
    }

    public static byte[] handleRequest(InputStream is, String user, String password) {
        return TurbineXmlRpc.getService().handleRequest(is, user, password);
    }

    public static void send(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        TurbineXmlRpc.getService().send(serverURL, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public static void send(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        TurbineXmlRpc.getService().send(serverURL, username, password, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public static void get(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        TurbineXmlRpc.getService().get(serverURL, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public static void get(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        TurbineXmlRpc.getService().get(serverURL, username, password, sourceLocationProperty, sourceFileName, destinationLocationProperty, destinationFileName);
    }

    public static void remove(String serverURL, String sourceLocationProperty, String sourceFileName) throws TurbineException {
        TurbineXmlRpc.getService().remove(serverURL, sourceLocationProperty, sourceFileName);
    }

    public static void remove(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName) throws TurbineException {
        TurbineXmlRpc.getService().remove(serverURL, username, password, sourceLocationProperty, sourceFileName);
    }

    public static void setParanoid(boolean state) {
        TurbineXmlRpc.getService().setParanoid(state);
    }

    public static void acceptClient(String address) {
        TurbineXmlRpc.getService().acceptClient(address);
    }

    public static void denyClient(String address) {
        TurbineXmlRpc.getService().denyClient(address);
    }
}

