/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.cli;

import java.io.File;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.yaafi.cli.Getopt;
import org.apache.fulcrum.yaafi.cli.Shutdown;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerConfiguration;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerFactory;

public class Main
implements Runnable,
Disposable {
    public static final String APPLICATION_NAME = "yaafi.cli.applicationName";
    public static final String APPLICATION_HOME = "yaafi.cli.applicationHome";
    public static final String APPLICATION_TEMP = "yaafi.cli.tempHome";
    public static final String APPLICATION_CONFIG = "yaafi.cli.config";
    public static final String APPLICATION_HASSHUTDOWNHOOK = "yaafi.cli.hasShutdownHook";
    public static final String APPLICATION_ISBLOCKING = "yaafi.cli.isBlocking";
    private static final int SLEEP_TIME = 100;
    private static final int JOIN_TIME = 1000;
    private ServiceContainer container;
    private String containerConfigValue = "./conf/containerConfiguration.xml";
    private Thread shutdownThread;
    private boolean isBlocking = false;
    private boolean hasShutdownHook = true;
    private Logger logger = new ConsoleLogger();
    private String applicationName = "main";
    private String applicationHome = ".";
    private String tempHome = System.getProperty("java.io.tmpdir", ".");
    private String[] args = this.args != null ? this.args : new String[]{};
    private volatile boolean isInitialized = false;

    public Main() {
        this.containerConfigValue = System.getProperty(APPLICATION_CONFIG, this.containerConfigValue);
        this.applicationName = System.getProperty(APPLICATION_NAME, this.applicationName);
        this.applicationHome = System.getProperty(APPLICATION_HOME, this.applicationHome);
        this.tempHome = System.getProperty(APPLICATION_TEMP, this.tempHome);
    }

    public Main(String[] args) {
        this();
        this.args = args;
        Getopt getopt = new Getopt(this.args);
        this.setApplicationName(getopt.getStringValue(APPLICATION_NAME, this.getApplicationName()));
        this.setApplicationHome(getopt.getStringValue(APPLICATION_HOME, this.getApplicationHome()));
        this.setTempHome(getopt.getStringValue(APPLICATION_TEMP, this.getTempHome()));
        this.setContainerConfigValue(getopt.getStringValue(APPLICATION_CONFIG, this.getContainerConfigValue()));
        this.setIsBlocking(getopt.getBooleanValue(APPLICATION_ISBLOCKING, this.isBlocking));
        this.setHasShutdownHook(getopt.getBooleanValue(APPLICATION_HASSHUTDOWNHOOK, this.hasShutdownHook));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int exitCode = 0;
        Main impl = new Main(args);
        try {
            impl.run();
        }
        catch (Throwable t) {
            exitCode = 1;
        }
        finally {
            System.exit(exitCode);
        }
    }

    public static File makeAbsoluteFile(File baseDir, String name) {
        File result = new File(name);
        if (!result.isAbsolute()) {
            result = new File(baseDir, name);
        }
        return result;
    }

    public synchronized void dispose() {
        this.shutdown();
    }

    public void run() {
        try {
            this.initialize();
            this.onWait();
        }
        catch (Throwable t) {
            String msg = "Failed to run " + this.getClass().getName();
            this.getLogger().error(msg, t);
            throw new RuntimeException(t.getMessage());
        }
    }

    public void onWait() {
        while (this.isBlocking() && this.isInitialized()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public File makeAbsoluteFile(String fileName) {
        return Main.makeAbsoluteFile(new File(this.getApplicationHome()), fileName);
    }

    public String makeAbsolutePath(String fileName) {
        return Main.makeAbsoluteFile(new File(this.getApplicationHome()), fileName).getAbsolutePath();
    }

    public ServiceContainer getServiceContainer() {
        return this.container;
    }

    public ServiceManager getServiceManager() {
        return this.container;
    }

    public String getApplicationHome() {
        return this.applicationHome;
    }

    public void setApplicationHome(String applicationHome) {
        this.applicationHome = applicationHome;
    }

    public String getContainerConfigValue() {
        return this.containerConfigValue;
    }

    public void setContainerConfigValue(String containerConfigValue) {
        this.containerConfigValue = containerConfigValue;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setIsBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    public void setIsBlocking(Boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    public void setIsBlocking(String isBlocking) {
        this.isBlocking = Boolean.valueOf(isBlocking);
    }

    public String getTempHome() {
        return this.tempHome;
    }

    public void setTempHome(String tempHome) {
        this.tempHome = tempHome;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public boolean hasShutdownHook() {
        return this.hasShutdownHook;
    }

    public void setHasShutdownHook(boolean hasShutdownHook) {
        this.hasShutdownHook = hasShutdownHook;
    }

    public void setHasShutdownHook(Boolean hasShutdownHook) {
        this.hasShutdownHook = hasShutdownHook;
    }

    public void setHasShutdownHook(String hasShutdownHook) {
        this.hasShutdownHook = Boolean.valueOf(hasShutdownHook);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        StringBuffer argsLine = new StringBuffer();
        result.append(this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
        result.append('[');
        result.append("workingDir=" + new File("").getAbsolutePath());
        result.append(',');
        result.append("args=");
        for (int i = 0; i < this.getArgs().length; ++i) {
            argsLine.append(this.getArgs()[i]);
            if (i + 1 >= this.getArgs().length) continue;
            argsLine.append(" ");
        }
        result.append(argsLine.toString());
        result.append(',');
        result.append("applicationName=" + this.getApplicationName());
        result.append(',');
        result.append("applicationHome=" + this.getApplicationHome());
        result.append(',');
        result.append("tempHome=" + this.getTempHome());
        result.append(',');
        result.append("logger=" + this.getLogger().getClass().getName());
        result.append(',');
        result.append("isBlocking=" + this.isBlocking);
        result.append(',');
        result.append("hasShutdownHook=" + this.hasShutdownHook());
        result.append(',');
        result.append("containerConfigValue=" + this.getContainerConfigValue());
        result.append(']');
        return result.toString();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public void initialize() throws Exception {
        this.getLogger().debug("Initializing " + this.getClass().getName());
        ServiceContainerConfiguration config = new ServiceContainerConfiguration();
        config.setLogger(this.getLogger());
        config.setApplicationRootDir(this.getApplicationHome());
        config.setTempRootDir(this.getTempHome());
        config.loadContainerConfiguration(this.getContainerConfigValue(), "auto");
        this.container = ServiceContainerFactory.create(config);
        if (this.hasShutdownHook()) {
            this.getLogger().debug("Registering shutdown hook");
            Shutdown shutdown = new Shutdown(this);
            this.shutdownThread = new Thread((Runnable)shutdown, "ShutdownThread");
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        this.setInitialized(true);
    }

    protected void shutdown() {
        if (!this.isInitialized()) {
            return;
        }
        this.getLogger().debug("Terminating " + this.getClass().getName());
        try {
            if (this.shutdownThread != null) {
                try {
                    this.getLogger().debug("Waiting for shutdown handler thread to terminate");
                    this.shutdownThread.join(1000L);
                    this.shutdownThread = null;
                    this.getLogger().debug("Shutdown handler thread is terminated");
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.getServiceContainer() != null) {
                this.getServiceContainer().dispose();
                this.container = null;
            }
            this.setInitialized(false);
        }
        catch (Exception e) {
            String msg = "Failed to terminate " + this.getClass().getName();
            this.getLogger().error(msg, (Throwable)e);
        }
    }
}

