/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.Database;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.MapHelper;
import org.apache.torque.map.TableMap;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.ExceptionMapper;
import org.apache.torque.util.JdbcTypedValue;
import org.apache.torque.util.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePeerImpl<T>
implements Serializable {
    private static final long serialVersionUID = -7702123730779032381L;
    private static final Log log = LogFactory.getLog(BasePeerImpl.class);
    private RecordMapper<T> recordMapper = null;
    private TableMap tableMap = null;
    private String databaseName = null;

    public BasePeerImpl() {
    }

    public BasePeerImpl(RecordMapper<T> recordMapper, TableMap tableMap, String databaseName) {
        this();
        this.setRecordMapper(recordMapper);
        this.setTableMap(tableMap);
        this.setDatabaseName(databaseName);
    }

    public void setRecordMapper(RecordMapper<T> recordMapper) {
        this.recordMapper = recordMapper;
    }

    public RecordMapper<T> getRecordMapper() throws TorqueException {
        if (this.recordMapper == null) {
            throw new TorqueException("No record mapper injected");
        }
        return this.recordMapper;
    }

    public void setTableMap(TableMap tableMap) {
        this.tableMap = tableMap;
    }

    public TableMap getTableMap() throws TorqueException {
        if (this.tableMap == null) {
            throw new TorqueException("No table map injected");
        }
        return this.tableMap;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() throws TorqueException {
        if (this.databaseName == null) {
            throw new TorqueException("No database name injected");
        }
        return this.databaseName;
    }

    @Deprecated
    public String[] initCriteriaKeys(String tableName, String[] columnNames) {
        String[] keys = new String[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            keys[i] = tableName + "." + columnNames[i].toUpperCase();
        }
        return keys;
    }

    @Deprecated
    public int deleteAll(Connection con, String table, String column, int value) throws TorqueException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("DELETE FROM ").append(table).append(" WHERE ").append(column).append(" = ").append(value);
            int n = statement.executeUpdate(query.toString());
            return n;
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new TorqueException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int deleteAll(String table, String column, int value) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin(Torque.getDefaultDB());
            int result = this.deleteAll(con, table, column, value);
            Transaction.commit(con);
            con = null;
            int n = result;
            return n;
        }
        finally {
            if (con != null) {
                Transaction.safeRollback(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doDelete(org.apache.torque.criteria.Criteria criteria) throws TorqueException {
        int n;
        block3: {
            Connection connection = null;
            try {
                this.setDbName(criteria);
                connection = Transaction.begin(criteria.getDbName());
                int deletedRows = this.doDelete(criteria, connection);
                Transaction.commit(connection);
                connection = null;
                n = deletedRows;
                if (connection == null) break block3;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    Transaction.safeRollback(connection);
                }
                throw throwable;
            }
            Transaction.safeRollback(connection);
        }
        return n;
    }

    public int doDelete(org.apache.torque.criteria.Criteria criteria, Connection connection) throws TorqueException {
        this.correctBooleans(criteria);
        this.setDbName(criteria);
        Query query = SqlBuilder.buildQuery(criteria);
        query.setType(Query.Type.DELETE);
        String fullTableName = this.tableMap == null ? SqlBuilder.guessFullTableFromCriteria(criteria) : SqlBuilder.getFullTableName(this.tableMap.getFullyQualifiedTableName(), criteria.getDbName());
        boolean ownTableAdded = false;
        for (FromElement fromElement : query.getFromClause()) {
            if (!fullTableName.equalsIgnoreCase(fromElement.getFromExpression())) continue;
            ownTableAdded = true;
            break;
        }
        if (!ownTableAdded) {
            query.getFromClause().add(new FromElement(fullTableName));
        }
        String sql = query.toString();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            List<Object> replacements = this.setPreparedStatementReplacements(preparedStatement, query.getPreparedStatementReplacements(), 0);
            long startTime = System.currentTimeMillis();
            log.debug((Object)("Executing delete " + sql + ", parameters = " + replacements));
            int affectedRows = preparedStatement.executeUpdate();
            long queryEndTime = System.currentTimeMillis();
            log.trace((Object)("delete took " + (queryEndTime - startTime) + " milliseconds"));
            preparedStatement.close();
            preparedStatement = null;
            int n = affectedRows;
            return n;
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing prepared statement", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected int doDelete(Criteria criteria) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin(criteria.getDbName());
            int result = this.doDelete(criteria, con);
            Transaction.commit(con);
            con = null;
            int n = result;
            return n;
        }
        finally {
            if (con != null) {
                Transaction.safeRollback(con);
            }
        }
    }

    @Deprecated
    protected int doDelete(Criteria criteria, Connection con) throws TorqueException {
        if (criteria.values().isEmpty()) {
            throw new TorqueException("No conditions found in Criteria");
        }
        Criteria.Criterion criterion = criteria.values().iterator().next();
        TableMap tableMapFromCriteria = MapHelper.getTableMap(criterion.getColumn(), criteria, null);
        if (tableMapFromCriteria == null) {
            throw new TorqueException("Unqualified column name in criteria or table name not found in database map");
        }
        Query query = SqlBuilder.buildQuery(criteria);
        query.setType(Query.Type.DELETE);
        String fullTableName = null;
        if (this.tableMap != null) {
            fullTableName = SqlBuilder.getFullTableName(this.tableMap.getFullyQualifiedTableName(), criteria.getDbName());
        } else {
            Column column = criteria.values().iterator().next().getColumn();
            fullTableName = SqlBuilder.getFullTableName(column.getFullTableName(), criteria.getDbName());
        }
        boolean ownTableAdded = false;
        for (FromElement fromElement : query.getFromClause()) {
            if (!fullTableName.equalsIgnoreCase(fromElement.getFromExpression())) continue;
            ownTableAdded = true;
            break;
        }
        if (!ownTableAdded) {
            query.getFromClause().add(new FromElement(fullTableName));
        }
        String sql = query.toString();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(sql);
            List<Object> replacements = this.setPreparedStatementReplacements(preparedStatement, query.getPreparedStatementReplacements(), 0);
            long startTime = System.currentTimeMillis();
            log.debug((Object)("Executing delete " + sql + ", parameters = " + replacements));
            int affectedRows = preparedStatement.executeUpdate();
            long queryEndTime = System.currentTimeMillis();
            log.trace((Object)("delete took " + (queryEndTime - startTime) + " milliseconds"));
            preparedStatement.close();
            preparedStatement = null;
            int n = affectedRows;
            return n;
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing prepared statement", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectKey doInsert(ColumnValues insertValues) throws TorqueException {
        String databaseNameFromInsertValues = insertValues.getDbName();
        if (databaseNameFromInsertValues == null) {
            databaseNameFromInsertValues = this.getDatabaseName();
        }
        Connection connection = null;
        try {
            connection = Transaction.begin(databaseNameFromInsertValues);
            ObjectKey id = this.doInsert(insertValues, connection);
            Transaction.commit(connection);
            connection = null;
            ObjectKey objectKey = id;
            return objectKey;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    public ObjectKey doInsert(ColumnValues insertValues, Connection connection) throws TorqueException {
        if (insertValues == null) {
            throw new TorqueException("insertValues is null");
        }
        if (connection == null) {
            throw new TorqueException("connection is null");
        }
        String databaseNameFromInsertValues = insertValues.getDbName();
        if (databaseNameFromInsertValues == null) {
            databaseNameFromInsertValues = this.getDatabaseName();
        }
        Database database = Torque.getDatabase(databaseNameFromInsertValues);
        Object keyInfo = this.getIdMethodInfo();
        IdGenerator keyGen = database.getIdGenerator(this.getTableMap().getPrimaryKeyMethod());
        SimpleKey id = null;
        ColumnMap primaryKey = null;
        if (keyGen != null) {
            primaryKey = this.getTableMap().getPrimaryKey();
            if (keyGen.isPriorToInsert() && primaryKey != null && !insertValues.containsKey(primaryKey)) {
                id = this.getId(primaryKey, keyGen, connection, keyInfo);
                insertValues.put(primaryKey, new JdbcTypedValue(id.getValue(), id.getJdbcType()));
            }
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<JdbcTypedValue> replacementObjects = new ArrayList<JdbcTypedValue>();
        for (Map.Entry<Column, JdbcTypedValue> columnValue : insertValues.entrySet()) {
            Column column = columnValue.getKey();
            columnNames.add(column.getColumnName());
            JdbcTypedValue value = columnValue.getValue();
            replacementObjects.add(value);
        }
        String fullTableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), databaseNameFromInsertValues);
        StringBuilder query = new StringBuilder("INSERT INTO ").append(fullTableName).append("(").append(StringUtils.join(columnNames, (String)",")).append(") VALUES (");
        for (int i = 0; i < columnNames.size(); ++i) {
            if (i != 0) {
                query.append(",");
            }
            query.append("?");
        }
        query.append(")");
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(query.toString());
            int position = 1;
            for (JdbcTypedValue replacementObject : replacementObjects) {
                Object value = replacementObject.getValue();
                if (value != null) {
                    if (replacementObject.getJdbcType() != 2004 && replacementObject.getJdbcType() != 2005) {
                        preparedStatement.setObject(position, value, replacementObject.getJdbcType());
                    } else {
                        preparedStatement.setObject(position, value);
                    }
                } else {
                    preparedStatement.setNull(position, replacementObject.getJdbcType());
                }
                ++position;
            }
            long startTime = System.currentTimeMillis();
            log.debug((Object)("Executing insert " + query.toString() + " using parameters " + replacementObjects));
            preparedStatement.executeUpdate();
            long queryEndTime = System.currentTimeMillis();
            log.trace((Object)("insert took " + (queryEndTime - startTime) + " milliseconds"));
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing prepared statement", (Throwable)e);
                }
            }
        }
        if (keyGen != null && keyGen.isPostInsert() && primaryKey != null && !insertValues.containsKey(primaryKey)) {
            id = this.getId(primaryKey, keyGen, connection, keyInfo);
        }
        return id;
    }

    private Object getIdMethodInfo() throws TorqueException {
        IDMethod idMethod = this.tableMap.getPrimaryKeyMethod();
        if (IDMethod.NATIVE == idMethod) {
            Adapter adapter = Torque.getAdapter(this.getDatabaseName());
            if (adapter == null) {
                throw new TorqueException("missing adapter configuration for database " + this.getDatabaseName() + "check the Torque configuration");
            }
            idMethod = adapter.getIDMethodType();
        }
        Object keyInfo = this.tableMap.getPrimaryKeyMethodInfo(idMethod);
        return keyInfo;
    }

    private SimpleKey getId(ColumnMap pk, IdGenerator keyGen, Connection con, Object keyInfo) throws TorqueException {
        SimpleKey id = null;
        if (pk != null && keyGen != null) {
            id = pk.getType() instanceof Number ? new NumberKey(keyGen.getIdAsBigDecimal(con, keyInfo)) : new StringKey(keyGen.getIdAsString(con, keyInfo));
        }
        return id;
    }

    public void addSelectColumns(org.apache.torque.criteria.Criteria criteria) {
        ColumnMap[] columns;
        for (ColumnMap c : columns = this.tableMap.getColumns()) {
            criteria.addSelectColumn(c);
        }
    }

    @Deprecated
    public void addSelectColumns(Criteria criteria) {
        ColumnMap[] columns;
        for (ColumnMap c : columns = this.tableMap.getColumns()) {
            criteria.addSelectColumn(c);
        }
    }

    @Deprecated
    public List<T> doSelect(Criteria criteria) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            this.addSelectColumns(criteria);
        }
        this.setDbName(criteria);
        return this.doSelect(criteria, this.getRecordMapper());
    }

    public List<T> doSelect(org.apache.torque.criteria.Criteria criteria) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            this.addSelectColumns(criteria);
        }
        this.setDbName(criteria);
        return this.doSelect(criteria, this.getRecordMapper());
    }

    @Deprecated
    public List<T> doSelect(Criteria criteria, Connection connection) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            this.addSelectColumns(criteria);
        }
        this.setDbName(criteria);
        return this.doSelect(criteria, this.getRecordMapper(), connection);
    }

    public List<T> doSelect(org.apache.torque.criteria.Criteria criteria, Connection connection) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            this.addSelectColumns(criteria);
        }
        this.setDbName(criteria);
        return this.doSelect(criteria, this.getRecordMapper(), connection);
    }

    public T doSelectSingleRecord(org.apache.torque.criteria.Criteria criteria) throws TorqueException {
        List<T> recordList = this.doSelect(criteria);
        T record = null;
        if (recordList.size() > 1) {
            throw new TooManyRowsException("Criteria " + criteria + " matched more than one record");
        }
        if (!recordList.isEmpty()) {
            record = recordList.get(0);
        }
        return record;
    }

    public T doSelectSingleRecord(org.apache.torque.criteria.Criteria criteria, Connection connection) throws TorqueException {
        List<T> recordList = this.doSelect(criteria, connection);
        T record = null;
        if (recordList.size() > 1) {
            throw new TooManyRowsException("Criteria " + criteria + " matched more than one record");
        }
        if (!recordList.isEmpty()) {
            record = recordList.get(0);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <TT> List<TT> doSelect(Criteria criteria, RecordMapper<TT> mapper) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin(criteria.getDbName());
            List<TT> result = this.doSelect(criteria, mapper, connection);
            Transaction.commit(connection);
            connection = null;
            List<TT> list = result;
            return list;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TT> List<TT> doSelect(org.apache.torque.criteria.Criteria criteria, RecordMapper<TT> mapper) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin(criteria.getDbName());
            List<TT> result = this.doSelect(criteria, mapper, connection);
            Transaction.commit(connection);
            connection = null;
            List<TT> list = result;
            return list;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    public List<T> doSelect(String query) throws TorqueException {
        return this.doSelect(query, this.getRecordMapper(), this.getDatabaseName());
    }

    public List<T> doSelect(String query, Connection connection) throws TorqueException {
        return this.doSelect(query, this.getRecordMapper(), connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TT> List<TT> doSelect(String query, RecordMapper<TT> mapper, String dbName) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin(dbName == null ? Torque.getDefaultDB() : dbName);
            List<TT> result = this.doSelect(query, mapper, connection);
            Transaction.commit(connection);
            connection = null;
            List<TT> list = result;
            return list;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    public <TT> List<TT> doSelect(String query, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        ArrayList<TT> result = new ArrayList<TT>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            log.debug((Object)("Executing query " + query));
            resultSet = statement.executeQuery(query.toString());
            long queryEndTime = System.currentTimeMillis();
            log.trace((Object)("query took " + (queryEndTime - startTime) + " milliseconds"));
            while (resultSet.next()) {
                TT rowResult = mapper.processRow(resultSet, 0, null);
                result.add(rowResult);
            }
            long mappingEndTime = System.currentTimeMillis();
            log.trace((Object)("mapping took " + (mappingEndTime - queryEndTime) + " milliseconds"));
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing resultSet", (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing statement", (Throwable)e);
                }
            }
        }
        return result;
    }

    @Deprecated
    public <TT> List<TT> doSelect(Criteria criteria, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        this.correctBooleans(criteria);
        Query query = SqlBuilder.buildQuery(criteria);
        if (query.getFromClause().isEmpty()) {
            String tableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), criteria.getDbName());
            query.getFromClause().add(new FromElement(tableName));
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(query.toString());
            List<Object> replacements = this.setPreparedStatementReplacements(statement, query.getPreparedStatementReplacements(), 0);
            long startTime = System.currentTimeMillis();
            log.debug((Object)("Executing query " + query + ", parameters = " + replacements));
            resultSet = statement.executeQuery();
            long queryEndTime = System.currentTimeMillis();
            log.trace((Object)("query took " + (queryEndTime - startTime) + " milliseconds"));
            Database database = Torque.getDatabase(criteria.getDbName());
            long offset = database.getAdapter().supportsNativeOffset() ? 0L : criteria.getOffset();
            long limit = database.getAdapter().supportsNativeLimit() ? -1L : (database.getAdapter().supportsNativeOffset() ? (long)criteria.getLimit() : (criteria.getLimit() == -1 ? (long)criteria.getLimit() : offset + (long)criteria.getLimit()));
            ArrayList<TT> result = new ArrayList<TT>();
            int rowNumber = 0;
            while (resultSet.next()) {
                if ((long)rowNumber < offset) {
                    ++rowNumber;
                    continue;
                }
                if (limit >= 0L && (long)rowNumber >= limit) break;
                TT rowResult = mapper.processRow(resultSet, 0, criteria);
                result.add(rowResult);
                ++rowNumber;
            }
            long mappingEndTime = System.currentTimeMillis();
            log.trace((Object)("mapping took " + (mappingEndTime - queryEndTime) + " milliseconds"));
            if (criteria.isSingleRecord() && result.size() > 1) {
                throw new TooManyRowsException("Criteria expected single Record and Multiple Records were selected");
            }
            ArrayList<TT> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing resultSet", (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing statement", (Throwable)e);
                }
            }
        }
    }

    public <TT> List<TT> doSelect(org.apache.torque.criteria.Criteria criteria, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        this.correctBooleans(criteria);
        Query query = SqlBuilder.buildQuery(criteria);
        if (query.getFromClause().isEmpty()) {
            String tableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), criteria.getDbName());
            query.getFromClause().add(new FromElement(tableName));
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(query.toString());
            if (query.getFetchSize() != null) {
                statement.setFetchSize(query.getFetchSize());
            }
            List<Object> replacements = this.setPreparedStatementReplacements(statement, query.getPreparedStatementReplacements(), 0);
            long startTime = System.currentTimeMillis();
            log.debug((Object)("Executing query " + query + ", parameters = " + replacements));
            resultSet = statement.executeQuery();
            long queryEndTime = System.currentTimeMillis();
            log.trace((Object)("query took " + (queryEndTime - startTime) + " milliseconds"));
            Database database = Torque.getDatabase(criteria.getDbName());
            long offset = database.getAdapter().supportsNativeOffset() ? 0L : criteria.getOffset();
            long limit = database.getAdapter().supportsNativeLimit() ? -1L : (database.getAdapter().supportsNativeOffset() ? (long)criteria.getLimit() : (criteria.getLimit() == -1 ? (long)criteria.getLimit() : offset + (long)criteria.getLimit()));
            ArrayList<TT> result = new ArrayList<TT>();
            int rowNumber = 0;
            while (resultSet.next()) {
                if ((long)rowNumber < offset) {
                    ++rowNumber;
                    continue;
                }
                if (limit >= 0L && (long)rowNumber >= limit) break;
                TT rowResult = mapper.processRow(resultSet, 0, criteria);
                result.add(rowResult);
                ++rowNumber;
            }
            long mappingEndTime = System.currentTimeMillis();
            log.trace((Object)("mapping took " + (mappingEndTime - queryEndTime) + " milliseconds"));
            if (criteria.isSingleRecord() && result.size() > 1) {
                throw new TooManyRowsException("Criteria expected single Record and Multiple Records were selected");
            }
            ArrayList<TT> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing resultSet", (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing statement", (Throwable)e);
                }
            }
        }
    }

    public <TT> TT doSelectSingleRecord(org.apache.torque.criteria.Criteria criteria, RecordMapper<TT> mapper) throws TorqueException {
        List<TT> resultList = this.doSelect(criteria, mapper);
        TT result = null;
        if (resultList.size() > 1) {
            throw new TooManyRowsException("Criteria " + criteria + " matched more than one record");
        }
        if (!resultList.isEmpty()) {
            result = resultList.get(0);
        }
        return result;
    }

    public <TT> TT doSelectSingleRecord(org.apache.torque.criteria.Criteria criteria, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        List<TT> resultList = this.doSelect(criteria, mapper, connection);
        TT result = null;
        if (resultList.size() > 1) {
            throw new TooManyRowsException("Criteria " + criteria + " matched more than one record");
        }
        if (!resultList.isEmpty()) {
            result = resultList.get(0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doUpdate(ColumnValues updateValues) throws TorqueException {
        String databaseNameFromUpdateValues = updateValues.getDbName();
        if (databaseNameFromUpdateValues == null) {
            databaseNameFromUpdateValues = this.getDatabaseName();
        }
        Connection connection = null;
        try {
            connection = Transaction.begin(databaseNameFromUpdateValues);
            int result = this.doUpdate(updateValues, connection);
            Transaction.commit(connection);
            connection = null;
            int n = result;
            return n;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    public int doUpdate(ColumnValues updateValues, Connection connection) throws TorqueException {
        ColumnMap pk = this.getTableMap().getPrimaryKey();
        org.apache.torque.criteria.Criteria selectCriteria = null;
        if (pk == null || !updateValues.containsKey(pk.getSqlExpression())) {
            throw new TorqueException("No PK specified for database update");
        }
        selectCriteria = new org.apache.torque.criteria.Criteria();
        selectCriteria.where(pk, updateValues.remove(pk.getSqlExpression()));
        return this.doUpdate(selectCriteria, updateValues, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int doUpdate(Criteria selectCriteria, ColumnValues updateValues) throws TorqueException {
        String databaseNameFromUpdateValues = updateValues.getDbName();
        if (databaseNameFromUpdateValues == null) {
            databaseNameFromUpdateValues = this.getDatabaseName();
        }
        Connection connection = null;
        try {
            connection = Transaction.begin(databaseNameFromUpdateValues);
            int result = this.doUpdate(selectCriteria, updateValues, connection);
            Transaction.commit(connection);
            connection = null;
            int n = result;
            return n;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doUpdate(org.apache.torque.criteria.Criteria selectCriteria, ColumnValues updateValues) throws TorqueException {
        String databaseNameFromUpdateValues = updateValues.getDbName();
        if (databaseNameFromUpdateValues == null) {
            databaseNameFromUpdateValues = this.getDatabaseName();
        }
        Connection connection = null;
        try {
            connection = Transaction.begin(databaseNameFromUpdateValues);
            int result = this.doUpdate(selectCriteria, updateValues, connection);
            Transaction.commit(connection);
            connection = null;
            int n = result;
            return n;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    @Deprecated
    public int doUpdate(Criteria criteria, ColumnValues updateValues, Connection connection) throws TorqueException {
        Query query = SqlBuilder.buildQuery(criteria);
        query.setType(Query.Type.UPDATE);
        query.getFromClause().clear();
        String fullTableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), criteria.getDbName());
        query.getFromClause().add(new FromElement(fullTableName));
        ArrayList<JdbcTypedValue> replacementObjects = new ArrayList<JdbcTypedValue>();
        for (Map.Entry<Column, JdbcTypedValue> updateValue : updateValues.entrySet()) {
            Column column = updateValue.getKey();
            query.getSelectClause().add(column.getColumnName());
            replacementObjects.add(updateValue.getValue());
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(query.toString());
            int position = 1;
            for (JdbcTypedValue replacementObject : replacementObjects) {
                Object value = replacementObject.getValue();
                if (value != null) {
                    preparedStatement.setObject(position, value);
                } else {
                    preparedStatement.setNull(position, replacementObject.getJdbcType());
                }
                ++position;
            }
            List<Object> replacements = this.setPreparedStatementReplacements(preparedStatement, query.getPreparedStatementReplacements(), position - 1);
            long startTime = System.currentTimeMillis();
            log.debug((Object)("Executing update " + query.toString() + " using update parameters " + replacementObjects + " and query parameters " + replacements));
            int affectedRows = preparedStatement.executeUpdate();
            long queryEndTime = System.currentTimeMillis();
            log.trace((Object)("update took " + (queryEndTime - startTime) + " milliseconds"));
            preparedStatement.close();
            preparedStatement = null;
            int n = affectedRows;
            return n;
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing prepared statement", (Throwable)e);
                }
            }
        }
    }

    public int doUpdate(org.apache.torque.criteria.Criteria criteria, ColumnValues updateValues, Connection connection) throws TorqueException {
        Query query = SqlBuilder.buildQuery(criteria);
        query.setType(Query.Type.UPDATE);
        query.getFromClause().clear();
        String fullTableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), criteria.getDbName());
        query.getFromClause().add(new FromElement(fullTableName));
        ArrayList<JdbcTypedValue> replacementObjects = new ArrayList<JdbcTypedValue>();
        for (Map.Entry<Column, JdbcTypedValue> updateValue : updateValues.entrySet()) {
            Column column = updateValue.getKey();
            query.getSelectClause().add(column.getColumnName());
            replacementObjects.add(updateValue.getValue());
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(query.toString());
            int position = 1;
            for (JdbcTypedValue replacementObject : replacementObjects) {
                Object value = replacementObject.getValue();
                if (value != null) {
                    preparedStatement.setObject(position, value);
                } else {
                    preparedStatement.setNull(position, replacementObject.getJdbcType());
                }
                ++position;
            }
            List<Object> replacements = this.setPreparedStatementReplacements(preparedStatement, query.getPreparedStatementReplacements(), position - 1);
            long startTime = System.currentTimeMillis();
            log.debug((Object)("Executing update " + query.toString() + " using update parameters " + replacementObjects + " and query parameters " + replacements));
            int affectedRows = preparedStatement.executeUpdate();
            long queryEndTime = System.currentTimeMillis();
            log.trace((Object)("update took " + (queryEndTime - startTime) + " milliseconds"));
            preparedStatement.close();
            preparedStatement = null;
            int n = affectedRows;
            return n;
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"error closing prepared statement", (Throwable)e);
                }
            }
        }
    }

    public int executeStatement(String statementString) throws TorqueException {
        return this.executeStatement(statementString, Torque.getDefaultDB(), null);
    }

    public int executeStatement(String statementString, List<JdbcTypedValue> replacementValues) throws TorqueException {
        return this.executeStatement(statementString, Torque.getDefaultDB(), replacementValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeStatement(String statementString, String dbName, List<JdbcTypedValue> replacementValues) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin(dbName);
            int rowCount = this.executeStatement(statementString, con, replacementValues);
            Transaction.commit(con);
            con = null;
            int n = rowCount;
            return n;
        }
        finally {
            if (con != null) {
                Transaction.safeRollback(con);
            }
        }
    }

    public int executeStatement(String statementString, Connection con, List<JdbcTypedValue> replacementValues) throws TorqueException {
        int rowCount = -1;
        PreparedStatement statement = null;
        try {
            statement = con.prepareStatement(statementString);
            if (replacementValues != null) {
                int position = 1;
                for (JdbcTypedValue replacementValue : replacementValues) {
                    if (replacementValue.getValue() == null) {
                        statement.setNull(position, replacementValue.getJdbcType());
                    } else {
                        statement.setObject(position, replacementValue.getValue(), replacementValue.getJdbcType());
                    }
                    ++position;
                }
            }
            rowCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new TorqueException(e);
                }
            }
        }
        return rowCount;
    }

    private List<Object> setPreparedStatementReplacements(PreparedStatement statement, List<Object> replacements, int offset) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(replacements.size());
        int i = 1 + offset;
        for (Object param : replacements) {
            if (param instanceof Timestamp) {
                statement.setTimestamp(i, (Timestamp)param);
                result.add(param);
            } else if (param instanceof Date) {
                statement.setDate(i, (Date)param);
                result.add(param);
            } else if (param instanceof java.util.Date) {
                Timestamp sqlDate = new Timestamp(((java.util.Date)param).getTime());
                statement.setTimestamp(i, sqlDate);
                result.add(sqlDate);
            } else if (param instanceof NumberKey) {
                BigDecimal bigDecimal = ((NumberKey)param).getBigDecimal();
                statement.setBigDecimal(i, bigDecimal);
                result.add(bigDecimal);
            } else if (param instanceof Integer) {
                statement.setInt(i, (Integer)param);
                result.add(param);
            } else if (param instanceof Long) {
                statement.setLong(i, (Long)param);
                result.add(param);
            } else if (param instanceof BigDecimal) {
                statement.setBigDecimal(i, (BigDecimal)param);
                result.add(param);
            } else if (param instanceof Boolean) {
                statement.setBoolean(i, (Boolean)param);
                result.add(param);
            } else {
                statement.setString(i, param.toString());
                result.add(param.toString());
            }
            ++i;
        }
        return result;
    }

    @Deprecated
    public void correctBooleans(Criteria criteria) throws TorqueException {
        Iterator<Criteria.Criterion> i$ = criteria.values().iterator();
        while (i$.hasNext()) {
            Criteria.Criterion criterionObject;
            Criteria.Criterion criterion = criterionObject = i$.next();
            this.correctBooleans(criteria, criterion);
        }
    }

    @Deprecated
    private void correctBooleans(Criteria criteria, Criteria.Criterion criterion) throws TorqueException {
        String columnName;
        ColumnMap columnMap;
        Column column = criterion.getColumn();
        TableMap tableMapFromCriteria = MapHelper.getTableMap(column, criteria, this.tableMap);
        if (tableMapFromCriteria != null && (columnMap = tableMapFromCriteria.getColumn(columnName = column.getColumnName())) != null) {
            if ("BOOLEANINT".equals(columnMap.getTorqueType())) {
                this.replaceBooleanValues(criterion, (Object)1, (Object)0);
            } else if ("BOOLEANCHAR".equals(columnMap.getTorqueType())) {
                this.replaceBooleanValues(criterion, (Object)"Y", (Object)"N");
            }
        }
        for (Criteria.Criterion attachedCriterion : criterion.getClauses()) {
            this.correctBooleans(criteria, attachedCriterion);
        }
    }

    public void correctBooleans(org.apache.torque.criteria.Criteria criteria) throws TorqueException {
        this.correctBooleans(criteria, criteria.getTopLevelCriterion());
    }

    private void correctBooleans(org.apache.torque.criteria.Criteria criteria, Criterion criterion) throws TorqueException {
        if (criterion == null) {
            return;
        }
        if (criterion.isComposite()) {
            for (Criterion part : criterion.getParts()) {
                this.correctBooleans(criteria, part);
            }
            return;
        }
        Object possibleColumn = criterion.getLValue();
        TableMap tableMapForColumn = MapHelper.getTableMap(possibleColumn, criteria, this.tableMap);
        if (tableMapForColumn == null) {
            return;
        }
        String columnName = ((Column)possibleColumn).getColumnName();
        ColumnMap columnMap = tableMapForColumn.getColumn(columnName);
        if (columnMap != null) {
            if ("BOOLEANINT".equals(columnMap.getTorqueType())) {
                this.replaceBooleanValues(criterion, (Object)1, (Object)0);
            } else if ("BOOLEANCHAR".equals(columnMap.getTorqueType())) {
                this.replaceBooleanValues(criterion, (Object)"Y", (Object)"N");
            }
        }
    }

    @Deprecated
    private void replaceBooleanValues(Criteria.Criterion criterion, Object trueValue, Object falseValue) {
        Criteria.Criterion[] attachedCriterions = criterion.getAttachedCriterion();
        for (int i = 0; i < attachedCriterions.length; ++i) {
            Object criterionValue = attachedCriterions[i].getValue();
            if (!(criterionValue instanceof Boolean)) continue;
            Boolean booleanValue = (Boolean)criterionValue;
            attachedCriterions[i].setValue(Boolean.TRUE.equals(booleanValue) ? trueValue : falseValue);
        }
    }

    private void replaceBooleanValues(Criterion criterion, Object trueValue, Object falseValue) {
        Object lValue;
        Object rValue = criterion.getRValue();
        if (rValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)rValue;
            criterion.setRValue(Boolean.TRUE.equals(booleanValue) ? trueValue : falseValue);
        }
        if ((lValue = criterion.getLValue()) instanceof Boolean) {
            Boolean booleanValue = (Boolean)lValue;
            criterion.setLValue(Boolean.TRUE.equals(booleanValue) ? trueValue : falseValue);
        }
    }

    public void correctBooleans(ColumnValues columnValues) throws TorqueException {
        for (Map.Entry<Column, JdbcTypedValue> entry : columnValues.entrySet()) {
            String columnName = entry.getKey().getColumnName();
            ColumnMap column = this.getTableMap().getColumn(columnName);
            if (column == null) continue;
            JdbcTypedValue columnValue = entry.getValue();
            if ("BOOLEANINT".equals(column.getTorqueType())) {
                if (Boolean.TRUE.equals(columnValue.getValue())) {
                    entry.setValue(new JdbcTypedValue(1, 4));
                    continue;
                }
                if (Boolean.FALSE.equals(columnValue.getValue())) {
                    entry.setValue(new JdbcTypedValue(0, 4));
                    continue;
                }
                if (columnValue.getValue() != null) continue;
                entry.setValue(new JdbcTypedValue(null, 4));
                continue;
            }
            if (!"BOOLEANCHAR".equals(column.getTorqueType())) continue;
            if (Boolean.TRUE.equals(columnValue.getValue())) {
                entry.setValue(new JdbcTypedValue("Y", 1));
                continue;
            }
            if (Boolean.FALSE.equals(columnValue.getValue())) {
                entry.setValue(new JdbcTypedValue("N", 1));
                continue;
            }
            if (columnValue.getValue() != null) continue;
            entry.setValue(new JdbcTypedValue(null, 1));
        }
    }

    protected void setDbName(org.apache.torque.criteria.Criteria crit) throws TorqueException {
        if (crit.getDbName() == null) {
            crit.setDbName(this.getDatabaseName());
        }
    }

    @Deprecated
    protected void setDbName(Criteria crit) throws TorqueException {
        if (crit.getDbName() == null) {
            crit.setDbName(this.getDatabaseName());
        }
    }
}

