/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.math.ec;

import java.math.BigInteger;
import org.python.bouncycastle.math.ec.ECConstants;
import org.python.bouncycastle.util.Arrays;

class IntArray {
    private static final int[] INTERLEAVE_TABLE = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};
    private static final String ZEROES = "00000000000000000000000000000000";
    private static final byte[] bitLengths = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private int[] m_ints;

    public static int getWordLength(int n) {
        return n + 31 >>> 5;
    }

    public IntArray(int n) {
        this.m_ints = new int[n];
    }

    public IntArray(int[] nArray) {
        this.m_ints = nArray;
    }

    public IntArray(BigInteger bigInteger) {
        int n;
        int n2;
        if (bigInteger == null || bigInteger.signum() < 0) {
            throw new IllegalArgumentException("invalid F2m field value");
        }
        if (bigInteger.signum() == 0) {
            this.m_ints = new int[]{0};
            return;
        }
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray.length;
        int n4 = 0;
        if (byArray[0] == 0) {
            --n3;
            n4 = 1;
        }
        int n5 = (n3 + 3) / 4;
        this.m_ints = new int[n5];
        int n6 = n5 - 1;
        int n7 = n3 % 4 + n4;
        int n8 = 0;
        if (n4 < n7) {
            for (n2 = n4; n2 < n7; ++n2) {
                n8 <<= 8;
                n = byArray[n2] & 0xFF;
                n8 |= n;
            }
            this.m_ints[n6--] = n8;
        }
        while (n6 >= 0) {
            n8 = 0;
            for (n = 0; n < 4; ++n) {
                n8 <<= 8;
                int n9 = byArray[n2++] & 0xFF;
                n8 |= n9;
            }
            this.m_ints[n6] = n8;
            --n6;
        }
    }

    public boolean isZero() {
        int[] nArray = this.m_ints;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public int getUsedLength() {
        return this.getUsedLengthFrom(this.m_ints.length);
    }

    public int getUsedLengthFrom(int n) {
        int[] nArray = this.m_ints;
        if ((n = Math.min(n, nArray.length)) < 1) {
            return 0;
        }
        if (nArray[0] != 0) {
            while (nArray[--n] == 0) {
            }
            return n + 1;
        }
        do {
            if (nArray[--n] == 0) continue;
            return n + 1;
        } while (n > 0);
        return 0;
    }

    public int degree() {
        int n;
        int n2 = this.m_ints.length;
        do {
            if (n2 != 0) continue;
            return 0;
        } while ((n = this.m_ints[--n2]) == 0);
        return (n2 << 5) + IntArray.bitLength(n);
    }

    private static int bitLength(int n) {
        int n2 = n >>> 16;
        if (n2 == 0) {
            n2 = n >>> 8;
            return n2 == 0 ? bitLengths[n] : 8 + bitLengths[n2];
        }
        int n3 = n2 >>> 8;
        return n3 == 0 ? 16 + bitLengths[n2] : 24 + bitLengths[n3];
    }

    private int[] resizedInts(int n) {
        int[] nArray = new int[n];
        System.arraycopy(this.m_ints, 0, nArray, 0, Math.min(this.m_ints.length, n));
        return nArray;
    }

    public BigInteger toBigInteger() {
        int n;
        int n2;
        int n3 = this.getUsedLength();
        if (n3 == 0) {
            return ECConstants.ZERO;
        }
        int n4 = this.m_ints[n3 - 1];
        byte[] byArray = new byte[4];
        int n5 = 0;
        boolean bl = false;
        for (n2 = 3; n2 >= 0; --n2) {
            byte by = (byte)(n4 >>> 8 * n2);
            if (!bl && by == 0) continue;
            bl = true;
            byArray[n5++] = by;
        }
        n2 = 4 * (n3 - 1) + n5;
        byte[] byArray2 = new byte[n2];
        for (n = 0; n < n5; ++n) {
            byArray2[n] = byArray[n];
        }
        for (n = n3 - 2; n >= 0; --n) {
            for (int i = 3; i >= 0; --i) {
                byArray2[n5++] = (byte)(this.m_ints[n] >>> 8 * i);
            }
        }
        return new BigInteger(1, byArray2);
    }

    private static int shiftLeft(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            nArray[i] = n3 << 1 | n2;
            n2 = n3 >>> 31;
        }
        return n2;
    }

    public void addOneShifted(int n) {
        if (n >= this.m_ints.length) {
            this.m_ints = this.resizedInts(n + 1);
        }
        int n2 = n;
        this.m_ints[n2] = this.m_ints[n2] ^ 1;
    }

    private void addShiftedByBits(IntArray intArray, int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        if (n3 == 0) {
            this.addShiftedByWords(intArray, n2);
            return;
        }
        int n4 = intArray.getUsedLength();
        if (n4 == 0) {
            return;
        }
        int n5 = n4 + n2 + 1;
        if (n5 > this.m_ints.length) {
            this.m_ints = this.resizedInts(n5);
        }
        int n6 = 32 - n3;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            int n8 = intArray.m_ints[i];
            int n9 = i + n2;
            this.m_ints[n9] = this.m_ints[n9] ^ (n8 << n3 | n7);
            n7 = n8 >>> n6;
        }
        int n10 = n4 + n2;
        this.m_ints[n10] = this.m_ints[n10] ^ n7;
    }

    private static int addShiftedByBits(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = 32 - n2;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = nArray2[n5];
            int n7 = n5++;
            nArray[n7] = nArray[n7] ^ (n6 << n2 | n4);
            n4 = n6 >>> n3;
        }
        return n4;
    }

    private static int addShiftedByBits(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4) {
        int n5 = 32 - n4;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7 = nArray2[n2 + i];
            int n8 = n + i;
            nArray[n8] = nArray[n8] ^ (n7 << n4 | n6);
            n6 = n7 >>> n5;
        }
        return n6;
    }

    public void addShiftedByWords(IntArray intArray, int n) {
        int n2 = intArray.getUsedLength();
        if (n2 == 0) {
            return;
        }
        int n3 = n2 + n;
        if (n3 > this.m_ints.length) {
            this.m_ints = this.resizedInts(n3);
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = n + i;
            this.m_ints[n4] = this.m_ints[n4] ^ intArray.m_ints[i];
        }
    }

    private static void addShiftedByWords(int[] nArray, int n, int[] nArray2, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            nArray[n3] = nArray[n3] ^ nArray2[i];
        }
    }

    private static void add(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            nArray[n2] = nArray[n2] ^ nArray2[i];
        }
    }

    private static void distribute(int[] nArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            int n5 = nArray[n3 + i];
            int n6 = n + i;
            nArray[n6] = nArray[n6] ^ n5;
            int n7 = n2 + i;
            nArray[n7] = nArray[n7] ^ n5;
        }
    }

    public int getLength() {
        return this.m_ints.length;
    }

    public void flipWord(int n, int n2) {
        int n3 = n >>> 5;
        int n4 = this.m_ints.length;
        if (n3 < n4) {
            int n5 = n & 0x1F;
            if (n5 == 0) {
                int n6 = n3;
                this.m_ints[n6] = this.m_ints[n6] ^ n2;
            } else {
                int n7 = n3++;
                this.m_ints[n7] = this.m_ints[n7] ^ n2 << n5;
                if (n3 < n4) {
                    int n8 = n3;
                    this.m_ints[n8] = this.m_ints[n8] ^ n2 >>> 32 - n5;
                }
            }
        }
    }

    public int getWord(int n) {
        int n2 = n >>> 5;
        int n3 = this.m_ints.length;
        if (n2 >= n3) {
            return 0;
        }
        int n4 = n & 0x1F;
        if (n4 == 0) {
            return this.m_ints[n2];
        }
        int n5 = this.m_ints[n2] >>> n4;
        if (++n2 < n3) {
            n5 |= this.m_ints[n2] << 32 - n4;
        }
        return n5;
    }

    public boolean testBitZero() {
        return this.m_ints.length > 0 && (this.m_ints[0] & 1) != 0;
    }

    public boolean testBit(int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        return (this.m_ints[n2] & n4) != 0;
    }

    public void flipBit(int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        int n5 = n2;
        this.m_ints[n5] = this.m_ints[n5] ^ n4;
    }

    public void setBit(int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        int n5 = n2;
        this.m_ints[n5] = this.m_ints[n5] | n4;
    }

    public void clearBit(int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        int n5 = n2;
        this.m_ints[n5] = this.m_ints[n5] & ~n4;
    }

    public IntArray multiply(IntArray intArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getUsedLength();
        if (n6 == 0) {
            return new IntArray(1);
        }
        int n7 = intArray.getUsedLength();
        if (n7 == 0) {
            return new IntArray(1);
        }
        IntArray intArray2 = this;
        IntArray intArray3 = intArray;
        if (n6 > n7) {
            intArray2 = intArray;
            intArray3 = this;
            n5 = n6;
            n6 = n7;
            n7 = n5;
        }
        if (n6 == 1) {
            n5 = intArray2.m_ints[0];
            int[] nArray = intArray3.m_ints;
            int[] nArray2 = new int[n6 + n7];
            if ((n5 & 1) != 0) {
                IntArray.add(nArray2, nArray, n7);
            }
            int n8 = 1;
            while ((n5 >>>= 1) != 0) {
                if ((n5 & 1) != 0) {
                    IntArray.addShiftedByBits(nArray2, nArray, n7, n8);
                }
                ++n8;
            }
            return new IntArray(nArray2);
        }
        n5 = n6 <= 8 ? 1 : 2;
        int n9 = 1 << n5;
        int n10 = 32 >>> n5;
        int n11 = n7;
        if (intArray3.m_ints[n7 - 1] >>> 33 - n10 != 0) {
            ++n11;
        }
        int n12 = n11 + n6;
        int[] nArray = new int[n12 << n9];
        System.arraycopy(intArray3.m_ints, 0, nArray, 0, n7);
        IntArray.interleave(intArray2.m_ints, 0, nArray, n11, n6, n5);
        int[] nArray3 = new int[1 << n9];
        for (n4 = 1; n4 < nArray3.length; ++n4) {
            nArray3[n4] = nArray3[n4 - 1] + n12;
        }
        n4 = (1 << n9) - 1;
        int n13 = 0;
        while (true) {
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = nArray[n11 + n3] >>> n13 & n4;
                if (n2 == 0) continue;
                IntArray.addShiftedByWords(nArray, n3 + nArray3[n2], nArray, n11);
            }
            if ((n13 += n9) >= 32) break;
            IntArray.shiftLeft(nArray, n11);
        }
        n3 = nArray3.length;
        n2 = n3 >>> 1;
        int n14 = 32;
        while (--n3 > 1) {
            if (n3 == n2) {
                IntArray.addShiftedByBits(nArray, nArray3[1], nArray, nArray3[n2], n12, n14 -= n10);
                n2 >>>= 1;
                continue;
            }
            IntArray.distribute(nArray, nArray3[n2], nArray3[n3 - n2], nArray3[n3], n12);
        }
        IntArray intArray4 = new IntArray(n12);
        System.arraycopy(nArray, nArray3[1], intArray4.m_ints, 0, n12);
        return intArray4;
    }

    public void reduce(int n, int[] nArray) {
        int n2;
        int n3 = this.getUsedLength();
        if (n3 < (n2 = n + 31 >>> 5)) {
            return;
        }
        int n4 = n << 1;
        int n5 = Math.min(n4 - 2, (n3 << 5) - 1);
        int n6 = nArray[nArray.length - 1];
        if (n6 < n - 31) {
            this.reduceWordWise(n5, n, nArray);
        } else {
            this.reduceBitWise(n5, n, nArray);
        }
        int n7 = n & 0x1F;
        if (n7 != 0) {
            int n8 = n2 - 1;
            this.m_ints[n8] = this.m_ints[n8] & (1 << n7) - 1;
        }
        if (n3 > n2) {
            this.m_ints = this.resizedInts(n2);
        }
    }

    private void reduceBitWise(int n, int n2, int[] nArray) {
        for (int i = n; i >= n2; --i) {
            if (!this.testBit(i)) continue;
            int n3 = i - n2;
            this.flipBit(n3);
            int n4 = nArray.length;
            while (--n4 >= 0) {
                this.flipBit(nArray[n4] + n3);
            }
        }
    }

    private void reduceWordWise(int n, int n2, int[] nArray) {
        int n3;
        for (int i = n3 = n2 + (n - n2 & 0xFFFFFFE0); i >= n2; i -= 32) {
            int n4 = this.getWord(i);
            if (n4 == 0) continue;
            int n5 = i - n2;
            this.flipWord(n5, n4);
            int n6 = nArray.length;
            while (--n6 >= 0) {
                this.flipWord(nArray[n6] + n5, n4);
            }
        }
    }

    public IntArray square(int n) {
        int n2 = this.getUsedLength();
        if (n2 == 0) {
            return this;
        }
        int n3 = n2 << 1;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.m_ints[n4 >>> 1];
            nArray[n4++] = IntArray.interleave16(n5 & 0xFFFF);
            nArray[n4++] = IntArray.interleave16(n5 >>> 16);
        }
        return new IntArray(nArray);
    }

    private static void interleave(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4) {
        for (int i = 0; i < n3; ++i) {
            nArray2[n2 + i] = IntArray.interleave(nArray[n + i], n4);
        }
    }

    private static int interleave(int n, int n2) {
        while (--n2 >= 0) {
            n = IntArray.interleave16(n & 0xFFFF) | IntArray.interleave16(n >>> 16) << 1;
        }
        return n;
    }

    private static int interleave16(int n) {
        return INTERLEAVE_TABLE[n & 0xFF] | INTERLEAVE_TABLE[n >>> 8] << 16;
    }

    public IntArray modInverse(int n, int[] nArray) {
        int n2 = this.degree();
        if (n2 == 1) {
            return this;
        }
        IntArray intArray = (IntArray)this.clone();
        int n3 = IntArray.getWordLength(n);
        IntArray intArray2 = new IntArray(n3);
        intArray2.setBit(n);
        intArray2.setBit(0);
        intArray2.setBit(nArray[0]);
        if (nArray.length > 1) {
            intArray2.setBit(nArray[1]);
            intArray2.setBit(nArray[2]);
        }
        IntArray intArray3 = new IntArray(n3);
        intArray3.setBit(0);
        IntArray intArray4 = new IntArray(n3);
        while (n2 != 0) {
            int n4 = n2 - intArray2.degree();
            if (n4 < 0) {
                IntArray intArray5 = intArray;
                intArray = intArray2;
                intArray2 = intArray5;
                IntArray intArray6 = intArray3;
                intArray3 = intArray4;
                intArray4 = intArray6;
                n4 = -n4;
            }
            intArray.addShiftedByBits(intArray2, n4);
            n2 = intArray.degree();
            if (n2 == 0) continue;
            intArray3.addShiftedByBits(intArray4, n4);
        }
        return intArray4;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntArray)) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        int n = this.getUsedLength();
        if (intArray.getUsedLength() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.m_ints[i] == intArray.m_ints[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getUsedLength();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 *= 31;
            n2 ^= this.m_ints[i];
        }
        return n2;
    }

    public Object clone() {
        return new IntArray(Arrays.clone(this.m_ints));
    }

    public String toString() {
        int n = this.getUsedLength();
        if (n == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.m_ints[--n]));
        while (--n >= 0) {
            String string = Integer.toBinaryString(this.m_ints[n]);
            int n2 = string.length();
            if (n2 < 32) {
                stringBuffer.append(ZEROES.substring(n2));
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

