/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.mimetype.MimeTypeService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.TurbineConstants;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;

public class LocaleUtils {
    private static final Logger log = LogManager.getLogger(LocaleUtils.class);
    private static Locale defaultLocale = null;
    private static Charset defaultCharSet = null;

    public static String getDefaultInputEncoding() {
        String inputEncoding = Turbine.getConfiguration().getString("input.encoding", TurbineConstants.PARAMETER_ENCODING_DEFAULT);
        log.debug("Input Encoding has been set to {}", (Object)inputEncoding);
        return inputEncoding;
    }

    public static Locale getDefaultLocale() {
        if (defaultLocale == null) {
            String lang = Turbine.getConfiguration().getString("locale.default.language", TurbineConstants.LOCALE_DEFAULT_LANGUAGE_DEFAULT);
            String country = Turbine.getConfiguration().getString("locale.default.country", TurbineConstants.LOCALE_DEFAULT_COUNTRY_DEFAULT);
            defaultLocale = new Locale(lang, country);
        }
        return defaultLocale;
    }

    @Deprecated
    public static String getDefaultCharSet() {
        return LocaleUtils.getDefaultCharset().name();
    }

    public static Charset getDefaultCharset() {
        Charset charset;
        String charSet;
        if (defaultCharSet == null && StringUtils.isNotEmpty((CharSequence)(charSet = Turbine.getConfiguration().getString("locale.default.charset", TurbineConstants.LOCALE_DEFAULT_CHARSET_DEFAULT)))) {
            defaultCharSet = LocaleUtils.charSetForName(charSet);
            log.debug("defaultCharSet = {} (From Properties)", (Object)defaultCharSet);
        }
        if ((charset = defaultCharSet) == null) {
            log.debug("Default charset is empty!");
            Locale locale = LocaleUtils.getDefaultLocale();
            log.debug("Locale is {}", (Object)locale);
            if (!locale.equals(Locale.US)) {
                log.debug("We don't have US Locale!");
                ServiceManager serviceManager = TurbineServices.getInstance();
                if (serviceManager.isRegistered(MimeTypeService.ROLE)) {
                    try {
                        MimeTypeService mimeTypeService = (MimeTypeService)serviceManager.getService(MimeTypeService.ROLE);
                        charset = LocaleUtils.charSetForName(mimeTypeService.getCharSet(locale));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    log.debug("Charset now {}", (Object)charset);
                }
            }
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
        }
        log.debug("Returning default Charset of {}", (Object)charset);
        return charset;
    }

    @Deprecated
    public static String getOverrideCharSet() {
        return Turbine.getConfiguration().getString("locale.override.charset");
    }

    public static Charset getOverrideCharset() {
        String charset = Turbine.getConfiguration().getString("locale.override.charset");
        if (StringUtils.isEmpty((CharSequence)charset)) {
            return null;
        }
        return LocaleUtils.charSetForName(charset);
    }

    private static Charset charSetForName(String charSet) {
        try {
            return Charset.forName(charSet);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            log.error("Illegal default charset {}", (Object)charSet);
            return null;
        }
    }
}

