/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class NearCondition
extends TypeSentiveCondition {
    private final NumberExpression min;
    private final NumberExpression max;
    private final BooleanExpression forward;
    private final BooleanExpression filtered;

    public NearCondition(TypeExpression type, NumberExpression min, NumberExpression max, BooleanExpression forward, BooleanExpression filtered) {
        super(type);
        this.min = min == null ? new SimpleNumberExpression(1) : min;
        this.max = max == null ? new SimpleNumberExpression(1) : max;
        this.forward = forward == null ? new SimpleBooleanExpression(true) : forward;
        this.filtered = filtered == null ? new SimpleBooleanExpression(false) : filtered;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        int maxValue = this.max.getIntegerValue(element.getParent());
        int minValue = this.min.getIntegerValue(element.getParent());
        boolean forwardValue = this.forward.getBooleanValue(element.getParent());
        FSIterator<AnnotationFS> it = this.filtered.getBooleanValue(element.getParent()) ? stream : stream.getUnfilteredBasicIterator();
        RutaBasic pointer = null;
        pointer = forwardValue ? stream.getEndAnchor(annotation.getEnd()) : stream.getBeginAnchor(annotation.getBegin());
        it.moveTo((FeatureStructure)pointer);
        for (int count = 0; count <= maxValue; ++count) {
            RutaBasic each;
            FeatureStructure featureStructure;
            if (count >= minValue && it.isValid() && (featureStructure = it.get()) instanceof RutaBasic && (each = (RutaBasic)featureStructure).isPartOf(this.type.getType(element.getParent()))) {
                return new EvaluatedCondition(this, true);
            }
            if (forwardValue) {
                it.moveToNext();
                continue;
            }
            it.moveToPrevious();
        }
        return new EvaluatedCondition(this, false);
    }

    public NumberExpression getMin() {
        return this.min;
    }

    public NumberExpression getMax() {
        return this.max;
    }

    public BooleanExpression getForward() {
        return this.forward;
    }

    public BooleanExpression getFiltered() {
        return this.filtered;
    }
}

