/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.antlr.runtime.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.FeatureDescription_impl;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.ide.core.RutaExtensionManager;
import org.apache.uima.ruta.ide.core.RutaKeywordsManager;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.core.extensions.IIDEActionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDEBlockExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDEBooleanFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDEConditionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDENumberFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDEStringFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDETypeFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IRutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.core.extensions.IRutaExtension;
import org.apache.uima.ruta.ide.parser.ast.FeatureMatchExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaAbstractDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaBlock;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaDeclareDeclarationsStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaFeatureDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaFunction;
import org.apache.uima.ruta.ide.parser.ast.RutaImportStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaImportTypesStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaPackageDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaRegExpRule;
import org.apache.uima.ruta.ide.parser.ast.RutaRuleElement;
import org.apache.uima.ruta.ide.parser.ast.RutaStringExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaStructureAction;
import org.apache.uima.ruta.ide.parser.ast.RutaTypeConstants;
import org.apache.uima.ruta.ide.parser.ast.RutaTypeDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.apache.uima.ruta.ide.validator.RutaCheckerDefaultProblem;
import org.apache.uima.ruta.ide.validator.RutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.validator.RutaCheckerUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.jface.preference.IPreferenceStore;

public class LanguageCheckerVisitor
extends ASTVisitor {
    private IProblemReporter pr;
    private ISourceLineTracker linetracker;
    private ISourceModule sourceModule;
    private Map<String, IIDEConditionExtension> conditionExtensions;
    private Map<String, IIDEActionExtension> actionExtensions;
    private Map<String, IIDENumberFunctionExtension> numberFunctionExtensions;
    private Map<String, IIDEBooleanFunctionExtension> booleanFunctionExtensions;
    private Map<String, IIDEStringFunctionExtension> stringFunctionExtensions;
    private Map<String, IIDETypeFunctionExtension> typeFunctionExtensions;
    private Map<String, IIDEBlockExtension> blockExtensions;
    private Map<String, String> namespaces;
    private Map<String, Set<String>> ambiguousTypeAlias;
    private final Stack<Map<String, Integer>> knownLocalVariables;
    private final Stack<String> blocks;
    private String matchedType;
    private String packageName = "";
    private Map<String, TypeDescription> typeDescriptionMap;
    private Map<String, Set<FeatureDescription>> featureDescriptionMap;
    private TypeSystemDescription typeSystemDescription;
    private final String implicitString = "Implicit";
    private Set<String> finalTypes;
    private boolean reportWarningOnShortNames;
    private RutaCheckerProblemFactory problemFactory;
    private ResourceManager resourceManager;
    private Set<String> allLongTypeNames;
    private String parentTypeInDeclaration;
    private ClassLoader classLoader;

    public LanguageCheckerVisitor(IProblemReporter problemReporter, ISourceLineTracker linetracker, ISourceModule sourceModule, ClassLoader classLoader) {
        this.pr = problemReporter;
        this.linetracker = linetracker;
        this.sourceModule = sourceModule;
        this.classLoader = classLoader;
        this.problemFactory = new RutaCheckerProblemFactory(sourceModule.getElementName(), linetracker);
        this.namespaces = new TreeMap<String, String>();
        this.ambiguousTypeAlias = new TreeMap<String, Set<String>>();
        this.allLongTypeNames = new HashSet<String>();
        this.knownLocalVariables = new Stack();
        this.knownLocalVariables.push(new HashMap());
        this.blocks = new Stack();
        this.initializePredefinedInformation();
        this.initializeExtensionInformation();
        IPreferenceStore store = RutaIdeUIPlugin.getDefault().getPreferenceStore();
        this.reportWarningOnShortNames = !store.getBoolean("BuilderErrorOnDuplicateShortnames");
    }

    public boolean visit(Statement s) throws Exception {
        if (s instanceof RutaPackageDeclaration) {
            this.packageName = ((RutaPackageDeclaration)s).getName();
            return false;
        }
        if (s instanceof RutaImportTypesStatement) {
            RutaImportTypesStatement stmt = (RutaImportTypesStatement)s;
            SimpleReference tsExpr = (SimpleReference)stmt.getExpression();
            Token typeToken = stmt.getTypeToken();
            Token pkgToken = stmt.getPkgToken();
            Token aliasToken = stmt.getAliasToken();
            if (tsExpr != null) {
                String localPath = tsExpr.getName();
                this.processCompleteTypeSystemImport(tsExpr, localPath, typeToken, pkgToken, aliasToken);
            }
        } else if (s instanceof RutaImportStatement) {
            if (((RutaImportStatement)s).getType() == 3) {
                SimpleReference sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
                String localPath = sRef.getName();
                this.processCompleteTypeSystemImport(sRef, localPath);
                return false;
            }
            if (((RutaImportStatement)s).getType() == 5) {
                SimpleReference sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
                String localPath = sRef.getName();
                try {
                    URL url = null;
                    IFile file = RutaCheckerUtils.checkScriptImport(localPath, this.sourceModule.getScriptProject());
                    if (file == null) {
                        url = RutaCheckerUtils.checkImportExistence(localPath + "TypeSystem", "xml", this.classLoader);
                    }
                    if (file == null && url == null) {
                        this.pr.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localPath));
                    } else {
                        IPath typeSystemDescriptorPath;
                        TypeSystemDescription tsDesc;
                        List<String> checkDuplicateShortNames;
                        IProject referredProject = this.sourceModule.getScriptProject().getProject();
                        if (file != null) {
                            referredProject = file.getProject();
                        }
                        if (!(checkDuplicateShortNames = this.checkOnAmbiguousShortNames(tsDesc = this.importCompleteTypeSystem(typeSystemDescriptorPath = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)file.getLocation(), (IProject)referredProject), url))).isEmpty()) {
                            this.pr.reportProblem(this.problemFactory.createDuplicateShortNameInImported((ASTNode)sRef, localPath, checkDuplicateShortNames, ProblemSeverity.WARNING));
                        }
                    }
                }
                catch (IOException e) {
                    this.pr.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localPath));
                }
                return false;
            }
        }
        if (s instanceof RutaDeclareDeclarationsStatement) {
            RutaDeclareDeclarationsStatement dds = (RutaDeclareDeclarationsStatement)s;
            ASTNode parent = dds.getParent();
            if (parent != null && parent instanceof RutaVariableReference) {
                RutaVariableReference p = (RutaVariableReference)parent;
                String name = p.getName();
                this.parentTypeInDeclaration = name = this.expand(name);
                if (this.finalTypes.contains(name)) {
                    IProblem problem = this.problemFactory.createInheritenceFinalProblem(p);
                    this.pr.reportProblem(problem);
                }
            }
            return true;
        }
        if (s instanceof RutaTypeDeclaration) {
            Set<FeatureDescription> set;
            IProblem problem;
            RutaTypeDeclaration newType = (RutaTypeDeclaration)s;
            String shortName = newType.getName();
            String longName = this.getLongNameOfNewType(shortName);
            if (this.namespaces.values().contains(longName)) {
                problem = this.problemFactory.createIdConflictsWithTypeProblem((RutaAbstractDeclaration)newType);
                this.pr.reportProblem(problem);
                return false;
            }
            if (this.reportWarningOnShortNames && this.namespaces.containsKey(shortName)) {
                problem = this.problemFactory.createDuplicateShortName((RutaAbstractDeclaration)newType, ProblemSeverity.WARNING);
                this.pr.reportProblem(problem);
                return false;
            }
            if (this.knowsVariable(shortName)) {
                problem = this.problemFactory.createIdConflictsWithVariableProblem((RutaAbstractDeclaration)newType);
                this.pr.reportProblem(problem);
                return false;
            }
            List features = newType.getFeatures();
            HashSet<Object> feats = new HashSet<Object>();
            if (this.parentTypeInDeclaration != null && (set = this.featureDescriptionMap.get(this.parentTypeInDeclaration)) != null) {
                feats.addAll(set);
            }
            if (features != null) {
                for (RutaFeatureDeclaration each : features) {
                    String type = each.getType();
                    type = this.translate(type);
                    type = this.expand(type);
                    FeatureDescription_impl f = new FeatureDescription_impl(each.getName(), "", type);
                    feats.add(f);
                    if (type.equals("INT") || type.equals("STRING") || type.equals("DOUBLE") || type.equals("FLOAT") || type.equals("BOOLEAN") || this.namespaces.keySet().contains(type) || this.namespaces.values().contains(type)) continue;
                    IProblem problem2 = this.problemFactory.createUnknownFeatureTypeProblem(each);
                    this.pr.reportProblem(problem2);
                }
                this.featureDescriptionMap.put(longName, feats);
            }
            this.addDeclaredType(shortName);
            return false;
        }
        if (s instanceof RutaVariableDeclaration) {
            IProblem problem;
            RutaVariableDeclaration newVar = (RutaVariableDeclaration)s;
            if (this.knowsVariable(newVar.getName())) {
                problem = this.problemFactory.createIdConflictsWithVariableProblem((RutaAbstractDeclaration)newVar);
                this.pr.reportProblem(problem);
                return false;
            }
            if (this.namespaces.containsKey(newVar.getName())) {
                problem = this.problemFactory.createIdConflictsWithTypeProblem((RutaAbstractDeclaration)newVar);
                this.pr.reportProblem(problem);
                return false;
            }
            this.knownLocalVariables.peek().put(newVar.getName(), newVar.getKind());
            return false;
        }
        if (s instanceof RutaRegExpRule) {
            RutaRegExpRule rule = (RutaRegExpRule)s;
            Map faMap = rule.getFeats();
            Set typeEntrySet = faMap.entrySet();
            for (Map.Entry entry : typeEntrySet) {
                Expression struct = (Expression)entry.getKey();
                String structure = "";
                if (struct != null) {
                    structure = this.sourceModule.getSource().substring(struct.sourceStart(), struct.sourceEnd());
                    structure = this.expand(structure);
                }
                Map fmap = (Map)entry.getValue();
                Set keySet = fmap.keySet();
                for (Expression fkey : keySet) {
                    if (!(fkey instanceof RutaExpression) || fkey.getKind() != 0x200000) continue;
                    String feat = fkey.toString();
                    boolean findFeature = this.findFeature(structure, feat = this.getFeatureName(fkey, feat), -1);
                    if (findFeature) continue;
                    IProblem problem = this.problemFactory.createUnknownFeatureProblem(fkey, structure);
                    this.pr.reportProblem(problem);
                }
            }
        }
        return true;
    }

    private void processCompleteTypeSystemImport(SimpleReference sRef, String localPath) throws CoreException {
        this.processCompleteTypeSystemImport(sRef, localPath, null, null, null);
    }

    private void processCompleteTypeSystemImport(SimpleReference sRef, String localPath, Token typeToken, Token pkgToken, Token aliasToken) throws CoreException {
        try {
            URL url = null;
            IFile file = RutaCheckerUtils.checkTypeSystemImport(localPath, this.sourceModule.getScriptProject());
            if (file == null) {
                url = RutaCheckerUtils.checkImportExistence(localPath, "xml", this.classLoader);
            }
            if (file == null && url == null) {
                this.pr.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localPath));
            } else {
                List<String> checkDuplicateShortNames;
                IPath path = file == null ? null : file.getLocation();
                TypeSystemDescription tsDesc = this.importTypeSystem(path, url, typeToken, pkgToken, aliasToken);
                if (this.reportWarningOnShortNames && !(checkDuplicateShortNames = this.checkOnAmbiguousShortNames(tsDesc)).isEmpty()) {
                    this.pr.reportProblem(this.problemFactory.createDuplicateShortNameInImported((ASTNode)sRef, localPath, checkDuplicateShortNames, ProblemSeverity.WARNING));
                }
            }
        }
        catch (IOException e) {
            this.pr.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localPath));
        }
        catch (InvalidXMLException e) {
            this.pr.reportProblem(this.problemFactory.createXMLProblem((ASTNode)sRef, localPath));
        }
    }

    private List<String> checkOnAmbiguousShortNames(TypeSystemDescription tsDesc) {
        ArrayList<String> checkDuplicateShortNames = new ArrayList<String>();
        for (TypeDescription each : tsDesc.getTypes()) {
            String longName = each.getName();
            String shortName = this.getShortName(longName);
            Set<String> set = this.ambiguousTypeAlias.get(shortName);
            if (set == null || set.size() <= 1) continue;
            checkDuplicateShortNames.addAll(set);
        }
        return checkDuplicateShortNames;
    }

    private TypeSystemDescription importTypeSystem(IPath path, URL url, Token typeToken, Token pkgToken, Token aliasToken) throws InvalidXMLException, IOException, MalformedURLException, CoreException {
        TypeSystemDescription tsDesc = null;
        tsDesc = path != null ? UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(path.toFile())) : UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(url));
        ResourceManager resMgr = this.getResourceManager(this.classLoader);
        tsDesc.resolveImports(resMgr);
        for (TypeDescription each : tsDesc.getTypes()) {
            String type;
            String pkg;
            String longName = each.getName();
            String shortName = this.getShortName(longName);
            if (pkgToken != null && !longName.startsWith((pkg = pkgToken.getText()) + ".") || typeToken != null && !longName.equals(type = typeToken.getText())) continue;
            if (aliasToken != null) {
                String alias = aliasToken.getText();
                shortName = typeToken == null ? alias + "." + shortName : alias;
            }
            this.importType(longName, shortName);
        }
        return tsDesc;
    }

    private ResourceManager getResourceManager(ClassLoader classloader) throws MalformedURLException, CoreException {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager_impl(classloader);
            List folders = RutaProjectUtils.getAllDescriptorFolders((IProject)this.sourceModule.getScriptProject().getProject());
            StringBuilder sb = new StringBuilder();
            Iterator iterator = folders.iterator();
            while (iterator.hasNext()) {
                IFolder iFolder = (IFolder)iterator.next();
                sb.append(iFolder.getLocation().toPortableString());
                if (!iterator.hasNext()) continue;
                sb.append(System.getProperty("path.separator"));
            }
            this.resourceManager.setDataPath(sb.toString());
        }
        return this.resourceManager;
    }

    public boolean visit(Expression s) throws Exception {
        IProblem problem;
        String feat;
        List<String> asList;
        String[] keywords;
        String name;
        if (s instanceof RutaRuleElement) {
            RutaRuleElement re = (RutaRuleElement)s;
            Expression head = re.getHead();
            if (head instanceof FeatureMatchExpression) {
                int lastIndexOf;
                FeatureMatchExpression fme = (FeatureMatchExpression)head;
                String text = fme.getFeature().getText();
                String twf = text.substring(0, lastIndexOf = text.lastIndexOf(46));
                if (this.getVariableType(twf) == 0x800000) {
                    this.matchedType = twf;
                } else {
                    twf = this.expand(twf);
                    this.matchedType = this.isFeatureMatch(twf);
                }
            } else if (head != null) {
                this.matchedType = this.sourceModule.getSource().substring(head.sourceStart(), head.sourceEnd());
            }
            this.matchedType = this.expand(this.matchedType);
            if (this.matchedType == null) {
                this.matchedType = "uima.tcas.Annotation";
            }
        }
        if (s instanceof FeatureMatchExpression) {
            FeatureMatchExpression fme = (FeatureMatchExpression)s;
            String featText = fme.getFeature().getText();
            this.checkTypeOfFeatureMatch(featText, fme);
            return true;
        }
        if (s instanceof RutaVariableReference) {
            RutaVariableReference ref = (RutaVariableReference)s;
            if ((ref.getType() & 0x800000) != 0) {
                name = ref.getName();
                if (name.equals("Document")) {
                    return false;
                }
                Set<String> set = this.ambiguousTypeAlias.get(name);
                if (set != null && !set.isEmpty()) {
                    this.pr.reportProblem(this.problemFactory.createAmbiguousShortName(ref, set, ProblemSeverity.ERROR));
                    return false;
                }
                if (this.namespaces.keySet().contains(name) || this.namespaces.values().contains(name) || this.allLongTypeNames.contains(name) || this.getVariableType(name) == 0x800000) {
                    return false;
                }
                if (this.isFeatureMatch(ref.getName()) != null) {
                    return false;
                }
                this.pr.reportProblem(this.problemFactory.createTypeProblem(ref, this.sourceModule));
                return false;
            }
            if (!this.isVariableDeclared(ref)) {
                return false;
            }
            this.checkTypeOfVariable(ref);
            return false;
        }
        if (s instanceof RutaAction) {
            List childs;
            IRutaExtension extension;
            RutaAction tma = (RutaAction)s;
            String actionName = this.sourceModule.getSource().substring(tma.getNameStart(), tma.getNameEnd());
            keywords = RutaKeywordsManager.getKeywords((int)5);
            asList = Arrays.asList(keywords);
            if (!(StringUtils.isEmpty((CharSequence)actionName) || "-".equals(actionName) || asList.contains(actionName) || "Implicit".equals(tma.getName()))) {
                IProblem problem2 = this.problemFactory.createUnknownActionProblem(tma);
                this.pr.reportProblem(problem2);
            }
            if ((extension = (IRutaExtension)this.actionExtensions.get(actionName)) != null) {
                extension.checkSyntax((Expression)tma, (IRutaCheckerProblemFactory)this.problemFactory, this.pr);
            }
            if (tma.getName().equals("GETFEATURE") || tma.getName().equals("SETFEATURE")) {
                childs = tma.getChilds();
                RutaStringExpression stringExpr = (RutaStringExpression)childs.get(0);
                feat = stringExpr.toString();
                boolean featureFound = this.findFeature(this.matchedType, feat = this.getFeatureName((Expression)stringExpr, feat), -1);
                if (!featureFound) {
                    problem = this.problemFactory.createUnknownFeatureProblem((Expression)stringExpr, this.matchedType);
                    this.pr.reportProblem(problem);
                }
            }
            if (tma.getKind() == 10051) {
                childs = tma.getChilds();
                try {
                    RutaVariableReference ref = (RutaVariableReference)childs.get(0);
                    RutaExpression expr = (RutaExpression)childs.get(1);
                    int type = expr.getKind();
                    if (ref.getType() == 0x1000000) {
                        ref.setType(type);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    return false;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
            if (s instanceof RutaStructureAction) {
                RutaStructureAction sa = (RutaStructureAction)s;
                Expression struct = sa.getStructure();
                String structure = null;
                if (struct != null) {
                    structure = this.sourceModule.getSource().substring(struct.sourceStart(), struct.sourceEnd());
                    structure = this.expand(structure);
                }
                Map assignments = sa.getAssignments();
                String action = this.sourceModule.getSource().substring(sa.getNameStart(), sa.getNameEnd());
                if (assignments != null && !action.equals("TRIE")) {
                    for (Expression each : assignments.keySet()) {
                        String feat2 = each.toString();
                        boolean featureFound = this.findFeature(structure, feat2 = this.getFeatureName(each, feat2), -1);
                        if (featureFound) continue;
                        IProblem problem3 = this.problemFactory.createUnknownFeatureProblem(each, structure);
                        this.pr.reportProblem(problem3);
                    }
                }
            }
        }
        if (s instanceof RutaCondition) {
            IRutaExtension extension;
            RutaCondition cond = (RutaCondition)s;
            String conditionName = this.sourceModule.getSource().substring(cond.getNameStart(), cond.getNameEnd());
            keywords = RutaKeywordsManager.getKeywords((int)4);
            asList = Arrays.asList(keywords);
            if (!(StringUtils.isEmpty((CharSequence)conditionName) || "-".equals(conditionName) || asList.contains(conditionName) || "Implicit".equals(cond.getName()))) {
                IProblem problem4 = this.problemFactory.createUnknownConditionProblem(cond);
                this.pr.reportProblem(problem4);
            }
            if ((extension = (IRutaExtension)this.conditionExtensions.get(conditionName)) != null) {
                extension.checkSyntax((Expression)cond, (IRutaCheckerProblemFactory)this.problemFactory, this.pr);
            }
            if (conditionName.equals("FEATURE") && this.matchedType != null) {
                String featureMatch;
                List args = cond.getChilds();
                RutaStringExpression se = (RutaStringExpression)args.get(0);
                feat = se.toString();
                boolean featureFound = this.findFeature(this.matchedType, feat = this.getFeatureName((Expression)se, feat), -1);
                if (!featureFound && (featureMatch = this.isFeatureMatch(this.matchedType)) != null) {
                    featureFound = this.findFeature(featureMatch, feat, -1);
                }
                if (!featureFound) {
                    problem = this.problemFactory.createUnknownFeatureProblem((Expression)se, this.matchedType);
                    this.pr.reportProblem(problem);
                }
            }
        }
        if (s instanceof RutaFunction) {
            IRutaExtension extension;
            RutaFunction f = (RutaFunction)s;
            name = f.getName();
            if (s.getKind() == 0x800000) {
                extension = (IRutaExtension)this.typeFunctionExtensions.get(name);
                if (extension != null) {
                    extension.checkSyntax(s, (IRutaCheckerProblemFactory)this.problemFactory, this.pr);
                }
            } else if (s.getKind() == 0x400000) {
                extension = (IRutaExtension)this.booleanFunctionExtensions.get(name);
                if (extension != null) {
                    extension.checkSyntax(s, (IRutaCheckerProblemFactory)this.problemFactory, this.pr);
                }
            } else if (s.getKind() == 262144) {
                extension = (IRutaExtension)this.numberFunctionExtensions.get(name);
                if (extension != null) {
                    extension.checkSyntax(s, (IRutaCheckerProblemFactory)this.problemFactory, this.pr);
                }
            } else if (s.getKind() == 0x200000 && (extension = (IRutaExtension)this.stringFunctionExtensions.get(name)) != null) {
                extension.checkSyntax(s, (IRutaCheckerProblemFactory)this.problemFactory, this.pr);
            }
        }
        return true;
    }

    private String expand(String shortName) {
        if (shortName == null) {
            return null;
        }
        String longName = shortName;
        String string = this.namespaces.get(shortName);
        if (string != null) {
            longName = string;
        }
        return longName;
    }

    private void checkTypeOfFeatureMatch(String featText, FeatureMatchExpression fme) {
        int lastIndexOf = featText.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return;
        }
        String aref = featText.substring(0, lastIndexOf);
        String fref = featText.substring(lastIndexOf + 1, featText.length());
        String match = this.isFeatureMatch(aref);
        if (match == null && this.getVariableType(aref) == 0x800000) {
            return;
        }
        if ((match = this.expand(match)) != null) {
            boolean findFeature;
            int kind = -1;
            if (fme.getValue() != null) {
                kind = fme.getValue().getKind();
                if (fme.getValue() instanceof StringLiteral) {
                    kind = 0x200000;
                } else if (fme.getValue() instanceof NumericLiteral) {
                    kind = 262144;
                }
            }
            if (!(findFeature = this.findFeature(match, fref, kind))) {
                this.pr.reportProblem(this.problemFactory.createUnknownFeatureProblem((Expression)fme, aref));
            }
        } else {
            this.pr.reportProblem(this.problemFactory.createTypeProblem(fme, this.sourceModule));
            this.pr.reportProblem(this.problemFactory.createUnknownFeatureProblem((Expression)fme, aref));
        }
    }

    public boolean endvisit(Expression s) throws Exception {
        if (s instanceof RutaRuleElement) {
            this.matchedType = null;
        }
        return super.endvisit(s);
    }

    public boolean endvisit(Statement s) throws Exception {
        if (s instanceof RutaDeclareDeclarationsStatement) {
            this.parentTypeInDeclaration = null;
        }
        return super.endvisit(s);
    }

    public boolean endvisit(MethodDeclaration s) throws Exception {
        if (s instanceof RutaBlock) {
            this.knownLocalVariables.pop();
            this.blocks.pop();
        }
        return super.endvisit(s);
    }

    public boolean visit(MethodDeclaration s) throws Exception {
        if (s instanceof RutaBlock) {
            RutaBlock b = (RutaBlock)s;
            this.knownLocalVariables.push(new HashMap());
            String name = b.getName();
            this.blocks.push(name);
        }
        return true;
    }

    private boolean findFeature(String longTypeName, String featureName, int kind) {
        if (longTypeName == null) {
            return false;
        }
        if ((longTypeName.equals("Document") || longTypeName.equals("org.apache.uima.ruta.type.Document") || longTypeName.equals("uima.tcas.DocumentAnnotation")) && (featureName.equals("language") || featureName.equals("begin") || featureName.equals("end"))) {
            return true;
        }
        if (featureName.equals("begin") || featureName.equals("end")) {
            return kind == -1 || kind == 262144;
        }
        Set<FeatureDescription> set = this.featureDescriptionMap.get(longTypeName);
        if (set != null) {
            for (FeatureDescription featureDescription : set) {
                String fName = featureDescription.getName();
                if (!fName.equals(featureName) || kind != -1 && !this.checkFeatureKind(featureDescription, kind)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkFeatureKind(FeatureDescription f, int kind) {
        if (kind == -1) {
            return true;
        }
        String t = f.getRangeTypeName();
        if (t.equals("uima.cas.Boolean") && 0x400000 == kind) {
            return true;
        }
        if (t.equals("uima.cas.String") && 0x200000 == kind) {
            return true;
        }
        return (t.equals("uima.cas.Byte") || t.equals("uima.cas.Double") || t.equals("uima.cas.Float") || t.equals("uima.cas.Integer") || t.equals("uima.cas.Long") || t.equals("uima.cas.Short")) && 262144 == kind;
    }

    private void addDeclaredType(String shortName) {
        String longName = this.getLongNameOfNewType(shortName);
        this.importType(longName, shortName);
    }

    private String getLongNameOfNewType(String shortName) {
        String moduleName = this.sourceModule.getElementName();
        moduleName = moduleName.substring(0, moduleName.length() - 5);
        String packagePrefix = "";
        if (!this.packageName.isEmpty()) {
            packagePrefix = this.packageName + ".";
        }
        for (String each : this.blocks) {
            packagePrefix = packagePrefix + each + ".";
        }
        String longName = packagePrefix + moduleName + "." + shortName;
        return longName;
    }

    private void importType(String longName, String shortName) {
        if (!this.allLongTypeNames.contains(longName)) {
            this.allLongTypeNames.add(longName);
        }
        Set<String> targets = this.ambiguousTypeAlias.get(shortName);
        if (targets != null) {
            targets.add(longName);
        } else {
            String existing = this.namespaces.put(shortName, longName);
            if (existing != null && !existing.equals(longName)) {
                targets = new HashSet<String>(2);
                targets.add(existing);
                targets.add(longName);
                this.ambiguousTypeAlias.put(shortName, targets);
                this.namespaces.remove(shortName);
            }
        }
    }

    private boolean knowsVariable(String name) {
        for (Map map : this.knownLocalVariables) {
            if (!map.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    private int getVariableType(String name) {
        for (Map map : this.knownLocalVariables) {
            Integer integer = (Integer)map.get(name);
            if (integer == null) continue;
            return integer;
        }
        return 0;
    }

    private String getFeatureName(Expression expression, String defaultValue) {
        Object object2;
        List childs2;
        Object object;
        String result = defaultValue;
        List childs = expression.getChilds();
        if (childs != null && !childs.isEmpty() && (object = childs.get(0)) instanceof ASTListNode && (childs2 = ((ASTListNode)object).getChilds()) != null && !childs2.isEmpty() && (object2 = childs2.get(0)) instanceof StringLiteral) {
            StringLiteral sl = (StringLiteral)object2;
            result = sl.getValue().replaceAll("\"", "");
        }
        return result;
    }

    private void initializePredefinedInformation() {
        this.typeDescriptionMap = new HashMap<String, TypeDescription>();
        this.featureDescriptionMap = new HashMap<String, Set<FeatureDescription>>();
        try {
            this.typeSystemDescription = this.getTypeSystemOfScript();
            IPath descriptorRootPath = RutaProjectUtils.getDescriptorRootPath((IProject)this.sourceModule.getScriptProject().getProject());
            IPath basicTSD = descriptorRootPath.append("BasicTypeSystem.xml");
            this.importCompleteTypeSystem(basicTSD, null);
        }
        catch (Exception e) {
            RutaIdeUIPlugin.error(e);
        }
        if (this.typeSystemDescription != null) {
            TypeDescription[] descriptions;
            for (TypeDescription typeDescription : descriptions = this.typeSystemDescription.getTypes()) {
                String typeName = typeDescription.getName();
                this.typeDescriptionMap.put(typeName, typeDescription);
            }
            for (TypeDescription typeDescription : descriptions) {
                Set<FeatureDescription> allFeatures = this.getAllDeclaredFeatures(typeDescription, this.typeDescriptionMap);
                this.featureDescriptionMap.put(typeDescription.getName(), allFeatures);
            }
        }
        List<String> uimaPredefTypes = Arrays.asList("uima.cas.Boolean", "uima.cas.Byte", "uima.cas.Short", "uima.cas.Integer", "uima.cas.Long", "uima.cas.Float", "uima.cas.Double", "uima.cas.String", "uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.ShortArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.FloatArray", "uima.cas.DoubleArray", "uima.cas.StringArray", "uima.cas.FSArray", "uima.cas.AnnotationBase", "uima.tcas.Annotation", "uima.tcas.DocumentAnnotation", "uima.cas.FloatList", "uima.cas.IntegerList", "uima.cas.StringList", "uima.cas.FSList", "uima.cas.EmptyFloatList", "uima.cas.EmptyIntegerList", "uima.cas.EmptyStringList", "uima.cas.EmptyFSList", "uima.cas.NonEmptyFloatList", "uima.cas.NonEmptyIntegerList", "uima.cas.NonEmptyStringList", "uima.cas.NonEmptyFSList");
        for (String longName : uimaPredefTypes) {
            String shortName = this.getShortName(longName);
            this.importType(longName, shortName);
        }
        this.finalTypes = new HashSet<String>();
        HashSet<String> uimaFinalTypes = new HashSet<String>();
        uimaFinalTypes.addAll(Arrays.asList("uima.cas.Boolean", "uima.cas.Byte", "uima.cas.Short", "uima.cas.Integer", "uima.cas.Long", "uima.cas.Float", "uima.cas.Double", "uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.ShortArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.FloatArray", "uima.cas.DoubleArray", "uima.cas.StringArray", "uima.cas.FSArray"));
        for (String string : uimaFinalTypes) {
            int indexOf = string.lastIndexOf(46);
            this.finalTypes.add(string);
            this.finalTypes.add(string.substring(indexOf + 1, string.length()));
        }
    }

    private TypeSystemDescription importCompleteTypeSystem(IPath path, URL url) throws InvalidXMLException, MalformedURLException, IOException, CoreException {
        return this.importTypeSystem(path, url, null, null, null);
    }

    private void initializeExtensionInformation() {
        IIDEBlockExtension[] bextensions;
        IIDETypeFunctionExtension[] tfextensions;
        IIDEStringFunctionExtension[] sfextensions;
        IIDEBooleanFunctionExtension[] bfextensions;
        IIDENumberFunctionExtension[] nfextensions;
        IIDEActionExtension[] aextensions;
        IIDEConditionExtension[] cextensions;
        this.conditionExtensions = new HashMap<String, IIDEConditionExtension>();
        this.actionExtensions = new HashMap<String, IIDEActionExtension>();
        this.numberFunctionExtensions = new HashMap<String, IIDENumberFunctionExtension>();
        this.booleanFunctionExtensions = new HashMap<String, IIDEBooleanFunctionExtension>();
        this.stringFunctionExtensions = new HashMap<String, IIDEStringFunctionExtension>();
        this.typeFunctionExtensions = new HashMap<String, IIDETypeFunctionExtension>();
        this.blockExtensions = new HashMap<String, IIDEBlockExtension>();
        for (IIDEConditionExtension each : cextensions = RutaExtensionManager.getDefault().getIDEConditionExtensions()) {
            String[] knownExtensions;
            for (String string : knownExtensions = each.getKnownExtensions()) {
                this.conditionExtensions.put(string, each);
            }
        }
        for (IIDEActionExtension each : aextensions = RutaExtensionManager.getDefault().getIDEActionExtensions()) {
            String[] knownExtensions;
            for (String string : knownExtensions = each.getKnownExtensions()) {
                this.actionExtensions.put(string, each);
            }
        }
        for (IIDENumberFunctionExtension each : nfextensions = RutaExtensionManager.getDefault().getIDENumberFunctionExtensions()) {
            String[] knownExtensions;
            for (String string : knownExtensions = each.getKnownExtensions()) {
                this.numberFunctionExtensions.put(string, each);
            }
        }
        for (IIDEBooleanFunctionExtension each : bfextensions = RutaExtensionManager.getDefault().getIDEBooleanFunctionExtensions()) {
            String[] knownExtensions;
            for (String string : knownExtensions = each.getKnownExtensions()) {
                this.booleanFunctionExtensions.put(string, each);
            }
        }
        for (IIDEStringFunctionExtension each : sfextensions = RutaExtensionManager.getDefault().getIDEStringFunctionExtensions()) {
            String[] knownExtensions;
            for (String string : knownExtensions = each.getKnownExtensions()) {
                this.stringFunctionExtensions.put(string, each);
            }
        }
        for (IIDETypeFunctionExtension each : tfextensions = RutaExtensionManager.getDefault().getIDETypeFunctionExtensions()) {
            String[] knownExtensions;
            for (String string : knownExtensions = each.getKnownExtensions()) {
                this.typeFunctionExtensions.put(string, each);
            }
        }
        for (IIDEBlockExtension each : bextensions = RutaExtensionManager.getDefault().getIDEBlockExtensions()) {
            String[] knownExtensions;
            for (String string : knownExtensions = each.getKnownExtensions()) {
                this.blockExtensions.put(string, each);
            }
        }
    }

    private Set<FeatureDescription> getAllDeclaredFeatures(TypeDescription typeDescription, Map<String, TypeDescription> typeMap) {
        HashSet<FeatureDescription> result = new HashSet<FeatureDescription>();
        if (typeDescription == null) {
            return result;
        }
        FeatureDescription[] features = typeDescription.getFeatures();
        if (features == null) {
            return result;
        }
        result.addAll(Arrays.asList(features));
        String supertypeName = typeDescription.getSupertypeName();
        if (supertypeName != null) {
            TypeDescription parent = typeMap.get(supertypeName);
            result.addAll(this.getAllDeclaredFeatures(parent, typeMap));
        }
        return result;
    }

    private String isFeatureMatch(String text) {
        String t;
        for (String each : this.namespaces.values()) {
            t = this.checkFeatureMatch(text, each);
            if (t == null) continue;
            return t;
        }
        for (String each : this.namespaces.keySet()) {
            t = this.checkFeatureMatch(text, each);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private String checkFeatureMatch(String name, String type) {
        if (name.startsWith(type)) {
            boolean foundAll = true;
            if (name.length() > type.length()) {
                String tail = name.substring(type.length() + 1);
                String[] split = tail.split("[.]");
                String typeToCheck = type;
                for (String feat : split) {
                    typeToCheck = this.expand(typeToCheck);
                    if (foundAll &= (typeToCheck = this.checkFSFeatureOfType(feat, typeToCheck)) != null) continue;
                    return null;
                }
                return typeToCheck;
            }
            return type;
        }
        return null;
    }

    private String checkFSFeatureOfType(String featureName, String longTypeName) {
        FeatureDescription[] features;
        TypeDescription t = this.typeDescriptionMap.get(longTypeName);
        if (t == null) {
            return null;
        }
        for (FeatureDescription featureDescription : features = t.getFeatures()) {
            String name = featureDescription.getName();
            String rangeTypeName = featureDescription.getRangeTypeName();
            boolean isFS = this.isFeatureStructure(rangeTypeName);
            if (!name.equals(featureName) || !isFS) continue;
            return rangeTypeName;
        }
        return null;
    }

    private boolean isFeatureStructure(String rangeTypeName) {
        if (rangeTypeName.equals("uima.tcas.Annotation") || rangeTypeName.equals("uima.cas.TOP")) {
            return true;
        }
        TypeDescription type = this.typeDescriptionMap.get(rangeTypeName);
        if (type == null) {
            return false;
        }
        String supertypeName = type.getSupertypeName();
        if (supertypeName != null) {
            return this.isFeatureStructure(supertypeName);
        }
        return false;
    }

    private boolean checkTypeOfVariable(RutaVariableReference ref) {
        Integer vt = this.getVariableType(ref.getName());
        if (vt == null) {
            IProblem problem = this.problemFactory.createUnknownVariableProblem(ref);
            this.pr.reportProblem(problem);
            return false;
        }
        int variableType = vt;
        int requiredType = ref.getType();
        if ((requiredType & 0x1000000) != 0) {
            return true;
        }
        if ((variableType & requiredType) == 0) {
            String errMsg = "Variable \"" + ref.getName() + "\" has type " + (String)RutaTypeConstants.typeStringOfInt.get(variableType) + ". But type " + (String)RutaTypeConstants.typeStringOfInt.get(requiredType) + " is required.";
            RutaCheckerDefaultProblem problem = new RutaCheckerDefaultProblem(this.sourceModule.getElementName(), errMsg, (ASTNode)ref, this.linetracker.getLineNumberOfOffset(ref.sourceStart()));
            this.pr.reportProblem((IProblem)problem);
            return false;
        }
        return true;
    }

    private boolean isVariableDeclared(RutaVariableReference ref) {
        if (!this.knowsVariable(ref.getName())) {
            if (this.namespaces.keySet().contains(ref.getName())) {
                String errMsg = "\"" + ref.getName() + "\" declared as a Type. Variable of type " + (String)RutaTypeConstants.typeStringOfInt.get(ref.getType()) + " required.";
                RutaCheckerDefaultProblem problem = new RutaCheckerDefaultProblem(this.sourceModule.getElementName(), errMsg, (ASTNode)ref, this.linetracker.getLineNumberOfOffset(ref.sourceStart()));
                this.pr.reportProblem((IProblem)problem);
                return false;
            }
            String errMsgHead = "Variable \"";
            String errMsgTailDefault = " defined in this script or block!";
            String errMsg = errMsgHead + ref.getName() + "\" not" + errMsgTailDefault;
            RutaCheckerDefaultProblem problem = new RutaCheckerDefaultProblem(this.sourceModule.getElementName(), errMsg, (ASTNode)ref, this.linetracker.getLineNumberOfOffset(ref.sourceStart()));
            this.pr.reportProblem((IProblem)problem);
            return false;
        }
        return true;
    }

    private String getShortName(String typeName) {
        String[] nameSpace = typeName.split("[.]");
        return nameSpace[nameSpace.length - 1];
    }

    private TypeSystemDescription getTypeSystemOfScript() throws InvalidXMLException, IOException, CoreException {
        IPath descriptorPath = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)this.sourceModule.getResource().getLocation(), (IProject)this.sourceModule.getScriptProject().getProject());
        TypeSystemDescription typeSysDescr = null;
        if (descriptorPath.toFile().exists()) {
            typeSysDescr = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(descriptorPath.toPortableString()));
            ResourceManager resMgr = this.getResourceManager(this.classLoader);
            typeSysDescr.resolveImports(resMgr);
        }
        return typeSysDescr;
    }

    private String translate(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("Annotation")) {
            return "uima.tcas.Annotation";
        }
        if (name.equals("STRING")) {
            return "uima.cas.String";
        }
        if (name.equals("INT")) {
            return "uima.cas.Integer";
        }
        if (name.equals("DOUBLE")) {
            return "uima.cas.Double";
        }
        if (name.equals("FLOAT")) {
            return "uima.cas.Float";
        }
        if (name.equals("BOOLEAN")) {
            return "uima.cas.Boolean";
        }
        if (name.equals("TYPE")) {
            return "uima.cas.String";
        }
        return name;
    }
}

