/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.type.RutaBasic;

public class RutaBasicUtils {
    private RutaBasicUtils() {
    }

    public static boolean addAnnotation(AnnotationFS annotation) {
        CAS cas = annotation.getCAS();
        TypeSystem typeSystem = cas.getTypeSystem();
        Type basicType = typeSystem.getType(RutaBasic.class.getName());
        if (basicType == null) {
            return false;
        }
        Type type = annotation.getType();
        if (typeSystem.subsumes(basicType, type)) {
            return false;
        }
        AnnotationIndex basicIndex = cas.getAnnotationIndex(basicType);
        if (basicIndex.size() == 0) {
            return false;
        }
        List coveredBasics = CasUtil.selectCovered((Type)basicType, (AnnotationFS)annotation);
        if (coveredBasics.size() == 0) {
            return false;
        }
        RutaBasic firstBasic = (RutaBasic)((Object)coveredBasics.get(0));
        RutaBasic lastBasic = (RutaBasic)((Object)coveredBasics.get(coveredBasics.size() - 1));
        firstBasic.addBegin(annotation, type);
        lastBasic.addEnd(annotation, type);
        for (AnnotationFS each : coveredBasics) {
            RutaBasic rutaBasic = (RutaBasic)each;
            rutaBasic.addPartOf(type);
        }
        return true;
    }

    public static boolean removeAnnotation(AnnotationFS annotation) {
        CAS cas = annotation.getCAS();
        TypeSystem typeSystem = cas.getTypeSystem();
        Type basicType = typeSystem.getType(RutaBasic.class.getName());
        if (basicType == null) {
            return false;
        }
        Type type = annotation.getType();
        if (typeSystem.subsumes(basicType, type)) {
            return false;
        }
        AnnotationIndex basicIndex = cas.getAnnotationIndex(basicType);
        if (basicIndex.size() == 0) {
            return false;
        }
        List coveredBasics = CasUtil.selectCovered((Type)basicType, (AnnotationFS)annotation);
        if (coveredBasics.size() == 0) {
            return false;
        }
        RutaBasic firstBasic = (RutaBasic)((Object)coveredBasics.get(0));
        RutaBasic lastBasic = (RutaBasic)((Object)coveredBasics.get(coveredBasics.size() - 1));
        firstBasic.removeBegin(annotation, type);
        lastBasic.removeEnd(annotation, type);
        for (AnnotationFS each : coveredBasics) {
            RutaBasic rutaBasic = (RutaBasic)each;
            rutaBasic.removePartOf(type);
        }
        return true;
    }

    public static void validateInternalIndexing(JCas jcas, Collection<String> ignoreTypeNames) throws AnalysisEngineProcessException {
        LinkedHashMap<Integer, RutaBasic> beginMap = new LinkedHashMap<Integer, RutaBasic>();
        LinkedHashMap<Integer, RutaBasic> endMap = new LinkedHashMap<Integer, RutaBasic>();
        Collection basics = JCasUtil.select((JCas)jcas, RutaBasic.class);
        if (basics.isEmpty()) {
            throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("No RutaBasics available!"));
        }
        for (RutaBasic rutaBasic : basics) {
            int begin = rutaBasic.getBegin();
            int end = rutaBasic.getEnd();
            if (beginMap.get(begin) != null || endMap.get(end) != null) {
                throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("RutaBasic must be disjunct! Problem at offset " + begin));
            }
            beginMap.put(begin, rutaBasic);
            endMap.put(end, rutaBasic);
        }
        for (Annotation annotation : JCasUtil.select((JCas)jcas, Annotation.class)) {
            Type type = annotation.getType();
            if (RutaBasicUtils.ignoreType(type, ignoreTypeNames, jcas)) continue;
            int begin = annotation.getBegin();
            int end = annotation.getEnd();
            RutaBasic beginBasic = (RutaBasic)((Object)beginMap.get(begin));
            RutaBasic endBasic = (RutaBasic)((Object)endMap.get(end));
            if (beginBasic == null) {
                throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("No RutaBasic for begin of annotation at offset " + begin));
            }
            if (endBasic == null) {
                throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("No RutaBasic for end of annotation at offset " + end));
            }
            Collection<AnnotationFS> beginAnchors = beginBasic.getBeginAnchors(type);
            if (beginAnchors == null || !beginAnchors.contains(annotation)) {
                throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("Annotation of type '" + type.getName() + "' not registered as begin at offset " + begin));
            }
            Collection<AnnotationFS> endAnchors = endBasic.getEndAnchors(type);
            if (endAnchors == null || !endAnchors.contains(annotation)) {
                throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("Annotation of type '" + type.getName() + "' not registered as end at offset " + begin));
            }
            List coveredBasics = JCasUtil.selectCovered(RutaBasic.class, (AnnotationFS)annotation);
            for (RutaBasic coveredBasic : coveredBasics) {
                if (coveredBasic.isPartOf(type)) continue;
                throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("Annotation of type '" + type.getName() + "' not registered as partof at offset [" + begin + "," + end + "]"));
            }
        }
    }

    private static boolean ignoreType(Type type, Collection<String> ignoreTypeNames, JCas jcas) {
        if (type == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)type.getName(), (CharSequence)RutaBasic.class.getName())) {
            return true;
        }
        if (ignoreTypeNames == null) {
            return false;
        }
        TypeSystem typeSystem = jcas.getTypeSystem();
        for (String typeName : ignoreTypeNames) {
            Type ignoreType = typeSystem.getType(typeName);
            if (ignoreType == null || !typeSystem.subsumes(ignoreType, type)) continue;
            return true;
        }
        return false;
    }
}

