/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class PartOfCondition
extends TypeSentiveCondition {
    public PartOfCondition(ITypeExpression type) {
        super(type);
    }

    public PartOfCondition(AbstractTypeListExpression list) {
        super(list);
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        Type t;
        AnnotationFS annotation = context.getAnnotation();
        RuleElement element = context.getElement();
        if (!this.isWorkingOnList()) {
            Type t2 = this.type.getType(context, stream);
            boolean result = this.check(t2, annotation, element, stream);
            return new EvaluatedCondition(this, result);
        }
        boolean result = false;
        List types = this.getList().getList(context, stream);
        Iterator iterator = types.iterator();
        while (iterator.hasNext() && !(result |= this.check(t = (Type)iterator.next(), annotation, element, stream))) {
        }
        return new EvaluatedCondition(this, result);
    }

    private boolean check(Type t, AnnotationFS annotation, RuleElement element, RutaStream stream) {
        if (annotation == null || t == null) {
            return false;
        }
        RutaBasic beginAnchor = stream.getBeginAnchor(annotation.getBegin());
        if (beginAnchor != null && beginAnchor.isPartOf(t)) {
            return true;
        }
        RutaBasic endAnchor = stream.getEndAnchor(annotation.getEnd());
        if (endAnchor != null && endAnchor.isPartOf(t)) {
            return true;
        }
        Collection<AnnotationFS> beginAnchors = beginAnchor.getBeginAnchors(t);
        if (beginAnchors != null && !beginAnchors.isEmpty()) {
            return true;
        }
        Collection<AnnotationFS> endAnchors = beginAnchor.getEndAnchors(t);
        return endAnchors != null && !endAnchors.isEmpty();
    }
}

