/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class DateValue
extends GDateValue {
    public DateValue(int n, byte by, byte by2) {
        this.year = n;
        this.month = by;
        this.day = by2;
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(int n, byte by, byte by2, int n2) {
        this.year = n;
        this.month = by;
        this.day = by2;
        this.setTimezoneInMinutes(n2);
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(int n, byte by, byte by2, int n2, AtomicType atomicType) {
        this.year = n;
        this.month = by;
        this.day = by2;
        this.setTimezoneInMinutes(n2);
        this.typeLabel = atomicType;
    }

    public DateValue(CharSequence charSequence) throws XPathException {
        this.setLexicalValue(charSequence);
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(GregorianCalendar gregorianCalendar, int n) {
        int n2 = gregorianCalendar.get(0);
        this.year = gregorianCalendar.get(1);
        if (n2 == 0) {
            this.year = 1 - this.year;
        }
        this.month = (byte)(gregorianCalendar.get(2) + 1);
        this.day = (byte)gregorianCalendar.get(5);
        this.setTimezoneInMinutes(n);
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DATE;
    }

    public static DateValue tomorrow(int n, byte by, byte by2) {
        if (DateValue.isValidDate(n, by, by2 + 1)) {
            return new DateValue(n, by, (byte)(by2 + 1));
        }
        if (by < 12) {
            return new DateValue(n, (byte)(by + 1), 1);
        }
        return new DateValue(n + 1, 1, 1);
    }

    public static DateValue yesterday(int n, byte by, byte by2) {
        if (by2 > 1) {
            return new DateValue(n, by, (byte)(by2 - 1));
        }
        if (by > 1) {
            if (by == 3 && DateValue.isLeapYear(n)) {
                return new DateValue(n, 2, 29);
            }
            return new DateValue(n, (byte)(by - 1), daysPerMonth[by - 2]);
        }
        return new DateValue(n - 1, 12, 31);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 521: 
            case 632: {
                return this;
            }
            case 519: {
                return this.toDateTime();
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 523: {
                return new GYearValue(this.year, this.getTimezoneInMinutes());
            }
            case 522: {
                return new GYearMonthValue(this.year, this.month, this.getTimezoneInMinutes());
            }
            case 526: {
                return new GMonthValue(this.month, this.getTimezoneInMinutes());
            }
            case 524: {
                return new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes());
            }
            case 525: {
                return new GDayValue(this.day, this.getTimezoneInMinutes());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert date to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n = this.year;
        if (this.year <= 0) {
            fastStringBuffer.append('-');
            n = -n + 1;
        }
        DateValue.appendString(fastStringBuffer, n, n > 9999 ? (n + "").length() : 4);
        fastStringBuffer.append('-');
        DateValue.appendTwoDigits(fastStringBuffer, this.month);
        fastStringBuffer.append('-');
        DateValue.appendTwoDigits(fastStringBuffer, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    public AtomicValue copy(AtomicType atomicType) {
        DateValue dateValue = new DateValue(this.year, this.month, this.day, this.getTimezoneInMinutes());
        dateValue.typeLabel = atomicType;
        return dateValue;
    }

    public CalendarValue adjustTimezone(int n) {
        DateTimeValue dateTimeValue = (DateTimeValue)this.toDateTime().adjustTimezone(n);
        return new DateValue(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay(), dateTimeValue.getTimezoneInMinutes());
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new Int64Value(this.year > 0 ? this.year : this.year - 1);
            }
            case 2: {
                return Int64Value.makeIntegerValue(this.month);
            }
            case 3: {
                return Int64Value.makeIntegerValue(this.day);
            }
            case 7: {
                if (this.hasTimezone()) {
                    return DayTimeDurationValue.fromMilliseconds(this.getTimezoneInMinutes() * 60000);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for date: " + n);
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof DayTimeDurationValue) {
            long l = ((DayTimeDurationValue)durationValue).getLengthInMicroseconds();
            boolean bl = l < 0L;
            l = Math.abs(l);
            int n = (int)Math.floor((double)l / 8.64E10);
            boolean bl2 = l % 86400000000L > 0L;
            int n2 = DateValue.getJulianDayNumber(this.year, this.month, this.day);
            DateValue dateValue = DateValue.dateFromJulianDayNumber(n2 + (bl ? -n : n));
            if (bl2 && bl) {
                dateValue = DateValue.yesterday(dateValue.year, dateValue.month, dateValue.day);
            }
            dateValue.setTimezoneInMinutes(this.getTimezoneInMinutes());
            return dateValue;
        }
        if (durationValue instanceof YearMonthDurationValue) {
            int n = ((YearMonthDurationValue)durationValue).getLengthInMonths();
            int n3 = this.month - 1 + n;
            int n4 = this.year + n3 / 12;
            if ((n3 %= 12) < 0) {
                n3 += 12;
                --n4;
            }
            ++n3;
            int n5 = this.day;
            while (!DateValue.isValidDate(n4, n3, n5)) {
                --n5;
            }
            return new DateValue(n4, (byte)n3, (byte)n5, this.getTimezoneInMinutes());
        }
        DynamicError dynamicError = new DynamicError("Date arithmetic is not supported on xs:duration, only on its subtypes");
        dynamicError.setIsTypeError(true);
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DayTimeDurationValue subtract(CalendarValue calendarValue, XPathContext xPathContext) throws XPathException {
        if (!(calendarValue instanceof DateValue)) {
            DynamicError dynamicError = new DynamicError("First operand of '-' is a date, but the second is not");
            dynamicError.setIsTypeError(true);
            dynamicError.setErrorCode("XPTY0004");
            throw dynamicError;
        }
        return super.subtract(calendarValue, xPathContext);
    }

    public static int getJulianDayNumber(int n, int n2, int n3) {
        int n4 = n - (n2 < 3 ? 1 : 0);
        short s = monthData[n2 - 1];
        if (n4 >= 0) {
            return n3 + s + 365 * n4 + n4 / 4 - n4 / 100 + n4 / 400 + 1721118;
        }
        int n5 = n3 + s + 365 * (n4 += 12000) + n4 / 4 - n4 / 100 + n4 / 400 + 1721118;
        return n5 - 4382910;
    }

    public static DateValue dateFromJulianDayNumber(int n) {
        if (n >= 0) {
            int n2 = n + 68569 + 1;
            int n3 = 4 * n2 / 146097;
            int n4 = 4000 * ((n2 -= (146097 * n3 + 3) / 4) + 1) / 1461001;
            n2 = n2 - 1461 * n4 / 4 + 31;
            int n5 = 80 * n2 / 2447;
            int n6 = n2 - 2447 * n5 / 80;
            n2 = n5 / 11;
            int n7 = n5 + 2 - 12 * n2;
            int n8 = 100 * (n3 - 49) + n4 + n2;
            return new DateValue(n8, (byte)n7, (byte)n6);
        }
        DateValue dateValue = DateValue.dateFromJulianDayNumber(n + 4382910);
        dateValue.year -= 12000;
        return dateValue;
    }

    public static final int getDayWithinYear(int n, int n2, int n3) {
        int n4 = DateValue.getJulianDayNumber(n, n2, n3);
        int n5 = DateValue.getJulianDayNumber(n, 1, 1);
        return n4 - n5 + 1;
    }

    public static final int getDayOfWeek(int n, int n2, int n3) {
        int n4 = DateValue.getJulianDayNumber(n, n2, n3);
        n4 -= 2378500;
        while (n4 <= 0) {
            n4 += 70000000;
        }
        return (n4 - 1) % 7 + 1;
    }

    public static final int getWeekNumber(int n, int n2, int n3) {
        int n4 = DateValue.getDayWithinYear(n, n2, n3);
        int n5 = DateValue.getDayOfWeek(n, 1, 1);
        if (n5 > 4 && n5 + n4 <= 8) {
            return DateValue.getWeekNumber(n - 1, 12, 31);
        }
        int n6 = n5 < 5 ? 1 : 0;
        return (n4 + n5 - 2) / 7 + n6;
    }

    public static final int getWeekNumberWithinMonth(int n, int n2, int n3) {
        int n4 = DateValue.getDayOfWeek(n, n2, 1);
        int n5 = n4 < 5 ? 1 : 0;
        return (n3 + n4 - 2) / 7 + n5;
    }

    public Comparable getXPathComparable() {
        return this;
    }

    public static void main(String[] stringArray) throws Exception {
        DateValue dateValue = new DateValue(stringArray[0]);
        System.out.println(dateValue.getStringValue());
        int n = DateValue.getJulianDayNumber(dateValue.year, dateValue.month, dateValue.day);
        System.out.println(n);
        System.out.println(DateValue.dateFromJulianDayNumber(n).getStringValue());
    }
}

