/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.editview;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.caseditor.editor.AbstractDocumentListener;
import org.apache.uima.caseditor.editor.ArrayValue;
import org.apache.uima.caseditor.editor.CasEditorError;
import org.apache.uima.caseditor.editor.FeatureValue;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

final class FeatureStructureContentProvider
extends AbstractDocumentListener
implements ITreeContentProvider {
    private ICasDocument mDocument;
    private Viewer viewer;

    FeatureStructureContentProvider(ICasDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("document parameter must not be null!");
        }
        this.mDocument = document;
    }

    private int arraySize(FeatureStructure value) {
        int size;
        if (!value.getType().isArray()) {
            throw new IllegalArgumentException();
        }
        if (value instanceof ArrayFS) {
            ArrayFS array = (ArrayFS)value;
            size = array.size();
        } else if (value instanceof CommonArrayFS) {
            CommonArrayFS array = (CommonArrayFS)value;
            size = array.size();
        } else if (value instanceof StringArrayFS) {
            StringArrayFS array = (StringArrayFS)value;
            size = array.size();
        } else {
            throw new CasEditorError("Unkown array type!");
        }
        return size;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null) {
            FeatureStructure featureStructure = (FeatureStructure)inputElement;
            Type type = featureStructure.getType();
            if (!type.isArray()) {
                LinkedList<FeatureValue> featureValues = new LinkedList<FeatureValue>();
                for (Feature feature : type.getFeatures()) {
                    featureValues.add(new FeatureValue(this.mDocument, featureStructure, feature));
                }
                return featureValues.toArray();
            }
            int size = this.arraySize(featureStructure);
            Object[] arrayValues = new ArrayValue[size];
            for (int i = 0; i < size; ++i) {
                arrayValues[i] = new ArrayValue(featureStructure, i);
            }
            return arrayValues;
        }
        return new Object[0];
    }

    public void dispose() {
        if (this.mDocument != null) {
            this.mDocument.removeChangeListener(this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (newInput != null) {
            Display.getDefault().syncExec(() -> ((Viewer)viewer).refresh());
        }
    }

    @Override
    public void added(Collection<FeatureStructure> newFeatureStructure) {
    }

    @Override
    public void viewChanged(String oldViewName, String newViewName) {
        this.changed();
    }

    @Override
    public void changed() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FeatureStructureContentProvider.this.viewer.setInput(null);
            }
        });
    }

    @Override
    public void removed(Collection<FeatureStructure> deletedFeatureStructure) {
        for (FeatureStructure fs : deletedFeatureStructure) {
            if (this.viewer.getInput() != fs) continue;
            this.viewer.setInput(null);
            break;
        }
    }

    @Override
    public void updated(Collection<FeatureStructure> featureStructure) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FeatureStructureContentProvider.this.viewer.setSelection(FeatureStructureContentProvider.this.viewer.getSelection());
                FeatureStructureContentProvider.this.viewer.refresh();
            }
        });
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof FeatureValue) {
            FeatureValue value = (FeatureValue)parentElement;
            if (!value.getFeature().getRange().isArray()) {
                FeatureStructure childStructure = (FeatureStructure)value.getValue();
                return this.getElements(childStructure);
            }
            FeatureStructure arrayFS = value.getFeatureStructure().getFeatureValue(value.getFeature());
            return this.getElements(arrayFS);
        }
        if (parentElement instanceof ArrayValue) {
            ArrayValue value = (ArrayValue)parentElement;
            ArrayFS array = (ArrayFS)value.getFeatureStructure();
            return this.getElements(array.get(value.slot()));
        }
        throw new CasEditorError("Unexpected element type!");
    }

    public Object getParent(Object element) {
        return null;
    }

    private boolean hasChildren(FeatureStructure value) {
        boolean result = value != null ? (value.getType().isArray() ? this.arraySize(value) > 0 : value.getType().getFeatures().size() > 0) : false;
        return result;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof FeatureValue) {
            FeatureValue value = (FeatureValue)element;
            if (value.getFeature().getRange().isPrimitive()) {
                return false;
            }
            return this.hasChildren((FeatureStructure)value.getValue());
        }
        if (element instanceof ArrayValue) {
            ArrayValue value = (ArrayValue)element;
            if (value.getFeatureStructure() instanceof ArrayFS) {
                ArrayFS array = (ArrayFS)value.getFeatureStructure();
                return this.hasChildren(array.get(value.slot()));
            }
            return false;
        }
        throw new CasEditorError("Unkown element type");
    }
}

