/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.scripting;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SecureFilteringClassLoader
extends ClassLoader {
    private Set<String> allowedClasses = null;
    private Set<String> forbiddenClasses = null;
    private static Set<String> defaultAllowedClasses;
    private static Set<String> defaultForbiddenClasses;
    ClassLoader delegate;

    public SecureFilteringClassLoader(ClassLoader delegate) {
        this(defaultAllowedClasses, defaultForbiddenClasses, delegate);
    }

    public SecureFilteringClassLoader(Set<String> allowedClasses, Set<String> forbiddenClasses, ClassLoader delegate) {
        super(delegate);
        this.allowedClasses = allowedClasses;
        this.forbiddenClasses = forbiddenClasses;
        this.delegate = delegate;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.forbiddenClasses != null && this.classNameMatches(this.forbiddenClasses, name)) {
            throw new ClassNotFoundException("Access to class " + name + " not allowed");
        }
        if (this.allowedClasses != null && !this.classNameMatches(this.allowedClasses, name)) {
            throw new ClassNotFoundException("Access to class " + name + " not allowed");
        }
        return this.delegate.loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.forbiddenClasses != null && this.classNameMatches(this.forbiddenClasses, name)) {
            throw new ClassNotFoundException("Access to class " + name + " not allowed");
        }
        if (this.allowedClasses != null && !this.classNameMatches(this.allowedClasses, name)) {
            throw new ClassNotFoundException("Access to class " + name + " not allowed");
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private boolean classNameMatches(Set<String> classesToTest, String className) {
        for (String classToTest : classesToTest) {
            if (!(classToTest.endsWith("*") ? className.startsWith(classToTest.substring(0, classToTest.length() - 1)) : className.equals(classToTest))) continue;
            return true;
        }
        return false;
    }

    static {
        String systemForbiddenClasses;
        defaultAllowedClasses = null;
        defaultForbiddenClasses = null;
        String systemAllowedClasses = System.getProperty("org.apache.unomi.scripting.allow", "org.apache.unomi.api.Event,org.apache.unomi.api.Profile,org.apache.unomi.api.Session,org.apache.unomi.api.Item,org.apache.unomi.api.CustomItem,ognl.*,java.lang.Object,java.util.Map,java.util.HashMap,java.lang.Integer,org.mvel2.*,java.lang.String");
        if (systemAllowedClasses != null) {
            if ("all".equals(systemAllowedClasses.trim())) {
                defaultAllowedClasses = null;
            } else if (systemAllowedClasses.trim().length() > 0) {
                String[] systemAllowedClassesParts = systemAllowedClasses.split(",");
                defaultAllowedClasses = new HashSet<String>();
                defaultAllowedClasses.addAll(Arrays.asList(systemAllowedClassesParts));
            } else {
                defaultAllowedClasses = null;
            }
        }
        if ((systemForbiddenClasses = System.getProperty("org.apache.unomi.scripting.forbid", null)) != null) {
            if (systemForbiddenClasses.trim().length() > 0) {
                String[] systemForbiddenClassesParts = systemForbiddenClasses.split(",");
                defaultForbiddenClasses = new HashSet<String>();
                defaultForbiddenClasses.addAll(Arrays.asList(systemForbiddenClassesParts));
            } else {
                defaultForbiddenClasses = null;
            }
        }
    }
}

