/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.tracker;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.karaf.util.tracker.SingleServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseActivator
implements BundleActivator,
Runnable,
ThreadFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BundleContext bundleContext;
    protected ExecutorService executor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this);
    private AtomicBoolean scheduled = new AtomicBoolean();
    private long schedulerStopTimeout = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private final Queue<ServiceRegistration> registrations = new ConcurrentLinkedQueue<ServiceRegistration>();
    private Map<String, SingleServiceTracker> trackers = new HashMap<String, SingleServiceTracker>();
    private ServiceRegistration managedServiceRegistration;
    private Dictionary<String, ?> configuration;
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public BaseActivator() {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "activator-" + poolNumber.getAndIncrement() + "-thread-";
    }

    public long getSchedulerStopTimeout() {
        return this.schedulerStopTimeout;
    }

    public void setSchedulerStopTimeout(long schedulerStopTimeout) {
        this.schedulerStopTimeout = schedulerStopTimeout;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.scheduled.set(true);
        this.doOpen();
        this.scheduled.set(false);
        if (this.managedServiceRegistration == null && this.trackers.values().stream().allMatch(t -> t.getService() != null)) {
            try {
                this.doStart();
            }
            catch (Throwable e) {
                this.logger.warn("Error starting activator", e);
                this.doStop();
            }
        } else {
            this.reconfigure();
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.scheduled.set(true);
        this.doClose();
        this.executor.shutdown();
        this.executor.awaitTermination(this.schedulerStopTimeout, TimeUnit.MILLISECONDS);
        this.doStop();
    }

    protected void doOpen() throws Exception {
        URL data = this.bundleContext.getBundle().getResource("OSGI-INF/karaf-tracker/" + this.getClass().getName());
        if (data != null) {
            Properties props = new Properties();
            try (InputStream is = data.openStream();){
                props.load(is);
            }
            for (String key : props.stringPropertyNames()) {
                if ("pid".equals(key)) {
                    this.manage(props.getProperty(key));
                    continue;
                }
                this.trackService(key, props.getProperty(key));
            }
        }
    }

    protected void doClose() {
        if (this.managedServiceRegistration != null) {
            this.managedServiceRegistration.unregister();
        }
        for (SingleServiceTracker tracker : this.trackers.values()) {
            tracker.close();
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() {
        ServiceRegistration reg;
        while ((reg = this.registrations.poll()) != null) {
            reg.unregister();
        }
    }

    protected boolean ensureStartupConfiguration(String configId) throws IOException {
        if (this.configuration != null) {
            return true;
        }
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin != null) {
            Dictionary properties;
            Configuration configuration = configurationAdmin.getConfiguration(configId);
            Dictionary dictionary = properties = configuration == null ? null : configuration.getProperties();
            if (properties != null) {
                this.configuration = properties;
                return true;
            }
        }
        return false;
    }

    protected void manage(String pid) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", pid);
        this.managedServiceRegistration = this.bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)this, props);
    }

    public void updated(Dictionary<String, ?> properties) {
        this.configuration = properties;
        this.reconfigure();
    }

    protected Dictionary<String, ?> getConfiguration() {
        return this.configuration;
    }

    protected int getInt(String key, int def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val != null) {
                return Integer.parseInt(val.toString());
            }
        }
        return def;
    }

    protected boolean getBoolean(String key, boolean def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            if (val != null) {
                return Boolean.parseBoolean(val.toString());
            }
        }
        return def;
    }

    protected long getLong(String key, long def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Number) {
                return ((Number)val).longValue();
            }
            if (val != null) {
                return Long.parseLong(val.toString());
            }
        }
        return def;
    }

    protected String getString(String key, String def) {
        Object val;
        if (this.configuration != null && (val = this.configuration.get(key)) != null) {
            return val.toString();
        }
        return def;
    }

    protected Class<?>[] getClassesArray(String key, String def) {
        String[] stringArray = this.getStringArray(key, def);
        if (stringArray == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return (Class[])Stream.of(stringArray).map(it -> {
            try {
                return loader.loadClass(it.trim());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }).toArray(Class[]::new);
    }

    protected String[] getStringArray(String key, String def) {
        String val = null;
        if (this.configuration != null) {
            val = this.configuration.get(key);
        }
        if (val == null) {
            val = def;
        }
        if (val == null) {
            return null;
        }
        if (val instanceof String[]) {
            return (String[])val;
        }
        if (val instanceof Iterable) {
            return (String[])StreamSupport.stream(((Iterable)((Object)val)).spliterator(), false).map(Object::toString).toArray(String[]::new);
        }
        return val.toString().split("\\s*,\\s*");
    }

    protected void reconfigure() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.executor.submit(this);
        }
    }

    @Override
    public void run() {
        this.scheduled.set(false);
        this.doStop();
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.logger.warn("Error starting activator", (Throwable)e);
            this.doStop();
        }
    }

    protected void trackService(Class<?> clazz) throws InvalidSyntaxException {
        if (!this.trackers.containsKey(clazz.getName())) {
            SingleServiceTracker<Object> tracker = new SingleServiceTracker<Object>(this.bundleContext, clazz, (u, v) -> this.reconfigure());
            tracker.open();
            this.trackers.put(clazz.getName(), tracker);
        }
    }

    protected void trackService(Class<?> clazz, String filter) throws InvalidSyntaxException {
        if (!this.trackers.containsKey(clazz.getName())) {
            if (filter != null && filter.isEmpty()) {
                filter = null;
            }
            SingleServiceTracker<Object> tracker = new SingleServiceTracker<Object>(this.bundleContext, clazz, filter, (u, v) -> this.reconfigure());
            tracker.open();
            this.trackers.put(clazz.getName(), tracker);
        }
    }

    protected void trackService(String className, String filter) throws InvalidSyntaxException {
        if (!this.trackers.containsKey(className)) {
            SingleServiceTracker<Object> tracker = new SingleServiceTracker<Object>(this.bundleContext, className, filter, (u, v) -> this.reconfigure());
            tracker.open();
            this.trackers.put(className, tracker);
        }
    }

    protected <T> T getTrackedService(Class<T> clazz) {
        SingleServiceTracker tracker = this.trackers.get(clazz.getName());
        if (tracker == null) {
            throw new IllegalStateException("Service not tracked for class " + clazz);
        }
        return clazz.cast(tracker.getService());
    }

    protected <T> ServiceReference<T> getTrackedServiceRef(Class<T> clazz) {
        SingleServiceTracker tracker = this.trackers.get(clazz.getName());
        if (tracker == null) {
            throw new IllegalStateException("Service not tracked for class " + clazz);
        }
        return tracker.getServiceReference();
    }

    protected void registerMBean(Object mbean, String type) {
        String name = "org.apache.karaf:" + type + ",name=" + System.getProperty("karaf.name");
        this.registerMBeanWithName(mbean, name);
    }

    protected void registerMBeanWithName(Object mbean, String name) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("jmx.objectname", name);
        this.trackRegistration(this.bundleContext.registerService(this.getInterfaceNames(mbean), mbean, props));
    }

    protected <T> void register(Class<T> clazz, T service) {
        this.register(clazz, service, null);
    }

    protected <T> void register(Class<T> clazz, T service, Dictionary<String, ?> props) {
        this.trackRegistration(this.bundleContext.registerService(clazz, service, props));
    }

    protected void register(Class[] clazz, Object service) {
        this.register(clazz, service, null);
    }

    protected void register(Class[] clazz, Object service, Dictionary<String, ?> props) {
        String[] names = new String[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            names[i] = clazz[i].getName();
        }
        this.trackRegistration(this.bundleContext.registerService(names, service, props));
    }

    private void trackRegistration(ServiceRegistration registration) {
        this.registrations.add(registration);
    }

    protected String[] getInterfaceNames(Object object) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> cl = object.getClass(); cl != Object.class; cl = cl.getSuperclass()) {
            this.addSuperInterfaces(names, cl);
        }
        return names.toArray(new String[names.size()]);
    }

    private void addSuperInterfaces(List<String> names, Class clazz) {
        for (Class<?> cl : clazz.getInterfaces()) {
            names.add(cl.getName());
            this.addSuperInterfaces(names, cl);
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

