/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapFetchNearCacheInvalidationMetadataCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationMetaDataFetcher;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ClientMapInvalidationMetaDataFetcher
extends InvalidationMetaDataFetcher {
    private final ClientClusterService clusterService;
    private final HazelcastClientInstanceImpl clientImpl;

    public ClientMapInvalidationMetaDataFetcher(ClientContext clientContext) {
        super(clientContext.getLoggingService().getLogger(ClientMapInvalidationMetaDataFetcher.class));
        this.clusterService = clientContext.getClusterService();
        this.clientImpl = (HazelcastClientInstanceImpl)clientContext.getHazelcastInstance();
    }

    @Override
    protected Collection<Member> getDataMembers() {
        return this.clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
    }

    @Override
    protected InternalCompletableFuture fetchMetadataOf(Address address, List<String> names) {
        ClientMessage message = MapFetchNearCacheInvalidationMetadataCodec.encodeRequest(names, address);
        ClientInvocation invocation = new ClientInvocation(this.clientImpl, message, null, address);
        return invocation.invoke();
    }

    @Override
    protected void extractMemberMetadata(Member member, InternalCompletableFuture future, InvalidationMetaDataFetcher.MetadataHolder metadataHolder) throws Exception {
        ClientMessage message = (ClientMessage)future.get(1L, TimeUnit.MINUTES);
        MapFetchNearCacheInvalidationMetadataCodec.ResponseParameters response = MapFetchNearCacheInvalidationMetadataCodec.decodeResponse(message);
        metadataHolder.setMetadata(response.partitionUuidList, response.namePartitionSequenceList);
    }
}

