/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.Nullable;

public final class XMoreLikeThis {
    public static final int DEFAULT_MAX_NUM_TOKENS_PARSED = 5000;
    public static final int DEFAULT_MIN_TERM_FREQ = 2;
    public static final int DEFAULT_MIN_DOC_FREQ = 5;
    public static final int DEFAULT_MAX_DOC_FREQ = Integer.MAX_VALUE;
    public static final boolean DEFAULT_BOOST = false;
    public static final String[] DEFAULT_FIELD_NAMES = new String[]{"contents"};
    public static final int DEFAULT_MIN_WORD_LENGTH = 0;
    public static final int DEFAULT_MAX_WORD_LENGTH = 0;
    public static final Set<?> DEFAULT_STOP_WORDS = null;
    private Set<?> stopWords = DEFAULT_STOP_WORDS;
    public static final int DEFAULT_MAX_QUERY_TERMS = 25;
    private Analyzer analyzer = null;
    private int minTermFreq = 2;
    private int minDocFreq = 5;
    private int maxDocFreq = Integer.MAX_VALUE;
    private boolean boost = false;
    private Set<Term> skipTerms = null;
    private String[] fieldNames = DEFAULT_FIELD_NAMES;
    private int maxNumTokensParsed = 5000;
    private int minWordLen = 0;
    private int maxWordLen = 0;
    private int maxQueryTerms = 25;
    private TFIDFSimilarity similarity;
    private final IndexReader ir;
    private float boostFactor = 1.0f;

    public float getBoostFactor() {
        return this.boostFactor;
    }

    public void setBoostFactor(float boostFactor) {
        this.boostFactor = boostFactor;
    }

    public void setSkipTerms(Set<Term> skipTerms) {
        this.skipTerms = skipTerms;
    }

    public XMoreLikeThis(IndexReader ir) {
        this(ir, (TFIDFSimilarity)new ClassicSimilarity());
    }

    public XMoreLikeThis(IndexReader ir, TFIDFSimilarity sim) {
        this.ir = ir;
        this.similarity = sim;
    }

    public TFIDFSimilarity getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(TFIDFSimilarity similarity) {
        this.similarity = similarity;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public int getMinTermFreq() {
        return this.minTermFreq;
    }

    public void setMinTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public int getMaxDocFreq() {
        return this.maxDocFreq;
    }

    public void setMaxDocFreq(int maxFreq) {
        this.maxDocFreq = maxFreq;
    }

    public void setMaxDocFreqPct(int maxPercentage) {
        this.maxDocFreq = maxPercentage * this.ir.numDocs() / 100;
    }

    public boolean isBoost() {
        return this.boost;
    }

    public void setBoost(boolean boost) {
        this.boost = boost;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public int getMinWordLen() {
        return this.minWordLen;
    }

    public void setMinWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
    }

    public int getMaxWordLen() {
        return this.maxWordLen;
    }

    public void setMaxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
    }

    public void setStopWords(Set<?> stopWords) {
        this.stopWords = stopWords;
    }

    public Set<?> getStopWords() {
        return this.stopWords;
    }

    public int getMaxQueryTerms() {
        return this.maxQueryTerms;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public int getMaxNumTokensParsed() {
        return this.maxNumTokensParsed;
    }

    public void setMaxNumTokensParsed(int i) {
        this.maxNumTokensParsed = i;
    }

    public Query like(int docNum) throws IOException {
        if (this.fieldNames == null) {
            Collection fields = FieldInfos.getIndexedFields((IndexReader)this.ir);
            this.fieldNames = fields.toArray(new String[fields.size()]);
        }
        return this.createQuery(this.retrieveTerms(docNum));
    }

    public Query like(String fieldName, Reader ... readers) throws IOException {
        HashMap<String, Int> words = new HashMap<String, Int>();
        for (Reader r : readers) {
            this.addTermFrequencies(r, words, fieldName);
        }
        return this.createQuery(this.createQueue(words));
    }

    public Query like(Terms ... likeTerms) throws IOException {
        HashMap<String, Int> termFreqMap = new HashMap<String, Int>();
        for (Terms vector : likeTerms) {
            this.addTermFrequencies(termFreqMap, vector);
        }
        return this.createQuery(this.createQueue(termFreqMap));
    }

    public Query like(Fields ... likeFields) throws IOException {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Fields fields : likeFields) {
            for (String fieldName : fields) {
                fieldNames.add(fieldName);
            }
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (String fieldName : fieldNames) {
            HashMap<String, Int> termFreqMap = new HashMap<String, Int>();
            for (Fields fields : likeFields) {
                Terms vector = fields.terms(fieldName);
                if (vector == null) continue;
                this.addTermFrequencies(termFreqMap, vector, fieldName);
            }
            this.addToQuery(this.createQueue(termFreqMap, fieldName), bq);
        }
        return bq.build();
    }

    private Query createQuery(PriorityQueue<ScoreTerm> q) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        this.addToQuery(q, query);
        return query.build();
    }

    private void addToQuery(PriorityQueue<ScoreTerm> q, BooleanQuery.Builder query) {
        ScoreTerm scoreTerm;
        float bestScore = -1.0f;
        while ((scoreTerm = (ScoreTerm)q.pop()) != null) {
            TermQuery tq = new TermQuery(new Term(scoreTerm.topField, scoreTerm.word));
            if (this.boost) {
                if (bestScore == -1.0f) {
                    bestScore = scoreTerm.score;
                }
                float myScore = scoreTerm.score;
                tq = new BoostQuery((Query)tq, this.boostFactor * myScore / bestScore);
            }
            try {
                query.add((Query)tq, BooleanClause.Occur.SHOULD);
            }
            catch (BooleanQuery.TooManyClauses ignore) {
                break;
            }
        }
    }

    private PriorityQueue<ScoreTerm> createQueue(Map<String, Int> words) throws IOException {
        return this.createQueue(words, this.fieldNames);
    }

    private PriorityQueue<ScoreTerm> createQueue(Map<String, Int> words, String ... fieldNames) throws IOException {
        int numDocs = this.ir.numDocs();
        int limit = Math.min(this.maxQueryTerms, words.size());
        FreqQ queue = new FreqQ(limit);
        for (String word : words.keySet()) {
            int tf = words.get((Object)word).x;
            if (this.minTermFreq > 0 && tf < this.minTermFreq) continue;
            String topField = fieldNames[0];
            int docFreq = 0;
            for (String fieldName : fieldNames) {
                int freq = this.ir.docFreq(new Term(fieldName, word));
                topField = freq > docFreq ? fieldName : topField;
                docFreq = freq > docFreq ? freq : docFreq;
            }
            if (this.minDocFreq > 0 && docFreq < this.minDocFreq || docFreq > this.maxDocFreq || docFreq == 0) continue;
            float idf = this.similarity.idf((long)docFreq, (long)numDocs);
            float score = (float)tf * idf;
            if (queue.size() < limit) {
                queue.add(new ScoreTerm(word, topField, score));
                continue;
            }
            ScoreTerm term = (ScoreTerm)queue.top();
            if (!(term.score < score)) continue;
            term.update(word, topField, score);
            queue.updateTop();
        }
        return queue;
    }

    public String describeParams() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t").append("maxQueryTerms  : ").append(this.maxQueryTerms).append("\n");
        sb.append("\t").append("minWordLen     : ").append(this.minWordLen).append("\n");
        sb.append("\t").append("maxWordLen     : ").append(this.maxWordLen).append("\n");
        sb.append("\t").append("fieldNames     : ");
        String delim = "";
        for (String fieldName : this.fieldNames) {
            sb.append(delim).append(fieldName);
            delim = ", ";
        }
        sb.append("\n");
        sb.append("\t").append("boost          : ").append(this.boost).append("\n");
        sb.append("\t").append("minTermFreq    : ").append(this.minTermFreq).append("\n");
        sb.append("\t").append("minDocFreq     : ").append(this.minDocFreq).append("\n");
        return sb.toString();
    }

    private PriorityQueue<ScoreTerm> retrieveTerms(int docNum) throws IOException {
        HashMap<String, Int> termFreqMap = new HashMap<String, Int>();
        for (String fieldName : this.fieldNames) {
            Fields vectors = this.ir.getTermVectors(docNum);
            Terms vector = vectors != null ? vectors.terms(fieldName) : null;
            if (vector == null) {
                IndexableField[] fields;
                Document d = this.ir.document(docNum);
                for (IndexableField field : fields = d.getFields(fieldName)) {
                    String stringValue = field.stringValue();
                    if (stringValue == null) continue;
                    this.addTermFrequencies(new StringReader(stringValue), termFreqMap, fieldName);
                }
                continue;
            }
            this.addTermFrequencies(termFreqMap, vector, fieldName);
        }
        return this.createQueue(termFreqMap);
    }

    private void addTermFrequencies(Map<String, Int> termFreqMap, Terms vector) throws IOException {
        this.addTermFrequencies(termFreqMap, vector, null);
    }

    private void addTermFrequencies(Map<String, Int> termFreqMap, Terms vector, @Nullable String fieldName) throws IOException {
        BytesRef text;
        TermsEnum termsEnum = vector.iterator();
        CharsRefBuilder spare = new CharsRefBuilder();
        while ((text = termsEnum.next()) != null) {
            spare.copyUTF8Bytes(text);
            String term = spare.toString();
            if (this.isNoiseWord(term) || this.isSkipTerm(fieldName, term)) continue;
            PostingsEnum docs = termsEnum.postings(null);
            int freq = 0;
            while (docs != null && docs.nextDoc() != Integer.MAX_VALUE) {
                freq += docs.freq();
            }
            Int cnt = termFreqMap.get(term);
            if (cnt == null) {
                cnt = new Int();
                termFreqMap.put(term, cnt);
                cnt.x = freq;
                continue;
            }
            cnt.x += freq;
        }
    }

    private void addTermFrequencies(Reader r, Map<String, Int> termFreqMap, String fieldName) throws IOException {
        if (this.analyzer == null) {
            throw new UnsupportedOperationException("To use MoreLikeThis without term vectors, you must provide an Analyzer");
        }
        try (TokenStream ts = this.analyzer.tokenStream(fieldName, r);){
            int tokenCount = 0;
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                String word = termAtt.toString();
                if (++tokenCount > this.maxNumTokensParsed) break;
                if (this.isNoiseWord(word) || this.isSkipTerm(fieldName, word)) continue;
                Int cnt = termFreqMap.get(word);
                if (cnt == null) {
                    termFreqMap.put(word, new Int());
                    continue;
                }
                ++cnt.x;
            }
            ts.end();
        }
    }

    private boolean isNoiseWord(String term) {
        int len = term.length();
        if (this.minWordLen > 0 && len < this.minWordLen) {
            return true;
        }
        if (this.maxWordLen > 0 && len > this.maxWordLen) {
            return true;
        }
        return this.stopWords != null && this.stopWords.contains(term);
    }

    private boolean isSkipTerm(@Nullable String field, String value) {
        return field != null && this.skipTerms != null && this.skipTerms.contains(new Term(field, value));
    }

    private PriorityQueue<ScoreTerm> retrieveTerms(Reader r, String fieldName) throws IOException {
        HashMap<String, Int> words = new HashMap<String, Int>();
        this.addTermFrequencies(r, words, fieldName);
        return this.createQueue(words);
    }

    public String[] retrieveInterestingTerms(int docNum) throws IOException {
        ScoreTerm scoreTerm;
        ArrayList<String> al = new ArrayList<String>(this.maxQueryTerms);
        PriorityQueue<ScoreTerm> pq = this.retrieveTerms(docNum);
        int lim = this.maxQueryTerms;
        while ((scoreTerm = (ScoreTerm)pq.pop()) != null && lim-- > 0) {
            al.add(scoreTerm.word);
        }
        String[] res = new String[al.size()];
        return al.toArray(res);
    }

    public String[] retrieveInterestingTerms(Reader r, String fieldName) throws IOException {
        ScoreTerm scoreTerm;
        ArrayList<String> al = new ArrayList<String>(this.maxQueryTerms);
        PriorityQueue<ScoreTerm> pq = this.retrieveTerms(r, fieldName);
        int lim = this.maxQueryTerms;
        while ((scoreTerm = (ScoreTerm)pq.pop()) != null && lim-- > 0) {
            al.add(scoreTerm.word);
        }
        String[] res = new String[al.size()];
        return al.toArray(res);
    }

    private static class Int {
        int x = 1;

        Int() {
        }
    }

    private static class ScoreTerm {
        String word;
        String topField;
        float score;

        ScoreTerm(String word, String topField, float score) {
            this.word = word;
            this.topField = topField;
            this.score = score;
        }

        void update(String word, String topField, float score) {
            this.word = word;
            this.topField = topField;
            this.score = score;
        }
    }

    private static class FreqQ
    extends PriorityQueue<ScoreTerm> {
        FreqQ(int maxSize) {
            super(maxSize);
        }

        protected boolean lessThan(ScoreTerm a, ScoreTerm b) {
            return a.score < b.score;
        }
    }
}

